package com.openexchange.guard.server.authentication;

import javax.servlet.http.HttpServletRequest;


/**
 * Class for handling available roles in OX Guard
 */
public class GuardAuthRoles {

    /*
     * A set of roles defines for OX Guard
     */
    private static GuardAuthRole[] availableRoles =
        new GuardAuthRole[] {
            GuardAuthRole.User,
            GuardAuthRole.OXBackend,
            GuardAuthRole.SupportAPI
        };

    /**
     * Gets a list of available roles, defined for OX Guard
     * @return a set of roles
     */
    public static GuardAuthRole[] getAvailableRoles() {
        return availableRoles;
    }

    /**
     * Checks if a user is in a certain role
     * @param request the user's request for which he has been authenticated
     * @param role the role to check for
     * @return true if the user is in the given role, false otherwise
     */
    public static boolean isUserInRole(HttpServletRequest request, GuardAuthRole role) {
        return request.isUserInRole(role.name());
    }
}
