/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.InternetAddress;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.config.OxConfiguration;
import com.openexchange.guard.database.Access;
import com.openexchange.guard.database.EmailInfo;
import com.openexchange.guard.database.GetPubKey;
import com.openexchange.guard.database.RecipKey;
import com.openexchange.guard.database.RetrievedItem;
import com.openexchange.guard.encr.Crypto;
import com.openexchange.guard.encr.EncrLib;
import com.openexchange.guard.encr.EncryptedObj;
import com.openexchange.guard.exceptions.GuardMissingParameter;
import com.openexchange.guard.logging.LogAction;
import com.openexchange.guard.mail.Attachments;
import com.openexchange.guard.mail.Draft;
import com.openexchange.guard.mail.Getter;
import com.openexchange.guard.mail.Incoming;
import com.openexchange.guard.mailcreator.Attachment;
import com.openexchange.guard.mailcreator.Mail;
import com.openexchange.guard.ox.Api;
import com.openexchange.guard.ox.InterOx;
import com.openexchange.guard.ox.Languages;
import com.openexchange.guard.server.Settings.permissions;
import com.openexchange.guard.translate.GetText;
import com.openexchange.guard.util.Core;
import com.openexchange.guard.validator.Normalizer;

public class MailHandler {
	
	private static Logger logger = LoggerFactory.getLogger(MailHandler.class);
	
    OxCookie cookie;
    HttpServletRequest req;
    String sessionId;

    public MailHandler(OxCookie ck, HttpServletRequest rq) {
        cookie = ck;
        req = rq;
    }


    public void incomingEmailForm(HttpServletRequest request, HttpServletResponse response) throws Exception {
    	Incoming in = new Incoming (cookie, req);
    	in.incomingEmailForm(request, response);
    }
    
    public void incomingDraftForm(HttpServletRequest request, HttpServletResponse response) throws IOException, GuardMissingParameter {
    	Draft in = new Draft (cookie, req);
    	in.incomingEmailForm(request, response);
    }

    public void getEncrEmail(HttpServletRequest request, HttpServletResponse response, com.openexchange.guard.server.OxCookie cookie) throws Exception {
    	Getter getter = new Getter();
    	getter.getEncrEmail(request, response, cookie);
    }

   
    public void getEncrAttach(HttpServletRequest request, HttpServletResponse response, com.openexchange.guard.server.OxCookie cookie) throws IOException, GuardMissingParameter {
    	Attachments attachHandle = new Attachments(cookie);
    	attachHandle.getEncrAttach(request, response, cookie);
    }
    
    public void saveDecodedAttach(HttpServletRequest request, HttpServletResponse response, com.openexchange.guard.server.OxCookie cookie) throws IOException, GuardMissingParameter {
    	Attachments attachHandle = new Attachments(cookie);
    	attachHandle.saveDecodedAttach(request, response, cookie);
    }
    
    
 

    /*
     * Get the public key of a recipient
     */
    public void getRecipKey(HttpServletRequest request, HttpServletResponse response) throws Exception {
    	String email = Core.getStringParameter(request, "email", true);
    	InternetAddress em = new InternetAddress(email);
    	email = em.getAddress();

        String from = Core.getStringParameter(request, "from", true);
        int senderid = Core.getIntParameter(request, "userid");
        InternetAddress f = new InternetAddress(from);
        from = f.getAddress();

        GetPubKey acc = new GetPubKey();
        try {
            int cid = Core.getIntParameter(request, "cid", true);
            LogAction.setUser(senderid, cid);
            RecipKey recip = acc.getPubKey(email, senderid, cid, from, false, false);
            JsonObject reply = new JsonObject ();
            reply.addProperty("email", email);
            String keyreply = "unable";
            if (recip != null) {
                response.setContentType("application/json");
                response.addHeader("Access-Control-Allow-Origin", "*");
                response.setStatus(HttpServletResponse.SC_OK);
                reply.addProperty("guest", recip.guest);
                reply.addProperty("inline", recip.inline || recip.reqInline());
                if (recip.pubkey != null) {// If we have a public key, then we are golden
                    keyreply = recip.pubkey.toString().replace("\r", "").replace("\n", "");
                    reply.addProperty("publicKey", keyreply);
                } else {// If we don't have a public key, will be guest, or was unable to create
                	
                    if (!recip.guest) {
                    	if (recip.cid > 0) keyreply = "Will be created on first send";
                    }
                }
                reply.add("pgp", new JsonPrimitive(recip.pgp));
                reply.add("expired", new JsonPrimitive(recip.expired));
            } else {
            	keyreply = "error";
            }
            reply.addProperty("publicKey", keyreply);
            response.getWriter().write(reply.toString());
            LogAction.setSuccess();
        } catch (SQLException e) {
            LogAction.setFail();
            logger.error("SQL error getting public key of recipient " + email, e);
        } catch (IOException e) {
            LogAction.setFail();
            logger.error("IO error getting public key of recipient " + email, e);
        }

    }

    /**
     * Get the read count of an email item. Will query remote services
     * 
     * @param request
     * @param response
     * @throws GuardMissingParameter 
     */
    public void getReadCount(HttpServletRequest request, HttpServletResponse response) throws GuardMissingParameter {
    	String itemID = Core.getStringParameter(request, "item", true);
    	try {
            JsonArray users = new JsonArray();
            int userid = Core.getIntParameter(request, "userid", true);
            int cid = Core.getIntParameter(request, "cid", true);
            LogAction.setUser(userid, cid);
            if ((itemID == null)) {
                com.openexchange.guard.util.Core.sendFail(response, "Bad item id");
                return;
            }
            Access acc = new Access();
            String xml = acc.getXML(userid, cid, itemID);
            // Need to parse xml for the users that received this email
            if (xml == null) {
                com.openexchange.guard.util.Core.sendFail(response, "Not owner or not found");
                return;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            org.w3c.dom.Document doc = builder.parse(new InputSource(new ByteArrayInputStream(xml.getBytes("utf-8"))));
            doc.getDocumentElement().normalize();
            Element share = (Element) doc.getElementsByTagName("share").item(0);
            NodeList shares = share.getElementsByTagName("u");
            InterOx iox = new InterOx();
            for (int i = 0; i < shares.getLength(); i++) {// For each of the users, check count
                JsonObject readcount = new JsonObject();
                Element user = (Element) shares.item(i);
                String email = user.getElementsByTagName("e").item(0).getFirstChild().getTextContent();
                int rcid = Integer.parseInt(user.getElementsByTagName("c").item(0).getFirstChild().getTextContent());
                int ruserid = Integer.parseInt(user.getElementsByTagName("i").item(0).getFirstChild().getTextContent());
                boolean remote = user.getElementsByTagName("r").item(0).getFirstChild().getTextContent().contains("Y");
                int count = -1;
                if (remote) {// If it is remote, then get it from other ox server
                    count = iox.getRemoteReadCount(email, itemID);
                } else {
                    count = acc.getCount(ruserid, rcid, itemID);
                }
                readcount.add("email", new JsonPrimitive(email));// add to our response
                if (Config.showStatus == false) {
                	if (count > -1) count = -9999;
                }
                readcount.add("count", new JsonPrimitive(count));
                users.add(readcount);
            }
            com.openexchange.guard.util.Core.sendOK(response, users.toString());

        } catch (Exception ex) {
            logger.error("Error getting read count for " + itemID, ex);
            com.openexchange.guard.util.Core.sendFail(response, "Error getting count");
        }

    }
    
 
    /**
     * Retract an email item. Will query remote services
     * 
     * @param request
     * @param response
     * @throws GuardMissingParameter 
     */
    public void retractEmail(HttpServletRequest request, HttpServletResponse response, OxCookie cookie) throws GuardMissingParameter {
    	String itemID = Core.getStringParameter(request, "item", true);
    	int userid = Core.getIntParameter(request, "userid", true);
        int cid = Core.getIntParameter(request, "cid", true);
        LogAction.setUser(userid, cid);
        String session = Core.getStringParameter(request, "session", true);
        try {
            String ua = request.getHeader("User-Agent");
            if ((itemID == null)) {
                com.openexchange.guard.util.Core.sendFail(response, "Bad item id");
                return;
            }
            Api ap = new Api(cookie, session, ua);// Verify we are logged in for security
            if (!ap.verifyLogin()) {
                com.openexchange.guard.util.Core.sendFail(response, "Must be logged in");
                return;
            }
            Access acc = new Access();
            String xml = acc.getXML(userid, cid, itemID);
            // Need to parse xml for the users that received this email
            if (xml == null) {
                com.openexchange.guard.util.Core.sendFail(response, "Not owner or not found");
                return;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            org.w3c.dom.Document doc = builder.parse(new InputSource(new ByteArrayInputStream(xml.getBytes("utf-8"))));
            doc.getDocumentElement().normalize();
            Element share = (Element) doc.getElementsByTagName("share").item(0);
            NodeList shares = share.getElementsByTagName("u");
            InterOx iox = new InterOx();
            RetrievedItem obg = acc.getItemID(itemID, userid, cid);
            int retracted = 0;
            boolean delete = Auth.getPermissions(cookie, request).deleteKeyOnRevoke;
            for (int i = 0; i < shares.getLength(); i++) {// For each of the users, check count
                Element user = (Element) shares.item(i);
                String email = user.getElementsByTagName("e").item(0).getFirstChild().getTextContent();
                int ruserid = Integer.parseInt(user.getElementsByTagName("i").item(0).getFirstChild().getTextContent());
                int rcid = Integer.parseInt(user.getElementsByTagName("c").item(0).getFirstChild().getTextContent());
                boolean remote = user.getElementsByTagName("r").item(0).getFirstChild().getTextContent().contains("Y");
                if (remote) {// If it is remote, then get it from other ox server
                    if (iox.retractRemote(email, itemID, obg.salt, delete).contains("OK"))
                        retracted++;
                } else {
                    if (acc.retract(ruserid, rcid, itemID, obg.salt, delete))
                        retracted++;
                }

            }
            if (retracted == shares.getLength()) {
                com.openexchange.guard.util.Core.sendOK(response, "OK");
            } else {
                com.openexchange.guard.util.Core.sendOK(response, "PARTIAL");
            }

        } catch (Exception ex) {
            logger.error("Error retracting an email with itemID " + itemID, ex);
            com.openexchange.guard.util.Core.sendFail(response, "Error retracting an email");
        }

    }

}
