package com.openexchange.guard.server;

import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import com.google.gson.JsonObject;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.ox.Upgrader;
import com.openexchange.guard.server.connectionPooling.HttpConnectionPoolService;
import com.openexchange.guard.setup.MasterPasswordCreator;
import com.openexchange.guard.setup.OxDatabaseCreateor;
import com.openexchange.guard.setup.Repair;

public class HandleArgs {

	public static boolean handle (String [] args) {

		if (args.length == 0) {
            return (false);
        }
		Security.addProvider(new BouncyCastleProvider());
		//OxDbConn.init();
		HttpConnectionPoolService.initialize();
		switch (args[0]) {
		case "init":
			System.out.println("init called, beginning setup");
        	String user = System.getProperty("user.name");
        	if (!user.toLowerCase().contains("root")) {
        		System.out.println("Shows running as " + user);
        		System.out.println("Must run as root.  Sure you want to continue? \"yes\" to continue.");
        		try {
        			String response = System.console().readLine();
        			if (!response.equals("yes")) {
                        return(true);
                    }
        		} catch (NullPointerException ex) {
        			System.out.println("Null response, assuming from debug and continuing");
        		}

        	}

			if (Config.mysqlUsername.length() < 2) {
				System.out.println("Set up configuration file first");
				return(true);
			}
			MasterPasswordCreator cf = new MasterPasswordCreator();
			if (cf.createPasswordFile()) {
				OxDatabaseCreateor cr = new OxDatabaseCreateor();
	            if (cr.create(Config.version)) {
	            	System.out.println("Success.  Done.  Service not yet started");
	            } else {
	            	System.out.println("Fail.  See log files");
	            }
			}
			cf.setPermissions();


            return(true);
		case "reset":
			if (args.length < 2) {
				System.out.println("Must include email address");
				return (true);
			}
			String email = args[1];
			if (com.openexchange.guard.validator.EmailValidator.validate(email)) {
				Auth auth = new Auth();
				try {
					auth.resetPass(email);
				} catch (Exception e) {
					System.out.println("FAILED");
					e.printStackTrace();
				}
			} else {
				System.out.println("Bad email address");
			}
			return(true);
		case "repairshard":
			String userid = System.getProperty("user.name");
        	if (!userid.toLowerCase().contains("root")) {
        		System.out.println("Shows running as " + userid);
        		System.out.println("Must run as root.  Exiting...");
        		return(true);
        	}
        	try {
				Repair.repairShard();
			} catch (Exception e) {
				e.printStackTrace();
			}
        	return(true);
		case "removepin":
			if (args.length < 2) {
				System.out.println("Must include email address");
				return (true);
			}
			String resetemail = args[1];
			if (com.openexchange.guard.validator.EmailValidator.validate(resetemail)) {
				Auth.removePin(resetemail);
			} else {
				System.out.println("Invalid email address");
			}
			return(true);
		case "test":
			if (args.length < 2) {
				System.out.println("Must include email address");
				return (true);
			}
			String testemail = args[1];
			com.openexchange.guard.database.Utilities util = new com.openexchange.guard.database.Utilities();
            JsonObject userdat;
			try {
				userdat = util.getUser(testemail);
	            if (userdat.has(testemail)) {
	            	System.out.println("Response received.  Testing JSON");
	            	System.out.println(userdat.toString());
	            	JsonObject euser = userdat.get(testemail).getAsJsonObject();
	            	System.out.println("User id " + euser.get("uid").getAsInt());
	            	System.out.println("Context " + euser.get("cid").getAsInt());
	                System.out.println("Language " + euser.get("user").getAsJsonObject().get("language").getAsString());
	                System.out.println("Name " + euser.get("user").getAsJsonObject().get("displayName").getAsString());
	                System.out.println("Success");
	                return(true);
	            } else {
	            	System.out.println("Email does not resolve to local");
	            }
			} catch (Exception e1) {
				System.out.println("Error getting email from REST API");
				e1.printStackTrace();
			}
			return(true);
		case "upgrade":
			if (args.length < 2) {
				System.out.println("Must include email address");
				return (true);
			}
			String upgradeemail = args[1];
			if (!com.openexchange.guard.validator.EmailValidator.validate(upgradeemail)) {
				System.out.println("Invalid email");
				return(true);
			}
			String result = "";
			try {
				result = Upgrader.upgrade(upgradeemail);
			} catch (Exception e) {
				e.printStackTrace();
			}
			if (result.equals("OK")) {
				System.out.println("Done");
			} else {
				System.out.println(result);
			}
			return(true);
		case "upgradePGP":
			com.openexchange.guard.setup.Upgrader up = new com.openexchange.guard.setup.Upgrader();
			try {
				up.doPGPUpdateAll();
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			return (true);
		default:
			System.out.println("Usage: ./guard arg");
			System.out.println("Possible arguments are:");
			System.out.println("init: Initialize the database for first use");
			System.out.println("test: tests the specified email against the MailResolver");
			System.out.println("       eg. guard test john@somewhere.com");
			System.out.println("repairshard: Repairs current database shard");
			System.out.println("reset: resets the specified email and sends new password to user");
			System.out.println("       eg. guard reset john@somewhere.com");
			System.out.println("removepin: removes the pin for guest users");
			System.out.println("       eg. guard removepin john@somewhere.com");
			System.out.println("upgrade: Upgrades a guest account to OX account");
			System.out.println("       eg. guard upgrade jogn@somewhere.com");
			System.out.println("upgradePGP: Upgrades from Guard pre 2.0 to PGP");
			break;
		}
		return(true);
	}
}
