package com.openexchange.guard.server;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.database.Access;
import com.openexchange.guard.database.DbCommand;
import com.openexchange.guard.database.DbQuery;
import com.openexchange.guard.encr.GuardKeys;


public class Admin {

    private static Logger logger = LoggerFactory.getLogger(AdminServlet.class);
    
    /**
     * Delete user from the Guard key tables and lookup.  Move keys to deletedKey table
     * @param id
     * @param cid
     * @return
     * @throws Exception
     */
    public boolean delete (int id, int cid) throws Exception {
        Access acc = new Access();
        ArrayList<GuardKeys> keys = acc.getAllKeys(id, cid);
        try {
        for (int i = 0; i < keys.size(); i++) {
            // First, move the key over to the deleted table
            GuardKeys key = keys.get(i);
            String command = "INSERT INTO deletedKeys (id, cid, email, PGPSecret, salt, recovery, version, deleted_date) VALUES ( ?, ?, ?, ?, ?, ?, ?, NOW());";
            DbCommand com = new DbCommand(command);
            com.addVariables(key.userid);
            com.addVariables(key.contextid);
            com.addVariables(key.email);
            com.addVariables(key.getEncodedPGPSecret());
            com.addVariables(key.getSalt());
            com.addVariables(key.recovery);
            com.addVariables(key.version);
            long keyid = key.keyid;
            DbQuery db = new DbQuery();
            db.writeOxGuard(com);
            db.close();
            // Delete the key reference from the PGPKeys lookup table
            command = "DELETE FROM PGPKeys WHERE keyid = ?";
            com = new DbCommand(command);
            com.addVariables(keyid);
            db = new DbQuery();
            db.writeOxGuard(com);
            db.close();
        }
        } catch (Exception ex) {
            logger.error("Problem moving user keys to deleted ", ex);
            return (false);
        }
        try {
            // Delete the key references from the og_email lookup table
            String command = "DELETE FROM og_email WHERE id = ? AND cid = ?";
            DbCommand com = new DbCommand(command);
            com.addVariables(id);
            com.addVariables(cid);
            DbQuery db = new DbQuery();
            db.writeOxGuard(com);
            db.close();
            // OK, finally, do the actual delete of the keys from the keytable
            command = "DELETE FROM og_KeyTable WHERE id = ? AND cid = ?";
            com = new DbCommand(command);
            com.addVariables(id);
            com.addVariables(cid);
            db = new DbQuery();
            db.write(com, id, cid);
            db.close();
        } catch (Exception ex) {
            logger.error("Problem deleting user data ", ex);
            return (false);
        }
        
        return (true);
        
    }
    
    /**
     * Delete context from the Guard key tables and lookup.  Move keys to deletedKey table
     * @param id
     * @param cid
     * @return
     * @throws Exception
     */
    public boolean deleteContext (int cid) throws Exception {
        if (cid < 0) {
            return (false);
        }
        Access acc = new Access();
        ArrayList<GuardKeys> keys = acc.getAllKeysInContext(cid);
        try {
        for (int i = 0; i < keys.size(); i++) {
            // First, move the key over to the deleted table
            GuardKeys key = keys.get(i);
            String command = "INSERT INTO deletedKeys (id, cid, email, PGPSecret, salt, recovery, version, deleted_date) VALUES ( ?, ?, ?, ?, ?, ?, ?, NOW());";
            DbCommand com = new DbCommand(command);
            com.addVariables(key.userid);
            com.addVariables(key.contextid);
            com.addVariables(key.email);
            com.addVariables(key.getEncodedPGPSecret());
            com.addVariables(key.getSalt());
            com.addVariables(key.recovery);
            com.addVariables(key.version);
            long keyid = key.keyid;
            DbQuery db = new DbQuery();
            db.writeOxGuard(com);
            db.close();
            // Delete the key reference from the PGPKeys lookup table
            command = "DELETE FROM PGPKeys WHERE keyid = ?";
            com = new DbCommand(command);
            com.addVariables(keyid);
            db = new DbQuery();
            db.writeOxGuard(com);
            db.close();
        }
        } catch (Exception ex) {
            logger.error("Problem moving user keys to deleted ", ex);
            return (false);
        }
        try {
            // Delete the key references from the og_email lookup table
            String command = "DELETE FROM og_email WHERE cid = ?";
            DbCommand com = new DbCommand(command);
            com.addVariables(cid);
            DbQuery db = new DbQuery();
            db.writeOxGuard(com);
            db.close();
            // OK, finally, do the actual delete of the keys from the keytable
            command = "DELETE FROM og_KeyTable WHERE cid = ?";
            com = new DbCommand(command);
            com.addVariables(cid);
            db = new DbQuery();
            db.writeToDB(com, cid);
            db.close();
        } catch (Exception ex) {
            logger.error("Problem deleting user data ", ex);
            return (false);
        }
        
        return (true);
        
    }
}
