/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.guard.pgp;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.google.gson.JsonObject;
import com.openexchange.guard.database.Access;
import com.openexchange.guard.database.RecipKey;
import com.openexchange.guard.drive.FileEncrypter;
import com.openexchange.guard.encr.EncrLib;
import com.openexchange.guard.encr.GuardKeys;
import com.openexchange.guard.file.FileTyper;
import com.openexchange.guard.mailcreator.Attachment;
import com.openexchange.guard.server.MailHandler;
import com.openexchange.guard.server.OxCookie;
import com.openexchange.guard.server.UserData;
import com.openexchange.guard.util.Core;


public class PGPAttachments {
    private static Logger logger = LoggerFactory.getLogger(PGPAttachments.class);
    
    
    public void saveDecodedAttach (HttpServletRequest request, HttpServletResponse response, com.openexchange.guard.server.OxCookie cookie) throws Exception {
        JsonObject json = com.openexchange.guard.util.Core.getJSON(request);
        String folder = Core.getStringFromJson(json, "folder", true);
        String emailid = json.get("id").getAsString();
        int userid = Core.getIntFromJson(json, "userid", true);
        String attachid = Core.getStringFromJson(json, "attachment", true);
        int cid = Core.getIntFromJson(json, "cid", true);
        String auth = json.get("auth").isJsonNull() ? "" : json.get("auth").getAsString();
        String filename = Core.getStringFromJson(json, "filename", true);
        String sessionID = Core.getStringFromJson(json, "session_id", true);
        String description = Core.getStringFromJson(json, "description");
        String dest_folder = Core.getStringFromJson(json, "dest_folder", true);
        boolean inline = Core.getBooleanFromJson(json, "inline", true);
        boolean reEncrypt = Core.getBooleanFromJson(json, "reEncrypt", true);

        UserData data;
        if (auth.length() < 20) {
            String password = request.getParameter("password");
            if ((password == null) || password.equals("undefined")) {
                String epassword = json.get("epassword").getAsString();
                if (epassword != null) {
                    Access acc = new Access();
                    String token = acc.getToken(cookie.JSESSIONID);
                    EncrLib enc = new EncrLib();
                    password = enc.decryptAES(epassword, token);
                } else password = null; // null password if was undefined and no epassword
            }
            data = new UserData();
            data.encr_password = password;
            data.userid = userid;
        } else {
            data = new UserData(auth, cookie);
        }
        if (data.encr_password == null) {
            com.openexchange.guard.util.Core.sendFail(response, "Failed to decode");
            return;
        }
        ByteArrayOutputStream decoded = new ByteArrayOutputStream();
        PgpHandler ph = new PgpHandler();
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        Attachment file = new Attachment();
        if (inline) {
            ph.decodeInlineAttach(emailid, folder, attachid, filename, userid, cid, data.encr_password, decoded, request, cookie);
            decoded.close();
            if (decoded.size() < 20) { // Small return is possible bad password.  
                if (checkBadPassword(decoded.toByteArray())) {
                    Core.sendFail(response, "Bad Password");
                    return;
                }
            }
            file.content = decoded.toByteArray();
        } else {
            byte[] decodedBytes = ph.getAttach(request, cookie, emailid, folder, userid, cid, filename, data.encr_password);
            file.content = decodedBytes;
            if (decodedBytes.length < 20) {
                if (checkBadPassword(decodedBytes)) {
                    Core.sendFail(response, "Bad Password");
                    return;
                }
                file.content = decodedBytes;
            }
        }
        
        
        if (reEncrypt) {  // If we are re-encrypting for the users filestore, then get the key and encrypt
            if (!filename.contains(".pgp")) filename=filename + ".pgp";
            Access acc = new Access();
            GuardKeys key = acc.getKeys(userid, cid);
            ArrayList<RecipKey> recipients = new ArrayList<RecipKey>();
            RecipKey self = new RecipKey(key);
            recipients.add(self);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PGPUtils.encrypt(out, file.content, filename, recipients, false, true);
            out.close();
            file.content = out.toByteArray();
        } else {
            filename = filename.replace(".pgp", "");
        }
        
        
        file.filename = filename;
        file.type = FileTyper.getFileType(filename);
        attachments.add(file);

        // Save to ox backend
        String params = "files?action=new&filename=" + URLEncoder.encode(filename) + "&session=" + sessionID;
        com.openexchange.guard.ox.Api ap = new com.openexchange.guard.ox.Api(cookie, request);
        JsonObject newjson = new JsonObject();
        newjson.addProperty("folder_id", dest_folder);
        newjson.addProperty("description", description);
        JsonObject meta = new JsonObject();
        meta.addProperty("OrigMime", file.type);
        meta.addProperty("Encrypted", reEncrypt);
        meta.addProperty("OwnerCid", cid);
        meta.addProperty("OwnerId", userid);
        newjson.add("meta", meta);
        String resp = ap.filePost(newjson.toString(), params, attachments);
        if (com.openexchange.guard.util.Core.checkFail(resp)) {
            String error = Core.getError(resp);
            com.openexchange.guard.util.Core.sendFail(response, (error.equals("") ? "Failed to save" : error));
        } else {
            com.openexchange.guard.util.Core.sendOK(response, "OK");
        }
    }
    
    private boolean checkBadPassword(byte[] data) throws UnsupportedEncodingException {
        String resp = new String(data, "UTF-8");
        if (resp.trim().toLowerCase().equals("bad password")) return (true);
        return(false);
    }

}
