package com.openexchange.guard.ox.streaming;


import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.AbstractContentBody;

/**
 * A content body which can be used in HTTP request to
 * read from an input stream
 *
 * @author Benjamin Gruedelbach
 */
public class StreamedContentBody extends AbstractContentBody{

	private final InputStream inputStream;
	private final StreamHandler handler;
	private final int inputBufferSize;
	public String filename;

    /**
     * Constructor
     *
     * @param inputStream An input stream representing the remote file to process
     * @param contentType The content type
     * @param handler A handler defining the concrete data processing
     *                                 method to apply for the InputStream
     */
	public StreamedContentBody(InputStream inputStream,
	                           int inputBufferSize,
							   ContentType contentType,
							   StreamHandler handler,
							   String filename) {
		super(contentType);

		if(inputStream == null) {
            throw new NullPointerException("File inputstream is null");
        }
		if(handler == null) {
            throw new NullPointerException("Encryption handleris null");
        }
		this.inputStream = inputStream;
		this.inputBufferSize = inputBufferSize;
		this.handler = handler;
		this.filename = filename;
	}

	@Override
	public String getFilename() {
		return filename;
	}

	@Override
	public void writeTo(OutputStream os) throws IOException {
	    handler.processStream(inputStream,os,inputBufferSize);
	}

	@Override
	public long getContentLength() {
		//-1 because of chunked upload
		return -1;
	}

	@Override
	public String getTransferEncoding() {
		return "UTF-8";
	}

}
