package com.openexchange.guard.ox.streaming;

/**
 * A simple factory for creation Stream handler based on a file's name / file's extension
 *
 * @author Benjamin Gruedelbach
 */
public class StreamHandlerFactory {

    /**
     * Creates a proper stream handler based on the given file name
     * @param fileName The file's name
     * @param userId The user's Id
     * @param cid CID
     * @param password The user's password
     * @param encryptedExtraPassword and optional, ecnrypted, password for the file
     * @param sessionId The session ID
     * @return A proper handler for encryption the file during streaming
     */
    public static StreamHandler CreateStreamHandler(String fileName,
                                                    int userId,
                                                    int cid,
                                                    String password,
                                                    String encryptedExtraPassword,
                                                    String sessionId) {
        //in order to be backwards compatible to guard 1.0 and it's
        //own "guard" encryption mode we need to provide the possibility
        //to encrypt the old files encrypted with guard 1.0
        if(fileName.endsWith(".grd") ||
           fileName.endsWith(".grd2")) {
            return new GuardStreamDecryptionHandler(userId,
                cid,
                password,
                encryptedExtraPassword,
                sessionId);
        }
        return new PGPStreamDecryptionHandler(userId, cid, password);
    }
}