package com.openexchange.guard.ox.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * Defines a handler interface which is called for encrypting chunk of streamed data
 *
 * @author Benjamin Gruedelbach
 */
public interface StreamHandler {

    /**
     * Process the input stream and writes the processed data to the output stream
     *
     * @param inputStream the stream of data to process
     * @param outputStream the output stream to write the processed data top
     * @param suggestedBufferSize a suggested size of the chunks to read from the inputStream
     * @exception IOException on error writing to the outputStream
     */
    public void processStream(InputStream inputStream,
        OutputStream outputStream,
        int suggestedBufferSize) throws IOException;

    /**
     * Returns the new content type for the uploading stream based on the old content type
     * and filename
     *
     * @param oldContentType The old content type of the item to process
     * @return the new content type of the stream
     */
    public String getNewContentType(String oldContentType, String fileName);
        

    /**
     * Creates a name for the new stream based on the old name
     *
     * @param oldName the old name from which the new name will be created
     * @return the new name of the new stream item
     */
    public String getNewName(String oldName);
}
