package com.openexchange.guard.ox.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import com.openexchange.guard.encr.Crypto;

/**
 * Encrypts a stream of data using legacy guard encryption method
 *
 * @author Benjamin Gruedelbach
 */
public class GuardStreamEcryptionHandler implements StreamHandler {

    private final int userId;
    private final int contentId;

    /**
     * Constructor
     * @param userId The user's id
     * @param contentId The conentId
     * @param The id of the file to encrypt
     */
    public GuardStreamEcryptionHandler(int userId,
                                       int contentId){
        this.userId = userId;
        this.contentId = contentId;
    }

    @Override
    public void processStream(InputStream inputStream,
                              OutputStream outputStream,
                              int suggestedBufferSize) throws IOException {
            try {
                //By now we read the entire stream into memory
                //since the underlying encItem Method does not support
                //the encryption of a stream
                byte[] dataToEcrypt = IOUtils.toByteArray(inputStream);

                //Encrypting the data
                Crypto crypto = new Crypto();
                byte[] encryptedData =
                        crypto.encrItem(userId,
                                        contentId,
                                        null,   //no recipients ?
                                        Base64.encodeBase64String(dataToEcrypt),
                                        0, //no expiration
                                        2, //type? What is this?
                                        ""); //XML? What is this?

                //writing the encrypted data to the remote file
                outputStream.write(encryptedData);

            } catch (SQLException e) {
                throw new IOException(e);
            }
    }

    @Override
    public String getNewContentType(String oldContentType, String fileName) {
        return "grd/" + oldContentType.replace("/", "--");
    }

    @Override
    public String getNewName(String oldName) {
        return oldName + ".grd";
    }
}
