package com.openexchange.guard.ox.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.util.Strings;

/**
 * An encryption handler for testing purpose which changes all "e" or "E" characters
 * to a friendly smile ":-)".
 *
 * @author Benjamin Gruedelbach
 */
public class ExampleStreamEncryptionHandler implements StreamHandler{

	@Override
    public void processStream(InputStream inputStream,
        OutputStream outputStream,
        int suggestedBufferSize) throws IOException {

        boolean reading = true;
        while (reading) {
            //Reading the input stream
            byte[] buffer = new byte[suggestedBufferSize];
            int bytesRead = inputStream.read(buffer);
            reading = bytesRead > 0;
            if (reading) {
                String s = Strings.fromByteArray(buffer).substring(0, bytesRead);
                s = s.replaceAll("e|E", ":-)");
                outputStream.write(Strings.toByteArray(s));
            }
        }
	}

    @Override
    public String getNewContentType(String oldContentType, String fileName) {
        return oldContentType;
    }

    @Override
    public String getNewName(String oldName) {
        return oldName;
    }
}
