package com.openexchange.guard.ox;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.openexchange.guard.config.Config;

public class checkWhitelist {
	
	private static Logger logger = LoggerFactory.getLogger(checkWhitelist.class);

	/**
	 * Check if the ip address is within the range of whitelist configured
	 * @param ip
	 * @return
	 */
	public static boolean isWhiteListed(String ip) {
		try {
		for (int i = 0; i < Config.pgpWhitelist.size(); i++) {
			if (Config.pgpWhitelist.get(i).isInRange(ip)) return(true);
		}
		return(false);
		} catch (Exception e) {
			logger.error("Problem checking pgp whitelist", e);
			return(false);
		}
	}
}
