package com.openexchange.guard.mailcreator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.ox.Languages;
import com.openexchange.guard.translate.GetText;

public class PGPMailCreator {
    
    private static Logger logger = LoggerFactory.getLogger(PGPMailCreator.class);

	
	public static MimeMultipart GetPGPMime (byte[] data, ArrayList<String> languages) throws Exception {
		
		MimeMultipart pgp = new MimeMultipart("encrypted; protocol=\"application/pgp-encrypted\"");
		BodyPart ver = new MimeBodyPart();
		ver.setDescription("PGP/MIME version identification");
		ver.setContent("Version: 1\r\n", "application/pgp-encrypted");
		ver.setHeader("Content-Transfer-Encoding", "7bit");
		pgp.addBodyPart(ver);
		BodyPart pt = new MimeBodyPart();
		pt.setFileName("encrypted.asc");
		pt.setDescription("OpenPGP encrypted message");
		pt.setDisposition("inline");
		pt.setContent(new String(data, "UTF-8"), "application/octet-stream");
		pt.setHeader("Content-Transfer-Encoding", "7bit");

		pgp.addBodyPart(pt);

	      ArrayList<helpAttach> attachments = getHelp(languages);
	        for (int i = 0; i < attachments.size(); i++) {
	            BodyPart help = new MimeBodyPart();
	            help.setFileName(GetText.gettext("help", attachments.get(i).getLanguage()) + ".txt");
	            help.setContent(attachments.get(i).getTranslated(), "text/plain; charset=utf-8");
	            help.setDisposition("inline");
	            pgp.addBodyPart(help);
	        }
		
		return(pgp);
		
	}
	
	/**
	 * Get the mime section of a message (remove header)
	 * Returns starting at content-type header
	 * @param msg
	 * @return
	 * @throws IOException
	 * @throws MessagingException
	 */
	public static String GetBody (Message msg) throws IOException, MessagingException {
		ByteArrayOutputStream output = new ByteArrayOutputStream();
		msg.writeTo(output);
		byte[] data = output.toByteArray();
		String mime = new String (data, "UTF-8");
		if (mime.contains("Content-Type")) {
			mime = mime.substring(mime.indexOf("Content-Type"));
		}
		output.close();
		return (mime);
	}
	
	private static ArrayList<helpAttach> getHelp (ArrayList<String> languages) {
	    ArrayList<helpAttach> helpfiles = new ArrayList<helpAttach> ();
	    for (int i = 0; i < languages.size(); i++) {
	        String lang = Languages.isavail(languages.get(i));
	        try {
	            String data = Languages.getHelpFile(lang);
	            data = data.replace("%guest%", "https://" + Config.externalReaderPath);
	            data = data.replace("%webmail%", "https://" + Config.OXUrl);
	            if (data != null) {
	                if (!contains(helpfiles, lang)) {
	                    helpAttach att = new helpAttach(lang, data);
	                    helpfiles.add(att);
	                }
	            }
	        } catch (Exception e) {
	            logger.error("Problem loading help file ", e);
	        }
	    }
	    return (helpfiles);
	}
	    
	private static boolean contains (ArrayList<helpAttach> list, String lang) {
	    for (helpAttach att : list) {
	        if (att.getLanguage().equals(lang)) return(true);
	    }
	    return (false);
	}
}
