package com.openexchange.guard.mail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Message.RecipientType;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.openexchange.guard.config.OxConfiguration;
import com.openexchange.guard.database.Access;
import com.openexchange.guard.database.EmailInfo;
import com.openexchange.guard.database.GetPubKey;
import com.openexchange.guard.database.RecipKey;
import com.openexchange.guard.encr.Crypto;
import com.openexchange.guard.encr.DecodedObj;
import com.openexchange.guard.encr.EncrLib;
import com.openexchange.guard.encr.EncryptedObj;
import com.openexchange.guard.exceptions.GuardMissingParameter;
import com.openexchange.guard.logging.LogAction;
import com.openexchange.guard.mailcreator.Attachment;
import com.openexchange.guard.mailcreator.Mail;
import com.openexchange.guard.ox.Api;
import com.openexchange.guard.pgp.PGPResult;
import com.openexchange.guard.pgp.PGPSender;
import com.openexchange.guard.pgp.PGPUtils;
import com.openexchange.guard.pgp.PgpHandler;
import com.openexchange.guard.server.Auth;
import com.openexchange.guard.server.MailHandler;
import com.openexchange.guard.server.OxCookie;
import com.openexchange.guard.server.Settings;
import com.openexchange.guard.server.UserData;
import com.openexchange.guard.server.Settings.permissions;
import com.openexchange.guard.util.Core;

public class Incoming {

	private static Logger logger = LoggerFactory.getLogger(Incoming.class);
	
    OxCookie cookie;
    HttpServletRequest req;
    String sessionId;

    public Incoming(OxCookie ck, HttpServletRequest rq) {
        cookie = ck;
        req = rq;
        sessionId = rq.getParameter("session");
    }
	
    /**
     * Handle email sent from UI
     * 
     * @param request
     * @param response
     * @throws Exception 
     */
 
	   public void incomingEmailForm(HttpServletRequest request, HttpServletResponse response) throws Exception {
	        FileItemFactory fif = new DiskFileItemFactory();
	        ServletFileUpload sfu = new ServletFileUpload(fif);
	        int userid = Core.getIntParameter(request, "userid", true);
	        int cid = Core.getIntParameter(request, "cid", true);
	        LogAction.setUser(userid, cid);
	        String sentfolder = Core.getStringParameter(request, "sentfolder");
	        if (sentfolder == null) sentfolder = "default0/Sent Items";
	        String guest = Core.getStringParameter(request, "guest");
	        if (guest != null) {
	        	if (!guest.toLowerCase().trim().equals("true")) guest = null;
	        }
	        String language = Core.getStringParameter(request, "lang");
	        String guestlanguage = Core.getStringParameter(request, "guestlanguage");
	        String attach_password = Core.getStringParameter(request, "password");// encrypted attachment password
	        String auth = Core.getStringParameter(request, "auth");
	        String draftFolder = Core.getStringParameter(request, "draftfolder");
	        String pin = null;
	        boolean draft = Core.getBooleanParameter(request, "draft");
	        int templId = Core.getIntParameter(request, "templid");
	        if (language == null)
	            language = "en-US";
	        EmailInfo info = null;
	        String sr = Core.getStringParameter(request, "sr");
	        // If not guest, verify logged in
	        if (guest == null) {
	        	Api ap = new Api(cookie, request);
	        	if (!ap.verifyLogin()) {
	        	    LogAction.setFail();
	        		logger.info("not logged into ui");
	                Core.sendFail(response, "not authorized");
	                return;
	        	}
	        	   // Load custom template Id for this user
	        } else {
	        	if (sr == null) {  // Reply ID must be sent if not part of UI
	        	    LogAction.setFail();
	        		logger.error("Reply ID not sent");
	        		Core.sendFail(response, "not authorized");
	                return;
	        	}	
	        	cookie.JSESSIONID = cookie.OxReaderID;
	        	UserData userdata = new UserData(auth, cookie);
	        	cid = userdata.cid;
	        	if (userdata.userid < 0) {
	        	    LogAction.setFail();
	        		logger.info("Bad authorization for guest login");
	        		Core.sendFail(response, "not authorized");
	                return;
	        	}
	        	userid = userdata.userid;
	        	
	        }

	        boolean sendPermission = false;
	        // Check for permission for sending email
	        if (guest == null) {
	            Settings settings = Auth.getPermissions(cookie, request);
		        if (!Auth.check(settings, permissions.MAIL)) {
		            // If not permission, check if secure reply
		            if (sr == null) {
		                if (Auth.checkMinimum(settings)) {  // Make sure they have minimal Guard permission
		                    // Assuming secure reply from user without guard-mail settings
		                    // ToDo in future...rate limit, recip limit, other
		                    sendPermission = true;
		                } else {
    		                LogAction.setFail();
    		                logger.info("not authorized");
    		                Core.sendFail(response, "not authorized");
    		                return;
		                }
		            }
		        } else sendPermission = true;
	        }
	        if ((sr != null) && !sendPermission) info = new EmailInfo(sr, userid, cid);
	        if (cid < 0) {  // If negative context ID (non-ox user), use the orig senders templates for sending
	        	templId = OxConfiguration.getTemplateId(info.owner_cid, info.owner_id);
	        } else {
	            templId = OxConfiguration.getTemplateId(cid, userid);
	        }
	        

	            ArrayList<Attachment> attachments = new ArrayList<Attachment>();// Get list of all attachments
	            String emaildata = "";
	            String guestmessage = "";
	            List files = sfu.parseRequest(request);
	            sessionId = Core.getStringParameter(request, "session", true);
	            String ua = request.getHeader("User-Agent");
	            Iterator iterator = files.iterator(); // Iterate through attachments
	            while (iterator.hasNext()) {
	                FileItem fi = (FileItem) iterator.next();
	                String name = fi.getFieldName();
	                if (name.startsWith("guest_message")) {
	                    guestmessage = fi.getString("UTF-8");
	                    continue;
	                }
	                if (name.startsWith("pin")) {
	                	pin = fi.getString("UTF-8");
	                	continue;
	                }
	                if (name.startsWith("json")) { // Field name json is the email data (or should be). So get email data
	                    emaildata = fi.getString("UTF-8");
	                } else {
	                    name = fi.getName(); // Otherwise, assume it is an attachment
	                    if (name != null) {// Make sure the name of the file exists, may just be blank field
	                        if (!name.trim().equals("")) {
	                            if (name.lastIndexOf("\\") > -1) {
	                                name = name.substring(name.lastIndexOf("\\"));
	                            }
	                            if (name.lastIndexOf("/") > -1) {
	                                name = name.substring(name.lastIndexOf("/"));
	                            }
	                            ByteArrayOutputStream out = new ByteArrayOutputStream();
	                            InputStream input = fi.getInputStream();
	                            IOUtils.copy(input, out); // Copy stream to byte array
	                            Attachment attach = new Attachment();
	                            attach.content = out.toByteArray(); // Populate attachment data
	                            attach.filename = fi.getName();
	                            attach.type = fi.getContentType();
	                            attachments.add(attach); // Add to our array of attachments
	                            out.close();
	                            input.close();
	                        }
	                    }
	                }
	            }
	            if (!emaildata.equals("")) { // We must have the basic email data
	                JsonParser jsonParser = new JsonParser(); // Put it into json
	                JsonObject json = (JsonObject) jsonParser.parse(emaildata);
	                if (json.get("attachpassword") != null) attach_password = json.get("attachpassword").getAsString();
	                JsonObject data = json.getAsJsonObject("data");
	                ArrayList<RecipKey> recipients = getUsers(data, userid, cid, guestlanguage, pin, info); // get the users and populate the recipient keys

	                if (recipients == null) {
	                    LogAction.setFail();
	                    logger.info("Unable to get keys for all users");
	                    Core.sendFail(response, "keyproblem");
	                    return;
	                }
	                
	                if (!sendPermission) {
	                	JsonArray from = data.get("from").getAsJsonArray().get(0).getAsJsonArray();
	                	if (!checkReply(from, recipients, info)) {
	                	    LogAction.setFail();
	                		logger.info("Attempt to reply to users not in original email list");
	                		Core.sendFail(response, "unauth recip");
	                		return;
	                	}
	                }
	                
	                // Encrypt email
	                JsonObject header = data.getAsJsonObject("headers");
	                String extrapass = "";
	                try {
	                	if (header.has("X-OxGuard-ExtraPass")) extrapass = header.get("X-OxGuard-ExtraPass").getAsString();
	                	if (!extrapass.equals("")) {
	                		header.remove("X-OxGuard-ExtraPass");
	                		header.addProperty("X-OxGuard-ExtraPass", "true");
	                	}
	                	
	                } catch (Exception e) {
	                    LogAction.setFail();
	                    logger.error("Problem getting extra pass " + e.toString());
	                }

	                // Get infostore attachments
	                try {
	                    if (!data.get("infostore_ids").isJsonNull()) {
	                        JsonArray infostores = data.get("infostore_ids").getAsJsonArray();
	                        if (infostores != null) {
	                            for (int i = 0; i < infostores.size(); i++) {
	                                Attachment attach = getInfoAttach(infostores.get(i).getAsJsonObject(), request, cookie);
	                                if (attach != null) 
	                                	attachments.add(attach);
	                            }
	                        }
	                        data.remove("infostore_ids");  // We've added them to our attachments, now remove from the JSON
	                    }
	                } catch (Exception ex2) {
	                    LogAction.setFail();
	                    logger.error("Problem extracting infostore items.", ex2);

	                }
	                // Search for inline images, convert to attachments
	                data = getInlineImages (data, attachments, request, cookie);
	                
	                data = getNestedAttachments (data, attachments);
	                
	                data = getNestedMessages (data, attachments, request, cookie);
	                
	                // Search for attachments that reference a draft email, and aren't actually supplied.
	                data = getDraftAttachments (data, attachments, request, cookie, userid, cid);
	                
	                addVcard (data, attachments, request, cookie, userid, cid);
	                
	                if (!getAttachPGPFiles (data, attachments, request, cookie, userid, cid, attach_password)) {
	                    Core.sendFail(response, "Unable to decode attachments");
	                    return;
	                }
	                
	                // Check if PGP email
	                
	                	PGPSender pgpsend = new PGPSender(draft, draftFolder);
	                	pgpsend.sendPGPMail(json, attachments, attach_password, recipients, guestmessage, pin, templId, request, response, cookie);


	            } else {// Our reply that the email was blank
	                LogAction.setFail();
	                com.openexchange.guard.util.Core.sendOK(response, "No Email Data");
	            }
	    }
	   
	    /**
	     * Get the list of recipients from a json email, and get their keys
	     * 
	     * @param json
	     * @return
	     * @throws Exception
	     */
	    public ArrayList<RecipKey> getUsers(JsonObject json, int senderId, int senderCID, String guestlanguage, String pin, EmailInfo info) throws Exception {

	        ArrayList<RecipKey> recipients = new ArrayList<RecipKey>();

	        JsonArray recips = json.get("to").getAsJsonArray();
	        String from = json.get("from").getAsJsonArray().get(0).getAsJsonArray().get(1).getAsString();
	        String fromName = json.get("from").getAsJsonArray().get(0).getAsJsonArray().get(0).getAsString();
	        recipients = addUsers(recipients, recips, senderId, senderCID, from, fromName, RecipientType.TO, guestlanguage, pin, info);
	        if (recipients == null)
	            return (null);
	        recips = json.get("cc").getAsJsonArray();
	        recipients = addUsers(recipients, recips, senderId, senderCID, from, fromName, RecipientType.CC, guestlanguage, pin, info);
	        if (recipients == null)
	            return (null);
	        recips = json.get("bcc").getAsJsonArray();
	        recipients = addUsers(recipients, recips, senderId, senderCID, from, fromName, RecipientType.BCC, guestlanguage, pin, info);

	        return (recipients);

	    }
	    
	    private ArrayList<RecipKey> addUsers(ArrayList<RecipKey> recipients, JsonArray recips, int senderId, int senderCID, String from, String fromName, RecipientType type, String guestlanguage, String pin, EmailInfo info) throws Exception {
	        for (int i = 0; i < recips.size(); i++) {
	            JsonArray recip = recips.get(i).getAsJsonArray();
	            String email = recip.get(1).getAsString();
	            GetPubKey gk = new GetPubKey();
	            try {
	                RecipKey key = gk.getPubKey(email, senderId, senderCID, from, true, false, guestlanguage, fromName, pin, info);
	                if (key != null) {
	                    if (key.pubkey == null) {
	                        // Fail to create key
	                        if (key.pgp == false) return (null);
	                    }
	                    key.email = email;
	                    key.type = type;
	                    try {
	                        key.name = recip.get(0).getAsString();
	                    } catch (Exception ex) {
	                        key.name = "";
	                        logger.error("No key name set for " + email, ex);
	                    }
	                    recipients.add(key);
	                } else {
	                	return (null);
	                    // No keys found or made
	                }
	            } catch (SQLException e) {
	            	logger.error("SQL error when getting public key", e);
	            } catch (IOException e) {
	            	logger.error("IO error when getting public key", e);
	            }
	        }
	        return (recipients);
	    }
	    

	    private boolean checkReply (JsonArray from, ArrayList<RecipKey> recips, EmailInfo info) {
	    	if (info == null) return(false);
	    	if (recips == null) return(false);
	    	if (!info.fromEmail.toLowerCase().trim().equals(from.get(1).getAsString().toLowerCase().trim())) return(false);
	    	for (int i = 0; i < recips.size(); i++) {
	    		if (!info.recips.contains(recips.get(i).email)) {
	    			if (!info.senderEmail.contains(recips.get(i).email)) return(false);
	    		}
	    	}
	    	return (true);
	    }
	    
	    /*
	     * Get exp date of email
	     */
	    public static long getExpDate(JsonObject email) {
	    	try {
		        JsonObject header = email.get("headers").getAsJsonObject();
		        if (!header.has("X-OxGuard-Expiration")) return(0);
		        int hours = header.get("X-OxGuard-Expiration").getAsInt();
		        if (hours == 0) {
		            return (0);
		        }
		        final long exphours = hours * 60L * 60L * 1000L;
		        Date now = new Date();
		        return (now.getTime() + exphours);
	    	} catch (Exception ex) {
	    		logger.error("Problem getting email expiration date");
	    		return (0);
	    	}
	    }
	    
	    public static Attachment getInfoAttach(JsonObject jsonElement, HttpServletRequest request, OxCookie ck) {
	    	try {
		        String id = jsonElement.get("id").getAsString();
		        int version = jsonElement.has("version") ? jsonElement.get("version").getAsInt() : -1;
		        int folder = jsonElement.get("folder_id").getAsInt();
		        Api ap = new Api(ck, request);
		        Attachment attach = ap.getInfoStoreAttach(id, folder, version);
		        attach.filename = jsonElement.get("filename").getAsString();
		        return (attach);
	    	} catch (Exception ex) {
	    		logger.error("Unable to get infostore attachment ", ex);
	    		return (null);
	    	}
	    }
	    
	    /**
	     * Get attachments from draft email if any.  Looks for atmsgref for regular emails
	     * @param data
	     * @param attachments
	     * @param request
	     * @return
	     */
	    public JsonObject getDraftAttachments (JsonObject data, ArrayList<Attachment> attachments, HttpServletRequest request, OxCookie ck, int userid, int cid) {
	    	try {
		    	JsonArray contents = data.get("attachments").getAsJsonArray();
		    	JsonArray newcontents = new JsonArray();
		    	for (int i = 0; i < contents.size(); i++) {
		    		boolean modified = false;
		    		JsonObject att = contents.get(i).getAsJsonObject();
		    		if (att.has("epass")) {
                        String password = Crypto.decodeEPass(att.get("epass").getAsString(), ck);
		    		    PgpHandler pgph = new PgpHandler();
		    			Attachment decattach = new Attachment();
		    		    String emailid = att.get("mail").getAsJsonObject().get("id").getAsString();
		    		    String folder = att.get("mail").getAsJsonObject().get("folder_id").getAsString();
		    		    boolean pgpmime = true;
		    		    if (att.has("pgpFormat")) {
		    		        if (att.get("pgpFormat").getAsString().contains("inline")) {
		    		            pgpmime = false;
		    		        }
		    		    }
		    			decattach.content = pgpmime ? 
		    			    pgph.getAttach(request, ck, emailid, folder, userid, cid, att.get("filename").getAsString(), password) :
		    			        pgph.decodeInlineAttach(emailid, folder, att.get("id").getAsString(), att.get("filename").getAsString(), userid, cid, password, request, ck);
		    			decattach.type = att.get("content_type").getAsString();
		    			decattach.filename = att.get("filename").getAsString().replace(".pgp", "");
		    			attachments.add(decattach);
		    			modified = true;
		    		} else {
			    		if (att.has("atmsgref")) {
			    			String attid = att.get("id").getAsString();
			    			String item = att.get("atmsgref").getAsString();
			    			int j = item.lastIndexOf("/");
			    			String folder = item.substring(0,j);
			    			String emailid = item.substring(j+1).trim();
			    			Api ap = new Api (ck, request);
							Attachment attach = ap.getPlainAttachment(emailid, attid, folder);
							attach.filename = att.get("filename").getAsString();
							attach.type = att.get("content_type").getAsString();
							attachments.add(attach);
							modified = true;
			    		}
		    		}
		    		if (!modified) newcontents.add(contents.get(i));
		    	}
		    	data.remove("attachments");
		    	data.add("attachments", newcontents);
	    	} catch (Exception ex) {
	    		logger.error("Problems getting attachments from draft email ", ex);
	    	}
	    	return (data);
	    }
	    
	    /**
	     * If the user forwards an item that was already encrypted (filestore item), then needs to be decoded before re-encrypting
	     * @param data
	     * @param attachments
	     * @param request
	     * @param cookie
	     * @param userid
	     * @param cid
	     * @param password
	     * @return
	     * @throws Exception
	     */
	    private boolean getAttachPGPFiles (JsonObject data, ArrayList<Attachment> attachments, HttpServletRequest request, OxCookie cookie, int userid, int cid, String password) throws Exception {
	        boolean success = true;
	        for (Attachment att : attachments) {
	            if (att.filename != null && att.filename.endsWith(".pgp")) {
	                ByteArrayInputStream in = new ByteArrayInputStream (att.content);
	                PGPResult result = PGPUtils.decryptFile(in, userid, cid, password);
	                if (result.error == null) {
	                    att.content = result.decoded;
	                    att.filename = att.filename.replace(".pgp", "");
	                } else {
	                    success = false;
	                }
	            }
	        }
	        return (success);
	        
	    }
	    
	    /**
	     * Check if vcard should be added.  If so, add to attachments.
	     * This is only supported 7.62 after July patch
	     * @param data
	     * @param attachments
	     * @param request
	     * @param cookie
	     * @param userid
	     * @param cid
	     */
	    private void addVcard (JsonObject data, ArrayList<Attachment> attachments, HttpServletRequest request, OxCookie cookie, int userid, int cid) {
            if (data.has("vcard")) {
                if (data.get("vcard").getAsInt() == 1) {
                    Api ap = new Api(cookie, request);
                    byte[] vcard = ap.getVcard();
                    if (vcard != null) {
                        String filename = "vcard";  // backup name is vcard
                        String vs = new String(vcard);
                        String[] lines = vs.split("\n");
                        for (String line : lines) {  // Parse the lines for the Full Name for the filename of the vcard
                            if (line.startsWith("FN:")) {
                                filename = line.replace("FN:", "");
                            }
                        }
                        Attachment vcardAtt = new Attachment(); // Add to attachments
                        vcardAtt.content = vcard;
                        vcardAtt.filename = filename + ".vcf";
                        vcardAtt.type = "text/vcard";
                        attachments.add(vcardAtt);
                    }
                    data.remove("vcard");
                    data.add("vcard", new JsonPrimitive(0));  // We need to remove the flag so the backend doesn't add it unencrypted.
                }
            }
	    }
	    
	    /**
	     * Depreciated.  Get decode Guard attachment being forwarded
	     * @param attach
	     * @param userid
	     * @param cid
	     * @param request
	     * @param ck
	     * @return
	     */
	    private static DecodedObj getEncrAttach (JsonObject attach, int userid, int cid, HttpServletRequest request, OxCookie ck) {
	    	
	    	int attachid = attach.get("id").getAsInt();
	    	String filename = attach.get("filename").getAsString();
	    	String emailid = attach.get("parent").getAsJsonObject().get("id").getAsString();
	    	String folder = attach.get("parent").getAsJsonObject().get("folder_id").getAsString();
	    	String encrextrapass = attach.has("extrapass") ? attach.get("extrapass").getAsString() : null;
	    	String extrapass = null;
	    	String cc = attach.get("cc") == null ? null : attach.get("cc").getAsString();
	    	UserData data = new UserData();;
	    	String epassword = attach.get("epass").getAsString();
            if (epassword != null) {
                Access acc = new Access();
                String token = acc.getToken(ck.JSESSIONID);
                EncrLib enc = new EncrLib();
                data.encr_password = enc.decryptAES(epassword, token);
            } else return (null);
            Attachments att = new Attachments (ck);
	    	DecodedObj decoded = att.decodeAttach(
	                request,
	                null,
	                emailid,
	                userid,
	                attachid,
	                cid,
	                null,
	                filename,
	                request.getParameter("session"),
	                extrapass,
	                encrextrapass,
	                folder,
	                cc,
	                data);
	    	return (decoded);
	    }
	    
	    
	    public  JsonObject getNestedMessages (JsonObject data, ArrayList<Attachment> attachments, HttpServletRequest request, OxCookie ck) {
	    	try {
	    		if (!data.has("nested_msgs")) return (data);
	    		JsonArray nested = data.get("nested_msgs").getAsJsonArray();
	    		for (int i = 0; i < nested.size(); i++) {
	    			JsonObject message = nested.get(i).getAsJsonObject();
	    			String message_ref = message.get("msgref").getAsString();
	    			String subject = message.get("subject").getAsString();
	    			if (subject.trim().length()<1) subject = "eml" + i;
	    			Api ap = new Api (ck, request);
	    			String mime = ap.getMime(message_ref);
	    			Attachment newatt = new Attachment();
	    			newatt.filename = subject + ".eml";
	    			newatt.content = mime.getBytes("UTF-8");
	    			newatt.type = "text/html";
	    			attachments.add(newatt);
	    			MimeParser mparse = new MimeParser(newatt.content);
	    			mparse.ParseAttachments();
	    			mparse.mergeAttachments(attachments);
	    		}
	    		return (data);
	    	} catch (Exception ex) {
	    		logger.error("Error getting nested messages", ex);
	    		return (data);
	    	}
	    }
	    
	    public  JsonObject getNestedAttachments (JsonObject data, ArrayList<Attachment> attachments) {
	        try {
	        JsonArray contents = data.get("attachments").getAsJsonArray();
	        for (int i = 0; i < contents.size(); i++) {
	            JsonObject content = contents.get(i).getAsJsonObject();
	            if (content.has("disp")) {
	                if (content.get("disp").getAsString().equals("attachment")) {
	                    if (content.get("content").getAsString().length() > 0) {
	                        Attachment att = new Attachment();
	                        att.filename = content.get("filename").getAsString();
	                        att.content = content.get("content").getAsString().getBytes("UTF-8");
	                        att.type = content.get("content_type").getAsString();
	                        attachments.add(att);
	                    }
	                }
	            }
	        }
	        } catch (Exception e) {
	            logger.error("Problem getting nested attachments", e);
	        }
	        return (data);
	    }
	    
	    public  JsonObject getInlineImages (JsonObject data, ArrayList<Attachment> attachments, HttpServletRequest request, OxCookie ck) {
	    	try {
		    	JsonArray contents = data.get("attachments").getAsJsonArray();
		    	JsonArray newcontents = new JsonArray();
		    	for (int i = 0; i < contents.size(); i++) {
		    		if (contents.get(i).getAsJsonObject().has("content") && contents.get(i).getAsJsonObject().get("content").isJsonNull()) {
		    			newcontents.add(contents.get(i));
		    		}
		    		else {
		    			JsonObject content = contents.get(i).getAsJsonObject();
		    			if (content.has("content")) {
    		    			String cont = content.get("content").getAsString();
    		    			int start = cont.indexOf("<img");
    		    			boolean changed = false;
    		    			String newcont = new String(cont);
    		    			while ((start > 0) && (start < cont.length())) {
    		    				int end = cont.indexOf(">", start);
    		    				if (end < 0) break;
    		    				String image = cont.substring(start, end);
    		    				Pattern pattern = Pattern.compile("src=\"[^\"]*");
    		    				Matcher match = pattern.matcher(image);
    		    				if (match.find()) {
    		    					String url = image.substring(match.start() +5, match.end());
    		    					if (url.length() > 1) {
    		    					    // TODO Handle forwarding of inline Guard images
    			    					Api ap = new Api (ck, request);
    			    					Attachment attach = ap.getInlineImage(url);
    			    					if (attach != null) {
                                            attach.content_id = EncrLib.getUUID() + "@GUARD";
                                            attachments.add(attach);
                                            newcont = newcont.replace(url, "cid:" + attach.content_id);
    			    					}
    			    					changed = true;
    		    					}
    		    				}
    		    				start = cont.indexOf("<img ", end);
    		    			}
    		    			if (changed) {
    		        			content.remove("content");
    		        			content.addProperty("content", newcont);
    		    			}
		    			}
		    			newcontents.add(content);
		    			}
		    	}
		    	data.remove("attachments");
		    	data.add("attachments", newcontents);
	    	} catch (Exception ex) {
	    		logger.error("Problem retrieving inline images ", ex);
	    	}
	    	return (data);
	    }

	   
}
