package com.openexchange.guard.logging;

import org.slf4j.MDC;


public class LogAction {
	
	private static int pid = 1;

    /**
     * Set MDC values for the URL
     * @param IP
     * @param command
     * @param action
     */
    public static void setURL (String IP, String url, String action) {
        MDC.put("IP", IP);
        MDC.put("command", url);
        MDC.put("action", action);
    }
    
    /**
     * Increment and assign new PID process
     */
    public static synchronized void getPID() {
    	pid++;
    	MDC.put("PID", Integer.toString(pid));
    }
    
    /**
     * Add userid and cid data to logging
     * @param userid
     * @param cid
     */
    public static void setUser (int userid, int cid) {
    	MDC.put("ID", Integer.toString(userid));
    	MDC.put("CID", Integer.toString(cid));
    }
    
    public static void clear () {
        MDC.clear();
    }
    
    public static void setSuccess () {
        setSuccess(true);
    }
    
    public static void setFail() {
        setSuccess(false);
    }
    
    public static void setSuccess (boolean success) {
        if (success) MDC.put("result", "success");
        else MDC.put("result", "fail");
    }
    
}
