package com.openexchange.guard.database.repositories;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.database.DbCommand;
import com.openexchange.guard.database.DbQuery;
import com.openexchange.guard.encr.GuardKeys;

/**
 * Data access repository for accessing PGP keys
 * (related to tables PGPKeys and og_KeyTable)
 */
public class GuardKeysRepository {
    private static Logger logger = LoggerFactory.getLogger(GuardKeysRepository.class);

    /**
     * Deletes a key from
     * @param key the keys to delete
     * @throws Exception due an error
     */
    public void Delete(GuardKeys...keys) throws Exception {

        DbQuery dbQuery = new DbQuery();
        long keyId = -1;
        int contextId = 1;

        try {
            for (int i = 0; i < keys.length; i++) {
                GuardKeys key = keys[i];
                keyId = key.keyid;
                contextId = key.contextid;

                DbCommand command = new DbCommand("DELETE FROM PGPKeys WHERE keyid = ?");
                command.addVariables(key.keyid);
                dbQuery.writeOxGuard(command);

                DbCommand command2 = new DbCommand("DELETE FROM og_KeyTable WHERE id = ? AND cid = ?");
                command2.addVariables(key.userid);
                command2.addVariables(contextId);
                dbQuery.write(command2, key.userid, contextId);
            }
        } catch (Exception e) {
            logger.error(
                String.format("Error while deleting key %d from table deletedKeys: %s",
                              keyId,
                              e.getMessage()));
            e.printStackTrace();
            throw e;
        }
        finally {
            if(dbQuery != null) {
                dbQuery.close();
            }
        }
    }
}
