package com.openexchange.guard.database.repositories;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.database.DbCommand;
import com.openexchange.guard.database.DbQuery;
import com.openexchange.guard.database.model.Email;


public class EmailRepository {

    private static Logger logger = LoggerFactory.getLogger(EmailRepository.class);
    /**
     * Deletes keys
     * @param keys the keys to delete
     * @throws Exception  due an error
     */
    public void Delete(Email...emails) throws Exception {

        DbQuery dbQuery = null;
        long keyId = -1;
        try {
            for (int i = 0; i < emails.length; i++) {
                dbQuery = new DbQuery();
                Email email = emails[i];
                DbCommand command = new DbCommand("DELETE FROM og_email WHERE id = ? AND cid = ?");
                command.addVariables(email.getUserId());
                command.addVariables(email.getContextId());
                dbQuery.writeOxGuard(command);
            }
        } catch (Exception e) {
            logger.error(
                String.format("Error while deleting key %d from table deletedKeys: %s",
                              keyId,
                              e.getMessage()));
            e.printStackTrace();
            throw e;
        }
        finally {
            if(dbQuery != null) {
                dbQuery.close();
            }
        }
    }
}
