package com.openexchange.guard.database.paging;


/**
 * A class which defines a page range with can be used in a database query
 */
public class Page {

    private final int startIndex;
    private final int pageSize;

    /**
     * Initializes a new {@link Page}.
     * @param startIndex The index to start
     * @param pageSize the range
     */
    public Page(int startIndex, int pageSize) {
        this.startIndex = startIndex;
        this.pageSize = pageSize;
    }

    /**
     * @return The current start index
     */
    public int getStartIndex() {
        return startIndex;
    }

    /**
     * The size of the page
     * @return
     */
    public int getPageSize() {
        return pageSize;
    }

    /**
     * Creates a follow up page
     * @param pageSize The size of the new page
     * @return a new page extended by the given size
     */
    public Page next(int pageSize) {
        return new Page(startIndex + this.pageSize, pageSize);
    }

    /**
     * Creates a follow up page with the same size than the current page
     * @return a new page extended by the same size than the current page
     */
    public Page next() {
        return new Page(startIndex + pageSize,pageSize);
    }
}
