package com.openexchange.guard.database.model;

/**
 * Represents a relation between a user's ID and a user's email
 * (as used in DB table og_email)
 */
public class Email {

    private final String email;
    private final int userId;
    private final int contextId;

    /**
     * Constructor
     * @param email The user's email
     * @param userId The user's ID
     * @param contextId The user's context id
     */
    public Email(String email, int userId, int contextId) {
        this.email = email;
        this.userId = userId;
        this.contextId = contextId;
    }

    /**
     * Gets the user's email
     * @return the user's email
     */
    public String getEmail() {
        return this.email;
    }

    /**
     * Gets the user's ID
     * @return the user's ID
     */
    public int getUserId() {
        return this.userId;
    }

    /**
     * Gets the user's context ID
     * @return the user's context ID
     */
    public int getContextId() {
        return this.contextId;
    }
}
