/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.database;

import java.util.HashMap;
import java.util.Map;
import com.openexchange.guard.config.Config;

public class OGInit {

    public static int write_id;

    public static int read_id;

    public static Map<String, Integer> write_map = new HashMap<String, Integer>();

    public static Map<String, Integer> read_map = new HashMap<String, Integer>();

    /**
     * Initialize the Connection id numbers. Get data from config_db regarding the connection ids of read and write
     * 
     * @throws Exception
     */
    public static void initGuardDatabase() throws Exception {
        DbQuery db = new DbQuery();
        String command = "SELECT write_db_pool_id, read_db_pool_id FROM db_cluster dc INNER JOIN db_pool dp ON dc.write_db_pool_id = dp.db_pool_id WHERE dp.name = 'oxguard';";
        DbCommand com = new DbCommand(command);
        db.readFromConfigDb(com);
        if (db.next()) {
            write_id = db.rs.getInt("write_db_pool_id");
            read_id = db.rs.getInt("read_db_pool_id");
            if (read_id == 0)
                read_id = write_id;
        } else {
            throw (new Exception("Write/Master Database not registered"));
        }

        command = "SELECT write_db_pool_id, read_db_pool_id, name FROM db_cluster dc INNER JOIN db_pool dp ON dc.write_db_pool_id = dp.db_pool_id WHERE name LIKE '" + Config.db_prefix + "%';";
        com = new DbCommand(command);
        db.readFromConfigDb(com);
        while (db.next()) {
            int write = db.rs.getInt("write_db_pool_id");
            int read = db.rs.getInt("read_db_pool_id");
            if (read == 0)
                read = write;
            read_map.put(db.rs.getString("name"), read);
            write_map.put(db.rs.getString("name"), write);
        }
        db.close();
    }
}
