package com.openexchange.guard.database;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.openexchange.guard.server.Guest;

public class EmailInfo {

	private static Logger logger = LoggerFactory.getLogger(EmailInfo.class);
	
	public String senderEmail = "";
	public String fromEmail = "";
	public int owner_id = 0;
	public int owner_cid = 0;
	public ArrayList <String> recips = new ArrayList <String> ();
	
	public EmailInfo () {
		
	}
	
	public EmailInfo (String emailId, int id, int cid) {
		try {
			if (emailId.startsWith("pgp")) {
				emailId = emailId.substring(4);
			}
			String command = "SELECT Owner, Owner_cid, XML from og_encrypted_items WHERE Id = ?";
			DbCommand com = new DbCommand(command);
			com.addVariables(emailId);
			DbQuery db = new DbQuery();
			db.read(com, id, cid);
			if (db.next()) {
				owner_id = db.rs.getInt("Owner");
				owner_cid = db.rs.getInt("Owner_cid");
			    populate_recips (db.rs.getString("XML"));

			}
			db.close();
			if (owner_cid != 0) {
				command = "SELECT email from og_email WHERE id = ? AND cid = ?";
				com = new DbCommand(command);
				com.addVariables(owner_id);
				com.addVariables(owner_cid);
				db = new DbQuery();
				db.readOG(com);
				if (db.next()) {
					senderEmail = db.rs.getString("email");
				}
				db.close();
				command = "SELECT email from og_email WHERE id = ? AND cid = ?";
				com = new DbCommand(command);
				com.addVariables(id);
				com.addVariables(cid);
				db = new DbQuery();
				db.readOG(com);
				if (db.next()) {
					fromEmail = db.rs.getString("email");
				}
				db.close();
			}
			
		} catch (Exception ex) {
			logger.error("Problem retrieving email info ", ex);
		}
	}
	
	private void populate_recips (String XML) throws ParserConfigurationException, UnsupportedEncodingException, SAXException, IOException {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        org.w3c.dom.Document doc = builder.parse(new InputSource(new ByteArrayInputStream(XML.getBytes("utf-8"))));
        doc.getDocumentElement().normalize();
        Element share = (Element) doc.getElementsByTagName("share").item(0);
        NodeList users = share.getChildNodes();
        for (int i = 0; i < users.getLength(); i++) {
            Element user = (Element) users.item(i);
            if (user.getElementsByTagName("e").item(0) != null) {
            	recips.add(user.getElementsByTagName("e").item(0).getTextContent());
            }
        }
	}
}
