/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.database;

public class DbStrings {

    public static final String createKeyTable = "CREATE TABLE `og_KeyTable` (`id` int(11) NOT NULL AUTO_INCREMENT, `PGPSecret` text COLLATE utf8_unicode_ci," + 
    "`PGPPublic` text COLLATE utf8_unicode_ci, `RSAPrivate` varchar(3072) COLLATE utf8_unicode_ci, `RSAPublic` varchar(1024) COLLATE utf8_unicode_ci," + 
    		" `Recovery` varchar(500) COLLATE utf8_unicode_ci, `Salt` varchar(40) COLLATE utf8_unicode_ci, `cid` int(11) NOT NULL DEFAULT '0'," + 
    " `email` varchar(50) COLLATE utf8_unicode_ci NOT NULL, " + " `lastMod` date DEFAULT NULL, `question` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL, " + 
    		" `answer` varchar(1024) COLLATE utf8_unicode_ci DEFAULT NULL, `misc` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL, `lang`  varchar(6) COLLATE utf8_unicode_ci DEFAULT NULL ," + 
    " `settings` varchar(1024) COLLATE utf8_unicode_ci DEFAULT NULL, " + 
    " `current` bit(1) NOT NULL DEFAULT b'1', " +
    " `keyid` bigint(20) NOT NULL DEFAULT '0', " +
    " `version` int(10) unsigned zerofill NOT NULL DEFAULT '0000000000', " +
    " `inline` bit(1) NOT NULL DEFAULT b'0', " +
    " PRIMARY KEY (`id`,`cid`,`keyid`), " + " KEY `email` (`email`)) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
    
    // Global keytable is same as regular keytable, but keyid is not a primary key.  Can only have one key per cid/userid
    public static final String createGlobalKeyTable = "CREATE TABLE `og_KeyTable` (`id` int(11) NOT NULL AUTO_INCREMENT, `PGPSecret` text COLLATE utf8_unicode_ci," + 
    "`PGPPublic` text COLLATE utf8_unicode_ci, `RSAPrivate` varchar(3072) COLLATE utf8_unicode_ci, `RSAPublic` varchar(1024) COLLATE utf8_unicode_ci," + 
            " `Recovery` varchar(500) COLLATE utf8_unicode_ci, `Salt` varchar(40) COLLATE utf8_unicode_ci, `cid` int(11) NOT NULL DEFAULT '0'," + 
    " `email` varchar(50) COLLATE utf8_unicode_ci NOT NULL, " + " `lastMod` date DEFAULT NULL, `question` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL, " + 
            " `answer` varchar(1024) COLLATE utf8_unicode_ci DEFAULT NULL, `misc` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL, `lang`  varchar(6) COLLATE utf8_unicode_ci DEFAULT NULL ," + 
    " `settings` varchar(1024) COLLATE utf8_unicode_ci DEFAULT NULL, " + 
    " `current` bit(1) NOT NULL DEFAULT b'1', " +
    " `keyid` bigint(20) NOT NULL DEFAULT '0', " +
    " `version` int(10) unsigned zerofill NOT NULL DEFAULT '0000000000', " +
    " `inline` bit(1) NOT NULL DEFAULT b'0', " +
    " PRIMARY KEY (`id`,`cid`), " + " KEY `email` (`email`)) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";

    public static final String createContentKeyTable = "CREATE TABLE `og_content_keys` ( `ItemId` varchar(38) NOT NULL,  `UserId` int(11) DEFAULT NULL," + " `ContentKey` varchar(400) DEFAULT NULL, `Status` int(11) DEFAULT NULL, `ID` int(11) NOT NULL AUTO_INCREMENT," + " `CID` int(11) DEFAULT NULL, PRIMARY KEY (`ID`), KEY `ID` (`ItemId`)) ENGINE=InnoDB AUTO_INCREMENT=284 DEFAULT CHARSET=utf8;";

    public static final String createEncryptedTable = "CREATE TABLE `og_encrypted_items` ( `Id` varchar(38) NOT NULL,  `Owner` int(11) DEFAULT NULL, " + " `Expiration` bigint(20) DEFAULT NULL, `Type` int(11) DEFAULT NULL, `XML` varchar(10000) DEFAULT NULL, " + " `Owner_cid` int(11) DEFAULT NULL, `Salt` varchar(50) DEFAULT NULL, PRIMARY KEY (`Id`(36))) ENGINE=InnoDB DEFAULT CHARSET=utf8;";

    public static final String createPGPKeysTable = "CREATE TABLE `og_pgp_keys` (`ids` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',  `Email` varchar(250) COLLATE utf8_unicode_ci NOT NULL DEFAULT '', `PGPPublic` text COLLATE utf8_unicode_ci DEFAULT NULL, `userid` int(11) NOT NULL DEFAULT '0', `cid` int(11) NOT NULL DEFAULT '0', `share_level` int(11) DEFAULT NULL, `inline` bit(1) DEFAULT b'0', PRIMARY KEY (`Email`,`cid`,`userid`), KEY `id` (`ids`), KEY `Email` (`Email`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
    
    public static final String createPGPKeysLookupTable = "CREATE TABLE `PGPKeys` (`id` bigint(20) NOT NULL DEFAULT '0', " +
    		"`email` varchar(100) NOT NULL DEFAULT '', "+
    		"`hexid` varchar(20) NOT NULL DEFAULT '', " +
    		"`cid` int(11) DEFAULT NULL, " +
    		"`local` bit(1) DEFAULT NULL, " +
    		"`keyid` bigint(20) DEFAULT NULL, " +
    		"PRIMARY KEY (`id`), " +
    		"KEY `email` (`email`), " +
    		"KEY `hexid` (`hexid`) " +
    		") ENGINE=InnoDB DEFAULT CHARSET=utf8;";		
    
    public static final String createRemoteKeys = "CREATE TABLE `remote_keys` (" +
            "`id` bigint(20) NOT NULL DEFAULT '0', " +
            "`email` varchar(100) NOT NULL DEFAULT '', " +
            "`ref` bigint(20) DEFAULT NULL, " +
            "PRIMARY KEY (`id`,`email`) " +
            ") ENGINE=InnoDB DEFAULT CHARSET=utf8;";
    
    public static final String createRemoteKeyCache = "CREATE TABLE `remote_key_cache` (" +
            "`id` bigint(20) NOT NULL DEFAULT '0', "+
            "`ring` text, " +
            "`created` datetime DEFAULT NULL, " +
            "PRIMARY KEY (`id`) " +
            ") ENGINE=InnoDB DEFAULT CHARSET=utf8;";
    
    public static final String createDeletedKeys = "CREATE TABLE `deletedKeys` (" +
            "`index` int(11) NOT NULL AUTO_INCREMENT, " +
            "`id` int(11) NOT NULL DEFAULT '0'," +
            "`cid` int(11) NOT NULL DEFAULT '0', " +
            "`email` varchar(100) NOT NULL DEFAULT '', "+
            "`PGPSecret` text, " +
            "`salt` varchar(40) DEFAULT NULL, " +
            "`recovery` varchar(500) DEFAULT NULL, " +
            "`version` int(11) DEFAULT NULL, " +
            "`exposed` bit(1) DEFAULT b'0', " +
            "`exposed_date` datetime DEFAULT NULL, " +
            "`deleted_date` datetime DEFAULT NULL, " +
            "PRIMARY KEY (`index`), " +
            "KEY `email` (`email`), " +
            "KEY `cid` (`cid`)" +
            ") ENGINE=InnoDB DEFAULT CHARSET=utf8;";
    
    public static final String createShardingTable = "CREATE TABLE `sharding` (`current_shard` " +
            "int(11) NOT NULL DEFAULT '0' ,`count` int(11) DEFAULT NULL, PRIMARY KEY (`current_shard`)) " +
            "ENGINE=InnoDB DEFAULT CHARSET=utf8;";
    
    public static final String createFileCacheTable = "CREATE TABLE `FileCache` (" +
            "`itemID` varchar(200) NOT NULL, " +
            "`userid` int(11) NOT NULL, " +
            "`location` varchar(255) DEFAULT NULL, " +
            "`lastDate` date DEFAULT NULL, " +
            "PRIMARY KEY (`itemID`), " +
            "KEY `item` (`itemID`) " +
            ") ENGINE=InnoDB DEFAULT CHARSET=latin1";
    
    public static final String createOGEmail = "CREATE TABLE `og_email` (`email`  varchar(200) NULL ,`id`  int NULL ,`cid`  int NULL ,`db`  int NULL ," + " PRIMARY KEY (`email`), INDEX `uid` (`id`, `cid`));";
    
    public static final String createSessions = "CREATE TABLE `oxguard_session` (`sessionid` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT ''," + " `token` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL, `date` datetime DEFAULT NULL, `userid` int(11) NOT NULL," + " `cid` int(11) DEFAULT NULL, PRIMARY KEY (`sessionid`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
    
    public static final String createRSACache = "CREATE TABLE `cache` (  `email` varchar(50) NOT NULL, `RSAPublic` varchar(1024) DEFAULT NULL, `date` datetime DEFAULT NULL," + " PRIMARY KEY (`email`)) ENGINE=InnoDB DEFAULT CHARSET=latin1;";
    
    public static final String createPGPPublic = "CREATE TABLE `PublicPGP` (  `email` varchar(50) NOT NULL DEFAULT '',  `PublicKeyRing` varchar(2048) DEFAULT NULL,  `LastUp` date DEFAULT NULL,  PRIMARY KEY (`email`)) ENGINE=InnoDB DEFAULT CHARSET=latin1;";
    
    public static final String createBadTable = "CREATE TABLE `Bad` (`id`  varchar(100) NOT NULL , `count`  int NULL ,`last`  datetime NULL ,   PRIMARY KEY (`id`));";
    
    public static final String createIOXTable = "CREATE TABLE `iox` (`domain` varchar(50) NOT NULL DEFAULT '',  `url` varchar(500) DEFAULT NULL, `token` varchar(50) DEFAULT NULL," + " `lastcheck` date DEFAULT NULL,  PRIMARY KEY (`domain`)) ENGINE=InnoDB DEFAULT CHARSET=latin1;";
    
    public static final String createKeyCache = "CREATE TABLE `key_cache` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `privkey` varchar(5000) DEFAULT NULL," + "PRIMARY KEY (`id`)) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;";
    
    public static final String createGlobalSettings =  "CREATE TABLE `global_settings` (  `key` varchar(20) NOT NULL DEFAULT '', `value` varchar(250) DEFAULT NULL," + " PRIMARY KEY (`key`)) ENGINE=InnoDB DEFAULT CHARSET=latin1;";
    
}
