/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.guard.cron;

import java.util.ArrayList;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.database.DbCommand;
import com.openexchange.guard.database.DbQuery;
import com.openexchange.guard.storage.Storage;


public class CleanCache extends TimerTask {

	private static Logger logger = LoggerFactory.getLogger(CleanCache.class);

    @Override
    public void run() {
        DbQuery db = new DbQuery();

        try {
            logger.info("Running Scheduled cleanup of File Cache");

            ArrayList<String> list = new ArrayList<String>();
            String command = "select itemID, location from FileCache WHERE lastDate < DATE_SUB(NOW(), INTERVAL " + Config.cachedays + " DAY);";
            DbCommand com = new DbCommand(command);
            db.readOG(com);
            if (db.next()) {
                String location = db.rs.getString("location");

                try {
                	Storage.deleteEncrObj(location);
                    list.add(db.rs.getString("itemID"));
                } catch (Exception ex) {
                	logger.error("Error delete object ", ex);
                }
                list.add(db.rs.getString("itemID"));

            }
            for (int j = 0; j < list.size(); j++) { // Delete from database all files removed
                command = "DELETE FROM FileCache WHERE itemID = ?;";
                com = new DbCommand(command);
                com.addVariables(list.get(j));
                db.writeOxGuard(com);
            }
            db.close();
            logger.info("Deleted " + list.size() + " files");

            logger.info("Running Scheduled cleanup of PGP Cache");
            command = "SELECT id FROM remote_key_cache WHERE created < DATE_SUB(NOW(), INTERVAL " + Config.pgpCacheDays + " DAY);";
            com = new DbCommand(command);
            db.readOG(com);
            StringBuilder ids = new StringBuilder();
            int count = 0;
            while (db.next()) {
                Long id = db.rs.getLong("id");
                if (count == 0) {
                    ids.append("(" + Long.toString(id));
                } else {
                    ids.append(", " + Long.toString(id));
                }
                count++;
            }
            db.close();
            if (count > 0) {
                // If there are some, then delete corresponding reference keys
                ids.append(")");
                command = "DELETE FROM remote_keys WHERE ref IN " + ids.toString();
                com = new DbCommand(command);
                db = new DbQuery();
                db.writeOxGuard(com);
                db.close();
                // OK, now clean up the original table
                command = "DELETE FROM remote_key_cache WHERE created < DATE_SUB(NOW(), INTERVAL " + Config.pgpCacheDays + " DAY);";
                com = new DbCommand(command);
                db = new DbQuery();
                db.writeOxGuard(com);
                db.close();
                logger.info("Deleted " + count + " old PGP key rings");
            }

        } catch (Exception e) {
            logger.error("Error while doing scheduled cleanup of file cache", e);
        } finally {
            db.close();
        }

    }

}
