/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudsearchdomain.model.SuggestRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class SuggestRequestMarshaller
implements Marshaller<Request<SuggestRequest>, SuggestRequest> {
    @Override
    public Request<SuggestRequest> marshall(SuggestRequest suggestRequest) {
        if (suggestRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SuggestRequest> request = new DefaultRequest<SuggestRequest>(suggestRequest, "AmazonCloudSearchDomain");
        String target = "AmazonCloudSearch2013.Suggest";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-01-01/suggest?format=sdk&pretty=true&q={Query}&suggester={Suggester}&size={Size}";
        uriResourcePath = uriResourcePath.replace("{Query}", suggestRequest.getQuery() == null ? "" : StringUtils.fromString(suggestRequest.getQuery()));
        uriResourcePath = uriResourcePath.replace("{Suggester}", suggestRequest.getSuggester() == null ? "" : StringUtils.fromString(suggestRequest.getSuggester()));
        uriResourcePath = uriResourcePath.replace("{Size}", suggestRequest.getSize() == null ? "" : StringUtils.fromLong(suggestRequest.getSize()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        return request;
    }
}

