/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.Arrays;
import junit.framework.TestCase;
import org.xbill.DNS.DNSOutput;

public class DNSOutputTest
extends TestCase {
    private DNSOutput m_do;

    public void setUp() {
        this.m_do = new DNSOutput(1);
    }

    private void assertEquals(byte[] exp, byte[] act) {
        DNSOutputTest.assertTrue((boolean)Arrays.equals(exp, act));
    }

    public void test_default_ctor() {
        this.m_do = new DNSOutput();
        DNSOutputTest.assertEquals((int)0, (int)this.m_do.current());
    }

    public void test_initial_state() {
        DNSOutputTest.assertEquals((int)0, (int)this.m_do.current());
        try {
            this.m_do.restore();
            DNSOutputTest.fail((String)"IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            this.m_do.jump(1);
            DNSOutputTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_writeU8_basic() {
        this.m_do.writeU8(1);
        DNSOutputTest.assertEquals((int)1, (int)this.m_do.current());
        byte[] curr = this.m_do.toByteArray();
        DNSOutputTest.assertEquals((int)1, (int)curr.length);
        DNSOutputTest.assertEquals((int)1, (int)curr[0]);
    }

    public void test_writeU8_expand() {
        this.m_do.writeU8(1);
        this.m_do.writeU8(2);
        DNSOutputTest.assertEquals((int)2, (int)this.m_do.current());
        byte[] curr = this.m_do.toByteArray();
        DNSOutputTest.assertEquals((int)2, (int)curr.length);
        DNSOutputTest.assertEquals((int)1, (int)curr[0]);
        DNSOutputTest.assertEquals((int)2, (int)curr[1]);
    }

    public void test_writeU8_max() {
        this.m_do.writeU8(255);
        byte[] curr = this.m_do.toByteArray();
        DNSOutputTest.assertEquals((byte)-1, (byte)curr[0]);
    }

    public void test_writeU8_toobig() {
        try {
            this.m_do.writeU8(511);
            DNSOutputTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_writeU16_basic() {
        this.m_do.writeU16(256);
        DNSOutputTest.assertEquals((int)2, (int)this.m_do.current());
        byte[] curr = this.m_do.toByteArray();
        DNSOutputTest.assertEquals((int)2, (int)curr.length);
        DNSOutputTest.assertEquals((int)1, (int)curr[0]);
        DNSOutputTest.assertEquals((int)0, (int)curr[1]);
    }

    public void test_writeU16_max() {
        this.m_do.writeU16(65535);
        byte[] curr = this.m_do.toByteArray();
        DNSOutputTest.assertEquals((byte)-1, (byte)curr[0]);
        DNSOutputTest.assertEquals((byte)-1, (byte)curr[1]);
    }

    public void test_writeU16_toobig() {
        try {
            this.m_do.writeU16(131071);
            DNSOutputTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_writeU32_basic() {
        this.m_do.writeU32(0x11001011L);
        DNSOutputTest.assertEquals((int)4, (int)this.m_do.current());
        byte[] curr = this.m_do.toByteArray();
        DNSOutputTest.assertEquals((int)4, (int)curr.length);
        DNSOutputTest.assertEquals((int)17, (int)curr[0]);
        DNSOutputTest.assertEquals((int)0, (int)curr[1]);
        DNSOutputTest.assertEquals((int)16, (int)curr[2]);
        DNSOutputTest.assertEquals((int)17, (int)curr[3]);
    }

    public void test_writeU32_max() {
        this.m_do.writeU32(0xFFFFFFFFL);
        byte[] curr = this.m_do.toByteArray();
        DNSOutputTest.assertEquals((byte)-1, (byte)curr[0]);
        DNSOutputTest.assertEquals((byte)-1, (byte)curr[1]);
        DNSOutputTest.assertEquals((byte)-1, (byte)curr[2]);
        DNSOutputTest.assertEquals((byte)-1, (byte)curr[3]);
    }

    public void test_writeU32_toobig() {
        try {
            this.m_do.writeU32(0x1FFFFFFFFL);
            DNSOutputTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_jump_basic() {
        this.m_do.writeU32(287454020L);
        DNSOutputTest.assertEquals((int)4, (int)this.m_do.current());
        this.m_do.jump(2);
        DNSOutputTest.assertEquals((int)2, (int)this.m_do.current());
        this.m_do.writeU8(153);
        byte[] curr = this.m_do.toByteArray();
        DNSOutputTest.assertEquals((int)3, (int)curr.length);
        DNSOutputTest.assertEquals((int)17, (int)curr[0]);
        DNSOutputTest.assertEquals((int)34, (int)curr[1]);
        DNSOutputTest.assertEquals((byte)-103, (byte)curr[2]);
    }

    public void test_writeByteArray_1arg() {
        byte[] in = new byte[]{-85, -51, -17, 18, 52};
        this.m_do.writeByteArray(in);
        DNSOutputTest.assertEquals((int)5, (int)this.m_do.current());
        byte[] curr = this.m_do.toByteArray();
        this.assertEquals(in, curr);
    }

    public void test_writeByteArray_3arg() {
        byte[] in = new byte[]{-85, -51, -17, 18, 52};
        this.m_do.writeByteArray(in, 2, 3);
        DNSOutputTest.assertEquals((int)3, (int)this.m_do.current());
        byte[] exp = new byte[]{in[2], in[3], in[4]};
        byte[] curr = this.m_do.toByteArray();
        this.assertEquals(exp, curr);
    }

    public void test_writeCountedString_basic() {
        byte[] in = new byte[]{104, 101, 108, 76, 48};
        this.m_do.writeCountedString(in);
        DNSOutputTest.assertEquals((int)(in.length + 1), (int)this.m_do.current());
        byte[] curr = this.m_do.toByteArray();
        byte[] exp = new byte[]{(byte)in.length, in[0], in[1], in[2], in[3], in[4]};
        this.assertEquals(exp, curr);
    }

    public void test_writeCountedString_empty() {
        byte[] in = new byte[]{};
        this.m_do.writeCountedString(in);
        DNSOutputTest.assertEquals((int)(in.length + 1), (int)this.m_do.current());
        byte[] curr = this.m_do.toByteArray();
        byte[] exp = new byte[]{(byte)in.length};
        this.assertEquals(exp, curr);
    }

    public void test_writeCountedString_toobig() {
        byte[] in = new byte[256];
        try {
            this.m_do.writeCountedString(in);
            DNSOutputTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_save_restore() {
        this.m_do.writeU32(305419896L);
        DNSOutputTest.assertEquals((int)4, (int)this.m_do.current());
        this.m_do.save();
        this.m_do.writeU16(43981);
        DNSOutputTest.assertEquals((int)6, (int)this.m_do.current());
        this.m_do.restore();
        DNSOutputTest.assertEquals((int)4, (int)this.m_do.current());
        try {
            this.m_do.restore();
            DNSOutputTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

