/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/register', ['io.ox/core/extensions', 'oxguard/oxguard_core',
                           'gettext!oxguard/register', 'css!oxguard/style.css'],
                           function (ext, oxguard, gt) {
    'use strict';
    
    
    var oxguarddata = {
            passcode : null,
            settings:  {},
          //  oldcompose : (ox.version.indexOf('7.6.') > -1),
            oldcompose: true, // mark oldcompose always true for this version
            version: '2.0.0-2626'

        };
    window.oxguarddata = oxguarddata;
    
    // Login section
    sendauth(''); // initial login, no password yet
    
    
   
    function sendauth(pass)
    {
        oxguard.auth(ox.user_id, pass)
        .done(function (data) {
            try {
                if (data.auth.length > 20) {// If good code comes back, then store userid
                    oxguarddata.userid = ox.user_id;
                    oxguarddata.passcode = data.auth;
                    $('.og_signout').show();
                } else {// If bad code, then log and mark oxguard.user_id as -1
                    if ((data.auth.indexOf('Bad') > -1) || (data.auth.indexOf('Lockout') > -1)) {
                        oxguarddata.passcode = null;
                    } else {
                        oxguarddata.passcode = data.auth;
                    }
                    oxguarddata.userid = -1;
                }
                if (ox.context_id === 0) ox.context_id = data.cid; // If the cid wasn't loaded, update from backend
                oxguarddata.settings = data.settings; // user settings
                oxguarddata.lang = data.lang;// Languages available
                oxguarddata.server = data.server;
                oxguarddata.baton = window.oxguarddata.baton;
                oxguarddata.pubkey = data.pubKey;
                oxguarddata.recovery = data.recoveryAvail;
                window.oxguarddata = oxguarddata;
                
                if (window.oxguarddata.baton !== undefined) {
                    require(['oxguard/register_mail'], function (mail) {
                        mail.checkOG(window.oxguarddata.baton);
                    });
                    window.oxguarddata.baton = undefined;
                }
                if (sessionStorage !== null) {// If we were passed login info from login screen
                    try {
                        if (sessionStorage.oxguard && (sessionStorage.oxguard !== 'null')) {
                            var p = sessionStorage.oxguard;
                            sessionStorage.oxguard = null;
                            sendauth(p);
                        }
                    } catch (e) {
                        console.log('Private mode');
                        return;
                    }
                }
            } catch (e) {
                console.log(e);
                console.debug('Unable to connect to the encryption server');
            }
        })
        .fail(function () {
            $('.og_signout').hide();
        	console.debug('Unable to connect to the encryption server');
        });
    }

    ext.point('io.ox/core/logout').extend({
        id: 'logoutOG',
        logout: function () {
            // force save requests for all pending settings
            var params = '&userid=' + ox.user_id + '&cid=' + ox.context_id;
            $.get(ox.apiRoot + '/oxguard/login?action=logout' + params, function () {
                window.oxguarddata = null;
            })
            .fail(function () {
                console.log('Fail logout oxguard');
            });
            
        }
    });
 
    ext.point('io.ox/core/topbar/right/dropdown').extend({
        id: 'logoutOG',
        index: 990,
        draw: function () {
            this.append(
                $('<li class="divider og_signout" aria-hidden="true" role="presentation"></li>'),
                $('<li class="og_signout">').append(
                    $('<a href="#" data-action="logout" role="menuitem" tabindex="1">').text(gt('Sign out Guard'))
                )
                .on('click', function (e) {
                    e.preventDefault();
                    window.oxguarddata.passcode = null;
                    $('.og_signout').hide();
                })
            );
            var auth = window.oxguarddata.passcode;
            if (auth === null) {
                hideLogout();
                return;
            }
            if (auth.length < 20) hideLogout();
            
        }
    });
    
    function hideLogout() {
        window.setTimeout(function () {
            $('.og_signout').hide();
        },100);
    }
    


    
 
});
