/* All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/pgp/register', ['io.ox/core/extensions', 'io.ox/core/extPatterns/links', 'oxguard/core/og_http',
                           'gettext!oxguard/register'],
                           function (ext, links, http, gt) {
    'use strict';
    
    var popupBlockCount = 0;
    
    ext.point('io.ox/mail/detail').extend({
        index: 2,
        id: 'ogPGPCheck',
        draw: function (baton) {
            checkPGP.call(this, baton);
            baton.view.listenTo(baton.view.model, 'change:attachments', function () {
                checkPGP(baton);
                if (baton.view.$el === null) return;
                window.setTimeout(function () {
                    if (baton.view.$el !== null)
                        baton.view.$el.find('#oxgrpass').focus();
                }, 50);
                
            });
        }
    });
            
    
    ext.point('io.ox/mail/mobile/detail/header').extend({
        index: 230,
        id: 'ogPGPCheckMobile',
        draw: function (baton) {
            checkPGP.call(this, baton);  
            baton.view.listenTo(baton.view.model, 'change:attachments', function () {
                checkPGP(baton);
                if (baton.view.$el === null) return;
                window.setTimeout(function () {
                    baton.view.$el.find('#oxgrpass').focus();
                }, 50);
            });
        }
    });
    
    // Add lock to header
    ext.point('io.ox/mail/detail/header').extend({
        index: 230,
        id: 'pgpMailLock',
        draw: function (baton) {
            if (baton.data.PGPresults !== undefined) {
                // Add lock symbol to header
                var lockdiv = $('<div style="float:left; padding-right:5px;" id="lockdiv" class="oxguard_lock" ></div>');
                var lockstack = '<span class="icon-stack" title="' + gt('This Email was sent using PGP encryption. It has been decrypted with your private key') + '"><i class="icon-lock icon-large icon-stack-base fa fa-lock -fa-large oxguard_lock" />' +
                    '<i class ="icon-star-half-empty" style="color:black; margin-top:5px;"/></span>';
                lockdiv.append($(lockstack));
                if (baton.data.PGPresults.verified === true) {
                    lockdiv.append('<i class="icon-edit" title="' + gt('This Email was signed by the sender and verified') + '"/>');
                }
                
                $(this).prepend(lockdiv);
             
            }
        }
    });
    
    // Action to open OxGuard attachment
    new links.Action('io.ox/mail/actions/open-OGPGPattachment', {
        id: 'openOGPGP',
        requires: function (e) {
            return(!isInline(e) && isPGPAttach(e));
        },
        multiple: function (list) {
            _(list).each(function (data) {
                    var params = '&emailid=' + data.mail.id +
                    '&attach=' + data.id +
                    '&session=' + ox.session +
                    '&auth=' + encodeURIComponent(window.oxguarddata.passcode) +
                    '&userid=' + ox.user_id +
                    '&cid=' + ox.context_id +
                    '&epassword=' + encodeURIComponent(data.epass) +
                    '&folder=' + data.mail.folder_id +
                    '&attname=' + encodeURIComponent(data.filename);
                    var link = ox.apiRoot + '/oxguard/pgpmail/' + encodeURIComponent(data.filename) + '?action=getattach' + params;
                    var popup = window.open(link);
                    if (popup === null || popup === undefined) {
                        // If popup blocked, give one try to see if user notices, otherwise alert message regarding blocking
                        if (popupBlockCount === 1) {
                            require (['io.ox/core/notifications'], function (notifications) {
                            //#. Error message when trying to open a file with popup blocker on browser blocking
                                notifications.yell('error', gt('Your pop-up blocker may have prevented a Guard window that provides application functionality.'));
                            });
                            //  window.location.href = link;
                        }
                        popupBlockCount++;
                    }
            });
        }
    });
    
    // Download encrypted attachment
    new links.Action('io.ox/mail/actions/download-OGPGPattachment', {
        id: 'DownloadOGPGP',
        requires: function (e) {
            return(!isInline(e) && isPGPAttach(e));
        },
        multiple: function (list) {
            _(list).each(function (data) {
                var params = '&emailid=' + data.mail.id +
                '&attach=' + data.id +
                '&session=' + ox.session +
                '&auth=' + encodeURIComponent(window.oxguarddata.passcode) +
                '&userid=' + ox.user_id +
                '&cid=' + ox.context_id +
                '&epassword=' + encodeURIComponent(data.epass) +
                '&folder=' + data.mail.folder_id +
                '&download=true' +
                '&attname=' + encodeURIComponent(data.filename);
                var link = ox.apiRoot + '/oxguard/pgpmail/' + encodeURIComponent(data.filename) + '?action=getattach' + params;
                $('#tmp').append(
                        $('<iframe>', { src: link, 'class': 'hidden download-frame', id: 'download' + data.id })
                    );
            });
        }
    });
    
    // Check if attachment filename ends with .asc
    function isASC (e) {
        try {
            if (e.context instanceof Array) {
                for (var i = 0; i < e.context.length; i++) {
                    if (e.context[i].filename.indexOf('.asc') > 0) {
                        // Do not return positive for signatures.  Handled differently
                        if (e.context[i].content_type.indexOf('sig') > 0) return(false);
                        return(true);
                    }
                }
            }
            var filename = e.context.filename;
            if (filename === undefined) return(false);
            if (e.context.content_type.indexOf('sig') > 0) return(false);
            return (filename.indexOf('.asc') > 0);
        } catch (d) {
            console.log(d);
            return(false);
        }
    }
    
    function isInline(e) {
        try {
            if (e.context instanceof Array) {
                for (var i = 0; i < e.context.length; i++) {
                    if (e.context[i].filename.indexOf('.pgp') > 0) return(true);
                }
            }
            var filename = e.context.filename;
            if (filename === undefined) return(false);
            return (filename.indexOf('.pgp') > 0);
        } catch (d) {
            console.log(d);
            return(false);
        }
    }
    // Download encrypted inline attachment
    new links.Action('io.ox/mail/actions/download-OGPGPinline', {
        id: 'DownloadOGPGPinline',
        requires: function (e) {
            return(isInline(e));
        },
        multiple: function (list) {
            _(list).each(function (data) {
                var filename = data.filename.replace('.pgp', '');
                var params = '&emailid=' + data.mail.id +
                '&attach=' + data.id +
                '&session=' + ox.session +
                '&auth=' + encodeURIComponent(window.oxguarddata.passcode) +
                '&userid=' + ox.user_id +
                '&cid=' + ox.context_id +
                '&epassword=' + encodeURIComponent(data.epass) +
                '&folder=' + data.mail.folder_id +
                '&cc=' + data.cc +
                '&download=true' +
                '&attname=' + encodeURIComponent(filename);
                var link = ox.apiRoot + '/oxguard/pgpmail/' + encodeURIComponent(filename) + '?action=getinlineattach' + params;
                $('#tmp').append(
                        $('<iframe>', { src: link, 'class': 'hidden download-frame', id: 'download' + data.id })
                    );
            });
        }
    });
    // Save decoded PGP attachment
    new links.Action('io.ox/mail/actions/save-OGPGPattachment', {
        id: 'SaveDecodedPGPAttachment',
        requires: function(e) {
            if (e.baton.data instanceof Array) {
                return (e.baton.data[0].pgpFormat !== undefined);
            }
            return (e.baton.data.pgpFormat !== undefined);
        },
        multiple: function (list) {
            require(['oxguard/pgp/saveattach'], function (action) {
                action.multiple(list, true);
            });
        }
    });
    // Save encrypted PGP attachment to drive
    new links.Action('io.ox/mail/actions/save-OGPGPEncrypted', {
        id: 'SaveDecodedPGPAttachment',
        requires: function(e) {
            if (e.baton.data instanceof Array) {
                return (e.baton.data[0].pgpFormat !== undefined);
            }
            return (e.baton.data.pgpFormat !== undefined);
        },
        multiple: function (list) {
            if (list[0].pgpFormat === 'pgpinline') {
                require(['io.ox/mail/actions/attachmentSave'], function (action) {
                    action.multiple(list);
                });
            } else {
                require(['oxguard/pgp/saveattach'], function (action) {
                    action.multiple(list, false);
                });
            }
        }
    });
    
    new links.Action('io.ox/mail/actions/open-OGPGPinline', {
        id: 'openOGPGPinline',
        requires: function (e) {
            return(isInline(e));
        },
        multiple: function (list) {
            _(list).each(function (data) {
                    var filename = data.filename.replace('.pgp', '');
                    var params = '&emailid=' + data.mail.id +
                    '&attach=' + data.id +
                    '&session=' + ox.session +
                    '&auth=' + encodeURIComponent(window.oxguarddata.passcode) +
                    '&userid=' + ox.user_id +
                    '&cid=' + ox.context_id +
                    '&epassword=' + encodeURIComponent(data.epass) +
                    '&folder=' + data.mail.folder_id +
                    '&attname=' + encodeURIComponent(filename);
                    var link = ox.apiRoot + '/oxguard/pgpmail/' + encodeURIComponent(filename) + '?action=getinlineattach' + params;
                    var popup = window.open(link);
                    if (popup === null || popup === undefined) {
                        // If popup blocked, give one try to see if user notices, otherwise alert message regarding blocking
                        if (popupBlockCount === 1) {
                            require (['io.ox/core/notifications'], function (notifications) {
                            //#. Error message when trying to open a file with popup blocker on browser blocking
                                notifications.yell('error', gt('Your pop-up blocker may have prevented a Guard window that provides application functionality.'));
                            });
                            //  window.location.href = link;
                        }
                        popupBlockCount++;
                    }
            });
        }
    });
    
    new links.Action('io.ox/mail/actions/PGPPublicKey', {
        id: 'PGPKey',
        requires: function (e) {
            if (isASC(e)) {
                if (e.collection.has('one')) { // only return true for individual files
                    var type;
                    var name;
                    if (e.context instanceof Array) {
                        type = e.context[0].content_type;
                        name = e.context[0].filename;
                    } else {
                        type = e.context.content_type;
                        name = e.context.filename;
                    }
                    if (type==='application/pgp-keys') return(true);
                    if (name==='public.asc') return(true);
                    return (false); 
                }
            }
            return(false);
        },
        multiple: function (list) {
            if (window.oxguarddata.passcode === 'No Key') {
                require(['oxguard/oxguard_core'], function(core) {
                    core.createKeys('')
                    .done(function () {
                        loadPublicKey(list);
                    });
                });
            } else {
                console.log(list);
                loadPublicKey(list);
            }
            
        }
    });
    
    function loadPublicKey (list) {
        _(list).each(function (data) {
            var params = '&emailid=' + data.mail.id +
            '&attach=' + data.id +
            '&session=' + ox.session +
            '&userid=' + ox.user_id +
            '&cid=' + ox.context_id +
            '&folder=' + data.mail.folder_id;
            if (data.pgpFormat !== undefined) { //If encrypted
                params = params + '&epass=' + encodeURIComponent(data.epass) +
                '&inline=' + ((data.pgpFormat==='pgpinline') ? 'true' : 'false') + 
                '&filename=' + encodeURIComponent(data.filename);
            }
            var link = ox.apiRoot + '/oxguard/pgpmail/?action=savepublicattach' + params;
            http.get(link, '')
            .done(function (data) {
                require(['io.ox/core/notifications'], function (notify) {
                    var keys = JSON.parse(data);
                    var added = gt('Added keys: \r\n');
                    for (var i = 0; i < keys.length; i++) {
                        added = added + gt('Key ID: ') + keys[i].Key + ' ' + keys[i].ids + '\r\n';
                    }
                    notify.yell('success', added);
                });
            })
            .fail(function (e) {
                console.log(e);
                require(['io.ox/core/notifications'], function (notify) {
                    if (e.status === 503) {
                        notify.yell('error', gt('Service Unavailable'));
                    } else
                        notify.yell('error', e.responseText);
                });
            });
        });
    }
    
    // Open PGP encrypted VCARD
    new links.Action('io.ox/mail/actions/save-VCard', {
        id: 'VCardOG',
        requires: function(e) {
            if (e.context instanceof Array) { return(false); }
            if (e.context.content_type === undefined) { return(false); }
            if (e.context.content_type.indexOf('text/vcard') > -1) { 
                if (e.context.epass !== undefined) return (true); 
                }
            if (e.context.filename.indexOf('.vcf.pgp') > 0) return(true);
            return (false);
        },
        multiple: function (list) {
            require (['settings!io.ox/core', 'io.ox/core/notifications'], function (coreConfig, notify) {
                _(list).each(function (data) {
                    var contact_folder = coreConfig.get('folder/contacts');
                    var params = '&emailid=' + data.mail.id +
                    '&attach=' + data.id +
                    '&session=' + ox.session +
                    '&userid=' + ox.user_id +
                    '&cid=' + ox.context_id +
                    '&epass=' + encodeURIComponent(data.epass) +
                    '&filename=' + encodeURIComponent(data.filename) +
                    '&contacts=' + contact_folder +
                    '&inline=' + (data.pgpFormat === 'pgpinline' ? 'true' : 'false') +
                    '&folder=' + data.mail.folder_id;
                    var link = ox.apiRoot + '/oxguard/pgpmail/?action=importvcard' + params;
                    http.get(link, params)
                    .done(function () {
                       notify.yell('success', gt('VCard imported')); 
                    })
                    .fail(function () {
                        notify.yell('error', gt('Failed to import vcard'));
                    });
                });
            });
        }
    });
    
    // Return true if of type PGP
    function isPGPAttach(e) {
        if (e.context instanceof Array) {
            for (var i = 0; i < e.context.length; i++) {
                if (e.context[i].pgpFormat !== undefined) return(true);
                if (e.context[i].content_type=='application/pgp-encrypted') return(true);
            }
            return(false);
        }
        if (e.context.pgpFormat !== undefined) return(true);
        if (e.context.content_type=='application/pgp-encrypted') return(true);
        return (false);
    }
    
 // Make excisting mail extensions Guard aware
    addGuardAwareExtension ('io.ox/mail/actions/download-attachment');
    addGuardAwareExtension ('io.ox/mail/actions/open-attachment');
    addGuardAwareExtension ('io.ox/mail/actions/preview-attachment');
    addGuardAwareExtension ('io.ox/mail/actions/slideshow-attachment');
    addGuardAwareExtension ('io.ox/mail/actions/save-attachment');
    addGuardAwareExtension ('io.ox/mail/actions/vcard');
    addGuardAwareExtension ('io.ox/mail/actions/ical');
    addGuardAwareExtension ('io.ox/mail/office/text/edit-as-new');
    addGuardAwareExtension ('io.ox/mail/office/spreadsheet/edit-as-new');
    
    
 // Adds check for Guard files to base and office UI extensions
    function addGuardAwareExtension (e) {
        new links.Action(e, {
            id: 'stop',
            index: 1,
            requires: function (e) {
                if (isPGPAttach(e)) {
                    e.stopPropagation();
                }
                return(false);
            }
        });
    }
    
    
    ext.point('io.ox/mail/actions/print').replace({
        id: 'default',
        requires: function (e) {
            // not on smartphones
            if (_.device('smartphone')) return false;
            // need some and either read access or being embedded
            return e.collection.has('some') && (e.collection.has('read') || !e.collection.has('toplevel'));
        },
        multiple: function (list) {
            require (['io.ox/core/print'], function (print) {
                var nonPGP = [];
                var isPGP = [];
                for (var i = 0; i < list.length; i ++) {
                    if (list[i].PGPDecoded) {
                        isPGP.push(list[i]);
                    } else {
                        nonPGP.push(list[i]);
                    }
                }
                if (isPGP.length > 0) {
                    print.request('oxguard/pgp/pgpprint', isPGP);
                }
                if (nonPGP.length > 0) {
                    print.request('io.ox/mail/print', nonPGP);
                }  
            });
        }
    });
    
    
    // Attachment links for encrypted emails
    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGPGPopen',
        index: 200,
        label: gt('Open in browser'),
        ref: 'io.ox/mail/actions/open-OGPGPattachment',
        mobile: 'lo'
    }));
    
    // Attachment links for encrypted emails
    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGPGPdownload',
        index: 200,
        label: gt('Download'),
        ref: 'io.ox/mail/actions/download-OGPGPattachment',
        mobile: 'lo'
    }));
    
    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGPGPSaveDecoded',
        index: 300,
        label: gt('Save Decoded to Drive'),
        ref: 'io.ox/mail/actions/save-OGPGPattachment',
        mobile: 'lo'
    }));
    
    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGPGPSaveEncryped',
        index: 300,
        label: gt('Save Encrypted to Drive'),
        ref: 'io.ox/mail/actions/save-OGPGPEncrypted',
        mobile: 'lo'
    }));
    
    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGPGPdownloadInline',
        index: 200,
        label: gt('Download'),
        ref: 'io.ox/mail/actions/download-OGPGPinline',
        mobile: 'lo'
    }));
    
    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGPGPOpenInline',
        index: 200,
        label: gt('Open in browser'),
        ref: 'io.ox/mail/actions/open-OGPGPinline',
        mobile: 'lo'
    }));
    
    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'PGPPublicKeyAttach',
        index: 202,
        label: gt('Import as PGP Public Key'),
        ref: 'io.ox/mail/actions/PGPPublicKey',
        mobile: 'lo'
    }));
    
    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGVCard',
        index: 204,
        label: gt('Add to address book'),
        ref: 'io.ox/mail/actions/save-VCard',
        mobile: 'lo'
    }));
    
    function pgpAttach(baton) {
        baton.data.PGP = true;
    }
    
    function checkPGP (baton) {
        if (baton.data.PGPDecoded === true) {
            require (['oxguard/pgp/reader'], function (reader) {
                reader.addIcons(baton);
            });
            if (window.oxguarddata.settings.oxguard === false) { // If not guard user, display upsell if any
                var location = baton.view.$el;
                if (location.find('.guardUpsell').length < 1) { // Make sure not already drawn
                    require (['oxguard/mail/upsell'], function (upseller) {
                        upseller.upsell(location);
                    });
                }
            }
            return; // If already decoded
        }
        if (baton.view.model === null) {
            return;
        }
        var headers = baton.view.model.get('headers');
        if (headers === undefined) {// not yet loaded
            return;
        }
        // Init
        if (baton.data.headers === undefined) { // If email wasn't fully loaded into baton, do so now.
            baton.data = baton.view.model.toJSON();
        }
        var mail = baton.data;
        if (mail.results !== undefined) return;
        var attachments = baton.data.attachments;
        if (attachments === undefined) return;
        if (headers['X-OXGUARD-GUEST'] !== undefined) {
            baton.view.model.set('pgp_found', true);
            pgpAttach(baton);
            pgpFound.call(this, baton);
        }
        for (var i = 0; i < attachments.length; i++) {
         //   var top = (attachments[i].size < 30) ? attachments[i].size : 30;
            if (attachments[i].content_type.toLowerCase().indexOf('pgp-encrypted') > -1) {
                baton.view.model.set('pgp_found', true);
                pgpAttach(baton);
                pgpFound.call(this, baton);
            }
            if (attachments[i].display = 'inline') {
                if (attachments[i].content !== null) {
                    if (attachments[i].content.indexOf('-----BEGIN PGP MESSAGE-----') > -1) {
                        baton.view.model.set('pgp_found', true);
                        inlineFound.call(this, baton, i);
                    } 
                    if (attachments[i].content.indexOf('-----BEGIN PGP SIGNED') > -1) {
                        verify(i, baton, true);
                    }
                }

            }
            if (attachments[i].content_type.toLowerCase().indexOf('pgp-signature') > -1) {
                verify(i, baton);
                attachments[i].disp = 'none';  // Don't display the signature attachment
            }
            
        }
        
    }
    
    function verify (index, baton, isinline) {
        if (baton.signatureDone) return;
        var params = '&folder=' + baton.data.folder_id +
        '&userid=' + ox.user_id + '&cid=' + ox.context_id +
        '&session=' + ox.session + '&emailid=' + baton.data.id + '&attach=' + index;
        if (isinline !== undefined) params += '&inline=true';
        http.get(ox.apiRoot + '/oxguard/pgpmail?action=verify', params)
        .done(function (data) {
            baton.signatureDone = true;
            var results = JSON.parse(data);
            var result = JSON.parse(results.result);
            var signedicon = '';
            if (result.verified === true) {
                signedicon = $('<i class="oxguard_icon_fa fa-pencil-square-o fa guard_signed" aria-hidden="true" title="'+ gt('This Email was signed and verified') + '"/>');
                if (isinline) {
                    var newbody = $('<div class="content noI18n">').append(results.content);
                    $('.content').replaceWith(newbody);
                }
            } else {
                if (result.error !== null && result.missingPublicKey) {
                    signedicon = $('<i class="oxguard_icon_fa fa-pencil-square-o fa guard_signed" style="color:lightgrey" aria-hidden="true" title="'+ gt('This Email was signed but unable to verify') + '"/>');
                } else {
                    if (!result.verified && result.signature) {
                        signedicon = $('<i class="oxguard_icon_fa_alert fa-pencil-square fa guard_signed" aria-hidden="true" title="'+ gt('This Email was signed and failed verification') + '"/>');
                    }
                }
                console.log(result.error);
            }
            var detail = baton.view.$el.find('.detail-view-header');
            if (detail.find('.guard_signed').length < 1) {  // add icon if not already added
                var flagpicker = detail.find('.flag-picker');
                flagpicker.after(signedicon);
            }
            if (baton.data.attachments.length === 2) {
                detail.find('.fa-paperclip').hide();
                baton.data.attachment = false;  // Hide paperclip if just signature
            }
            
        });
    }
    
    function inlineFound (baton, index) {

        var goFunction = function (id) {
            $('#error' + id).show();
            var password = ($('#oxgrpass' + id).val() === undefined) ? '' : $('#oxgrpass' + id).val();
            require (['oxguard/pgp/reader'], function (reader) {
                reader.getInline(baton, password, index);
            });
        };
        baton.data.PGP = true;
        if (window.oxguarddata.passcode === null) {
            require (['oxguard/mail/oxguard_mail'], function (oxmail) {
                var hidden=false;
                if (baton.view.$el.find('.content').length === 0) {
                    hidden = true;  // If hidden, we need to expand to populate data, then hide again
                    baton.view.expand();
                }
                baton.view.$el.find('.content').replaceWith(oxmail.passwordPrompt(baton, false, this, goFunction));
                baton.view.$el.find('.attachments').hide();
                baton.view.$el.find('#oxgrpass').focus();
                baton.view.$el.show();
                if (hidden) {
                    baton.view.toggle();
                }
            });
        } else {
            var go = function (baton, password, index, auth) {
                require (['oxguard/pgp/reader'], function (reader) {
                    reader.getInline(baton, password, index, auth);
                });
            };
            checkauth (go, baton, index);
        }
    }
    
    function pgpFound (baton) {
        
        var goFunction = function (id) {
            $('#error' + id).show();
            var password = ($('#oxgrpass' + id).val() === undefined) ? '' : $('#oxgrpass' + id).val();
            require (['oxguard/pgp/reader'], function (reader) {
                reader.getPGP(baton, password);
            });
            
        };
        
        if (window.oxguarddata.passcode === null) {
            require (['oxguard/mail/oxguard_mail'], function (oxmail) {
                var hidden = false;
                if (baton.view.$el.find('.content').length === 0) {
                    hidden = true;  // If hidden, we need to expand to populate data, then hide again
                    baton.view.expand();
                }
                baton.view.$el.find('.content').replaceWith(oxmail.passwordPrompt(baton, false, this, goFunction));
                baton.view.$el.find('.attachments').remove();
                baton.view.$el.find('#oxgrpass').focus();
                baton.view.$el.show();
                if (hidden) {
                    baton.view.toggle();
                }
            });
        } else {
            var go = function (baton, password, index, auth) {
                    require (['oxguard/pgp/reader'], function (reader) {
                        reader.getPGP(baton, password, index, auth);
                    });
            };
            checkauth (go, baton, undefined);
            
        }
    }
    
    function checkauth (go, baton, index) {
        if (window.oxguarddata.passcode.indexOf('Password Needed') > -1) {// If no password for user has been defined, open dialog
            createOxGuardPasswordPrompt(baton, go, '', undefined, index);
            return;
        }
        if (window.oxguarddata.passcode.indexOf('No Key') > -1) {// If received a first encrypted email while already logged in, will still have 'no key' in passcode
            createOxGuardPasswordPrompt(baton, go, '', undefined, index);
            return;
        }
        go (baton, '', index);
    }
    
    function validateEmail(email) {
        var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(email);
    }
    
    function createOxGuardPasswordPrompt(baton, go, errors, oldpass, index)
    {
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.ModalDialog({ width: 450, center: true, enter : 'okpass'});
            dialog.header($('<h4>').text(gt('First Guard Security Password Use')));
            var explain = $('<div><p>' + gt('Please change the initial temporary Guard security password that was sent to you in a seperate email.') + '</p></div>');
            
            var passdiv = $('<div>').addClass('row-fluid');
            var newogpassword = $('<input name="newogpassword" type="password"/>');
            var td1 = $('<td>').append(newogpassword);
            var newogpassword2 = $('<input name="newogpassword2" type="password"/>');
            var td2 = $('<td>').append(newogpassword2);
            var hint = $('<td>');
            var table = $('<table class="og_password_prompt"/>')
            .append('<tr><td class="pw"><em>' + gt('Initial Password') + ':</em></td><td><input name="oldogpassword" type="password"/></td></tr>')
            .append($('<tr><td class="pw"><em>' + gt('New Password') + ':</em></td></tr>').append(td1).append(hint))
            //#. Confirm new password
            .append($('<tr><td class="pw"><em>' + gt('Confirm New') + ':</em></td></tr>').append(td2).append('<td></td>'));
            passdiv.append(table);
            dialog.getBody().append(explain).append(passdiv);
            require (['oxguard/core/passwords'], function (pass) {
                pass.passwordCheck(newogpassword, hint);
                pass.passwordCompare(newogpassword2, newogpassword);
            });
            var rule = $('<hr style="padding:10px;"/>');
            var recovery = $('<p>' + gt('Please enter a secondary email address in case you need to reset your password' + '</p>'));

            var table2 = $('<table class="og_password_prompt"/>');
            var row = $('<tr><td class="pw"><em>' + gt ('Email:') + '</em></td><td><input name="recoveryemail"/></td></tr>');
            table2.append(row);
            dialog.getBody().append(rule).append(recovery).append(table2);

            if (errors !== undefined) {
                dialog.getBody().append('<div><span style="color: red;">' + errors + '</span></div>');
            }
            dialog
            .addPrimaryButton('okpass', gt('OK'), 'okpass')
            .addButton('cancel', gt('Cancel'), 'cancel')
            .on('okpass', function () {
                var oldpass = $('input[name="oldogpassword"]').val();
                var pass1 = $('input[name="newogpassword"]').val();
                var pass2 = $('input[name="newogpassword2"]').val();
                var emailaddr = $('input[name="recoveryemail"]').val();
                if (pass1 !== pass2) {
                    $('input[name="newogpassword2"]').css('background-color', 'salmon');
                    createOxGuardPasswordPrompt(baton, go, gt('Passwords not equal'), oldpass);
                    return;
                }
                var userdata = {
                        newpass : pass1,
                        oldpass : oldpass,
                        email: emailaddr,
                        user_id : ox.user_id,
                        sessionID : ox.session,
                        cid : ox.context_id
                    };
                if ((emailaddr.length > 1) && (!validateEmail(emailaddr))) {
                    createOxGuardPasswordPrompt(baton, go, gt('Enter new secondary Email address'), oldpass);
                    return;
                }
                if (validateEmail(emailaddr)) userdata.email = emailaddr;
                require (['io.ox/core/notifications'], function (notifications) {
                    http.post(ox.apiRoot + '/oxguard/login?action=changepass', '&session=' + ox.session, userdata)
                    .done(function (data) {
                        if (typeof data === 'string') data = $.parseJSON(data);
                        if (data.auth.length > 20) {
                            $('#grdsettingerror').text(gt('Success'));
                            $('input[name="newogpassword"]').val('');
                            $('input[name="newogpassword2"]').val('');
                            window.oxguarddata.passcode = null;
                            go (baton, pass1, index);
                            notifications.yell('success', gt('Password changed successfully'));
                        } else {
                            if (data.auth === 'Bad new password') {
                                notifications.yell('error', gt('New password must be at least %s characters long', data.minlength));
                                return;
                            }
                            if (data.auth === 'Bad password') {
                                //#. Bad, incorrect password
                                notifications.yell('error', gt('Bad password'));
                                return;
                            }
                            if (data.auth === 'Key not found') {
                                notifications.yell('error', gt('Encryption key not found'));
                                return;
                            }
                            notifications.yell('error', gt('Failed to change password'));
                        }
                    
                    })
                    .fail(function () {
                        notifications.yell('error', gt('Failed to change password'));
                    });
                });
            })
            .show(function () {
                if (oldpass !== undefined) {
                    $('input[name="oldogpassword"]').val(oldpass);
                    $('input[name="newogpassword"]').focus();
                } else
                    $('input[name="oldogpassword"]').focus();
                window.setTimeout(function () {
                    var j = 0;
                    $('.pw').each(function(i,v) { 
                        var w = $(v).width();
                        if (w > j) j = w;
                        });
                    $('.pw').each(function(i,v) {
                        $(v).width(j);
                    });
                    var email = $('input[name="recoveryemail"]'); // Watch email entry for valid
                    email.on('keyup', function () {
                        if (validateEmail(email.val())) {
                            email.css('background-color', 'white');
                        } else {
                            email.css('background-color', 'rgb(253, 187, 179)');
                        }
                    });
                },0);
            });
        });
    }
    

    

});
