/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 * Modified by Greg Hill
 */
define('oxguard/pgp/pgpprint', [
'io.ox/core/print',
'io.ox/mail/api',
'io.ox/mail/util',
'io.ox/mail/detail/content',
'gettext!oxguard/pgp/pgpprint'],
                           function (print, api, util, content, gt) {
    'use strict';
     
    var regImageSrc = /(<img[^>]+src=")\/ajax/g,
    // TODO: add setting (html OR text)
    type = 'html';

function getContent(data) {
    if (!_.isArray(data.attachments)) return '';
    if (type === 'text') {
        var source = String(data.attachments[0].content || '');
        // replace images on source level
        source = source.replace(regImageSrc, '$1' + ox.apiRoot);
        return $.trim(source.replace(/\n/g, '').replace(/<br[ ]?\/?>/g, '\n'));
    } else {
        return (data.attachments[0].content);
       // return content.get(data, { autoCollapseBlockquotes: false }).content.html();
    }
}

function getList(data, field) {
    return _(data[field || 'from']).map(function (obj) {
        return _.escape(util.getDisplayName(obj, true)).replace(/\s/g, '\u00A0');
    }).join('\u00A0\u2022 ');
}

function getAttachments(data) {
    return _(util.getAttachments(data) || []).map(function (attachment, i) {
        return {
            title: attachment.filename || ('Attachment #' + i),
            size: attachment.size ? _.filesize(attachment.size || 0) : 0
        };
    });
}

function title (selection) {
    var subject = selection.length === 1 ? selection[0].subject : '';
    return (subject);
}

function process(data) {
    var info = {
        from: getList(data, 'from'),
        to: getList(data, 'to'),
        cc: getList(data, 'cc'),
        subject: data.subject,
        date: util.getFullDate(data.received_date || data.sent_date),
        sort_date: -(data.received_date || data.sent_date),
        content: getContent(data),
        attachments: getAttachments(data)
    };
    return(info);
}

return {

    open: function (selection, win) {

        print.smart({

            get: function (obj) {
                // is an embedded email?
                if (util.isEmbedded(selection[0])) return $.Deferred().resolve(selection[0]);
                // fetch normal message
                var index = 0;
                for (var i = 0; i < selection.length; i++) {
                    if (selection[i].id === obj.id) {
                        index = i;
                        break;
                    }
                }
                return {
                    then: function(callback) {
                        return(callback(selection[index]));
                    }
                };
            },
            title: title (selection),
            i18n: {
                to: gt('To'),
                copy: gt.pgettext('CC', 'Copy')
            },

            process: process,
            selection: selection,
            selector: '.mail' + '-' + type,
            sortBy: 'sort_date',
            window: win
        });
    }
};
    
});