/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/oxguard_core', [
    'settings!io.ox/mail',
    'oxguard/core/og_http',
    'gettext!oxguard/oxguard_core'
], function (settings, og_http, gt) {
    'use strict';
    
    // Add lock to the message detail view and menu options
    var badCount = 0;
    
    // Prompt for creating master keys for this user if not yet created.
    function createKeys(errors, view, add) {
        var def = $.Deferred();
        require (['io.ox/core/notifications', 'io.ox/core/tk/dialogs'], function (notify, dialogs) {

            var dialog = new dialogs.CreateDialog({ width: 450, center: true, enter: 'ok' });
            dialog.header($('<h4>').text(gt('Create Guard Security Keys')));
            var explain = $('<div><p>' + (add === undefined ? (gt('This appears to be the first time you have used Encryption') + '</p><p>') : '') + gt('Please enter a password to protect your new encrypted items') + '</p>');
            
            var passdiv = $('<div>').addClass('row-fluid');
            var newpass1 = $('<input name="newogpassword" type="password"/>');
            var td1 = $('<td>').append(newpass1);
            var newpass2 = $('<input name="newogpassword2" type="password"/>');
            var td2 = $('<td>').append(newpass2);
            var hint = $('<td>');
            var table = $('<table class="og_password_prompt"/>')
            .append($('<tr><td class="pw"><em>' + gt('Password') + ':</em></td></tr>').append(td1).append(hint))
            .append($('<tr><td class="pw"><em>' + gt('Confirm') + ':</em></td></tr>').append(td2).append('<td></td>'));
            passdiv.append(table);
            require (['oxguard/core/passwords'], function (pass) {
                pass.passwordCheck(newpass1, hint);
                pass.passwordCompare(newpass2, newpass1);
            });
            dialog.getBody().append(explain).append(passdiv);
            
            if (add === undefined) {  // If we are not adding an extra key, then prompt for recovery email address
                var rule = $('<hr style="padding:10px;"/>');
                var recovery = $('<p>' + gt('Please enter a secondary email address in case you need to reset your password' + '</p>'));
                var table2 = $('<table class="og_password_prompt"/>');
                var row = $('<tr><td class="pw"><em>' + gt ('Email:') + '</em></td><td><input name="recoveryemail"/></td></tr>');
                table2.append(row);
                dialog.getBody().append(rule).append(recovery).append(table2);
            }
            
            

            if (errors !== undefined) {
                dialog.getBody().append('<div><span style="color: red;">' + errors + '</span></div>');
            }
            dialog
            .addPrimaryButton('ok', gt('OK'), 'ok')
            .addButton('cancel', gt('Cancel'), 'cancel')
            .on('cancel', function () {
                def.reject('cancel');
            })
            .on('ok', function () {
                var pass1 = $('input[name="newogpassword"]').val();
                var pass2 = $('input[name="newogpassword2"]').val();
                if (pass1 !== pass2) {
                    createKeys(gt('Passwords not equal'), view, add);
                    return;
                }
                var minlen = window.oxguarddata.settings.min_password_length;
                if (minlen !== undefined) {
                    if (pass1.length < minlen) {
                        createKeys(gt('Passwords must be at least %s characters in length', minlen), view, add);
                        return;
                    }
                }
                var emailaddr = $('input[name="recoveryemail"]').val();
                if (emailaddr === undefined) {
                    emailaddr = '';
                }
                if ((emailaddr.length > 1) && (!validateEmail(emailaddr))) {
                    createKeys(gt('Enter new secondary Email address'), view, add);
                    return;
                }
                var userdata = {
                        user_id : ox.user_id,
                        password : pass1,
                        sessionID : ox.session,
                        language : ox.language,
                        cid : ox.context_id,
                        email : emailaddr
                    };
                if (window.oxguarddata.username !== undefined) userdata.name = window.oxguarddata.username;
                var waitdiv = $('<div class="og_wait" id="keygen"></div');
                waitdiv.append('<i class="fa-key fa icon-key fa-spin icon-spin"/><span>' + gt('Generating key, Please wait') + '</span>');
                $('.window-container-center').append(waitdiv);
                waitdiv.show();
                og_http.post(ox.apiRoot + '/oxguard/login?action=create', '&session=' + ox.session + (add !== undefined ? '&add=true' : ''), userdata)
                .done(function (data) {
                    $('.og_wait').hide();
                    if (data.indexOf('ok') > 0) {
                        window.oxguarddata.passcode = null;
                        def.resolve('OK');
                    } else {
                        $('.og_wait').hide();
                        notify.yell('error', gt('Problems creating keys, please try again later'));
                        def.reject('error');
                    }
                    
                })
                .fail(function (data) {
                    $('.og_wait').hide();
                    if (data.responseText.trim() === 'Existing') {
                        notify.yell('error', gt('Problems creating keys.  Keys already exist for this email address in another account'));
                    } else
                    notify.yell('error', gt('Problems creating keys, please try again later'));
                    def.reject('error');
                });
                
            })

            .show(function () {  // Normalize the two tables to have same column size
                $('input[name="newogpassword"]').focus();
                window.setTimeout(function () {
                    var j = 0;
                    $('.pw').each(function(i,v) { 
                        var w = $(v).width();
                        if (w > j) j = w;
                        });
                    $('.pw').each(function(i,v) {
                        $(v).width(j);
                    });
                    var email = $('input[name="recoveryemail"]'); // Watch email entry for valid
                    email.on('keyup', function () {
                        if (validateEmail(email.val())) {
                            email.css('background-color', 'white');
                        } else {
                            email.css('background-color', 'rgb(253, 187, 179)');
                        }
                    });
                },0);
                if (window.oxguarddata.username === undefined) {
                    require(['io.ox/core/api/user']).done(function (api) { 
                        api.getCurrentUser().done (function (userdata) {
                            window.oxguarddata.username = userdata.attributes.display_name;
                        });
                    });
                }
            });
        });
        return (def);
    }
    
    /// First time OG users or has had password reset
    function createOxGuardPasswordPrompt(baton, errors, oldpass, goFunction)
    {
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.ModalDialog({ width: 450, center: true, enter: 'okpass' });
            dialog.header($('<h4>').text(gt('First Guard Security Password Use')));
            var explain = $('<div><p>' + gt('Please change the temporary Guard security password that was sent to you in a seperate email.') + '</p></div>');
            
            var passdiv = $('<div>').addClass('row-fluid');
            var newogpassword = $('<input name="newogpassword" type="password"/>');
            var td1 = $('<td>').append(newogpassword);
            var newogpassword2 = $('<input name="newogpassword2" type="password"/>');
            var td2 = $('<td>').append(newogpassword2);
            var hint = $('<td>');
            var table = $('<table class="og_password_prompt"/>')
            .append('<tr><td class="pw"><em>' + gt('Initial Password') + ':</em></td><td><input name="oldogpassword" type="password"/></td></tr>')
            .append($('<tr><td class="pw"><em>' + gt('New Password') + ':</em></td></tr>').append(td1).append(hint))
            //#. Confirm new password
            .append($('<tr><td class="pw"><em>' + gt('Confirm New') + ':</em></td></tr>').append(td2).append('<td></td>'));
            passdiv.append(table);
            dialog.getBody().append(explain).append(passdiv);
            require (['oxguard/core/passwords'], function (pass) {
                pass.passwordCheck(newogpassword, hint);
                pass.passwordCompare(newogpassword2, newogpassword);
            });
            var rule = $('<hr style="padding:10px;"/>');
            var recovery = $('<p>' + gt('Please enter a secondary email address in case you need to reset your password' + '</p>'));

            var table2 = $('<table class="og_password_prompt"/>');
            var row = $('<tr><td class="pw"><em>' + gt ('Email:') + '</em></td><td><input name="recoveryemail"/></td></tr>');
            table2.append(row);
            dialog.getBody().append(rule).append(recovery).append(table2);

            if (errors !== undefined) {
                dialog.getBody().append('<div><span style="color: red;">' + errors + '</span></div>');
            }
            dialog
            .addPrimaryButton('okpass', gt('OK'), 'okpass')
            .addButton('cancel', gt('Cancel'), 'cancel')
            .on('okpass', function () {
                var oldpass = $('input[name="oldogpassword"]').val();
                var pass1 = $('input[name="newogpassword"]').val();
                var pass2 = $('input[name="newogpassword2"]').val();
                var emailaddr = $('input[name="recoveryemail"]').val();
                if (pass1 !== pass2) {
                    $('input[name="newogpassword2"]').css('background-color', 'salmon');
                    createOxGuardPasswordPrompt(baton, gt('Passwords not equal'), oldpass, goFunction);
                    return;
                }
                var userdata = {
                        newpass : pass1,
                        oldpass : oldpass,
                        email: emailaddr,
                        user_id : ox.user_id,
                        sessionID : ox.session,
                        cid : ox.context_id
                    };
                if ((emailaddr.length > 1) && (!validateEmail(emailaddr))) {
                    createOxGuardPasswordPrompt(baton, gt('Enter new secondary Email address'), oldpass, goFunction);
                    return;
                }
                if (validateEmail(emailaddr)) userdata.email = emailaddr;
                require (['io.ox/core/notifications', 'oxguard/mail/oxguard_mail', 'oxguard/mail/getmail', 'oxguard/core/og_http'], function (notifications, oxmail, reader, og_http) {
                    og_http.post(ox.apiRoot + '/oxguard/login?action=changepass', '&session=' + ox.session, userdata)
                    .done(function (data) {
                        if (typeof data === 'string') data = $.parseJSON(data);
                        if (data.auth.length > 20) {
                            $('#grdsettingerror').text(gt('Success'));
                            $('input[name="newogpassword"]').val('');
                            $('input[name="newogpassword2"]').val('');
                            window.oxguarddata.passcode = null;
                            goFunction (baton, data);
                            notifications.yell('success', gt('Password changed successfully'));
                        } else {
                            if (data.auth === 'Bad new password') {
                                notifications.yell('error', gt('New password must be at least %s characters long', data.minlength));
                                return;
                            }
                            if (data.auth === 'Bad password') {
                                //#. Bad, incorrect password
                                notifications.yell('error', gt('Bad password'));
                                return;
                            }
                            if (data.auth === 'Key not found') {
                                notifications.yell('error', gt('Encryption key not found'));
                                return;
                            }
                            notifications.yell('error', gt('Failed to change password'));
                        }
                    
                    })
                    .fail(function () {
                        notifications.yell('error', gt('Failed to change password'));
                    });
                });
            })
            .show(function () {
                if (oldpass !== undefined) {
                    $('input[name="oldogpassword"]').val(oldpass);
                    $('input[name="newogpassword"]').focus();
                } else
                    $('input[name="oldogpassword"]').focus();
                window.setTimeout(function () {
                    var j = 0;
                    $('.pw').each(function(i,v) { 
                        var w = $(v).width();
                        if (w > j) j = w;
                        });
                    $('.pw').each(function(i,v) {
                        $(v).width(j);
                    });
                    var email = $('input[name="recoveryemail"]'); // Watch email entry for valid
                    email.on('keyup', function () {
                        if (validateEmail(email.val())) {
                            email.css('background-color', 'white');
                        } else {
                            email.css('background-color', 'rgb(253, 187, 179)');
                        }
                    });
                },0);
            });
        });
    }
    
    function validateEmail(email) { 
        var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(email);
    } 
    
    function getId(baton) {
        var id = decodeURIComponent(baton.data.id);
        try {
            id = id.substring(id.lastIndexOf('/') + 1);
        } catch (e)
            {
            }
        return (id);
    }
    
    function handleFailEmail (data, baton, deferred, goFunction) {
        baton.view.loaded = true;
        window.oxguarddata.priv = undefined;
        var eid = getId(baton);
        var retry = false;
        if (data.status == 503) {
            baton.view.$el.find('#error' + eid).replaceWith('<div class="error" id="error' + eid + '"><br>' + gt('Unable to connect to the encryption server.') + '</hr></div>');
        } else {
            var errorMessage = 'Fail';
            var resp = data.responseText.split(':');
            switch (resp[0].trim()) {
            case 'noitem':
                errorMessage = gt('Unable to find the item on the server');
                break;
            case 'nocc':
                errorMessage = gt('Unable to get the key for that item');
                break;
            case 'nokey':
                errorMessage = gt('Unable to retrieve your user keys to decode');
                break;
            case 'Bad extra':
                errorMessage = gt('Bad extra password');
                retry = true;
                break;
            case 'No Private Key associated with the Public Key':
                errorMessage = gt('No private key to decode this message');
                retry = false;
                break;
            case 'Bad Password':
                errorMessage = gt('Unable to decrypt Email, incorrect password.');
                badCount++;
                if (badCount > 2) {
                    var url = document.URL;
                    errorMessage += ('<br/>' + gt('To reset or recover your password, click %s', '<a id="guardsettings" href="' + url + '">' + gt('Settings') + '</a>'));
                }
                retry = true;
                break;
            case 'No secret key':
                errorMessage = gt('No Private Key available for this encrypted item.') + (resp[1] !== undefined ? ('<br>' + gt('Key Ids:') + resp[1]) : '');
                retry = false;
                break;
            case 'Exceeded':
                errorMessage = gt('Your account is locked out for %s minutes', resp[1]);
                retry = false;
                break;
            default:
                console.log(resp);
                errorMessage = gt('Unable to decrypt Email, incorrect password.');
                retry = true;
                break;
            }
            if (data.status == 500) errorMessage = gt('Server Error: ') + data.responseText.trim();
            baton.view.$el.find('#error' + eid).replaceWith('<div class="error" id="error' + eid + '"><br>' + errorMessage + '</hr></div>');
            if (badCount > 2) {
                baton.view.$el.find('#guardsettings').click(function (e) {
                    ox.launch('io.ox/settings/main', {id:'oxguard'}).done(function () {
                         this.setSettingsPane({id: 'oxguard'}); 
                    });
                    e.preventDefault();
                });
            }
        }
        if (retry) {
            require (['oxguard/mail/oxguard_mail'], function (og_mail) {
                baton.view.$el.find('#content' + eid).replaceWith(og_mail.passwordPrompt(baton, true, undefined, goFunction));
            });
            baton.view.$el.find('.body').show();
        } else {
            $('.content').hide();
        }
        try {// blank out auth if present
            if (window.oxguarddata.passcode.length > 20) window.oxguarddata.passcode = null;
        } catch (ex) {
            
        }
        deferred.reject('error');
    }
    
    function getpassword (message) {
        var def = $.Deferred();
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.CreateDialog({ width: 490, center: true,  enter: 'ok' });
            dialog.header($('<h4>').text(gt('Password Needed')));
            var help =  $('<p>' + gt('Please enter your Guard password') + '</p>');
            if (message !== undefined) {
                help = $('<p>' + message + '</p>');
            }
            var pass = $('<input name="password" id="password" type="password"/>');
            dialog.getBody().append(help).append(pass);
            dialog.addPrimaryButton('ok', gt('OK'), 'ok')
            .on('ok', function () {
            })
            .addButton('cancel', gt('Cancel'), 'cancel')
            .on('cancel', function () {
                def.reject('cancel');
            })
            .on('ok', function () {
                def.resolve($('#password').val());
            })
            .show(function () {
                pass.focus();
            });
        });
        return (def);
    }

    return {
        
            // Send authorization to the oxguard server
        auth: function authorize(userid, password, extra, keyid)
            {
            var def = $.Deferred();
            var defaultSendAddress = $.trim(settings.get('defaultSendAddress', ''));
            var userdata = {
                    user_id : userid,
                    ox_password : password,
                    encr_password : '',
                    sessionID : ox.session,
                    lang: ox.language,
                    cid : ox.context_id,
                    email : defaultSendAddress,
                    extrapass : extra ? extra : ''
                };
            var url = ox.apiRoot + '/oxguard/login?action=login';
            var params = '&session=' + ox.session + '&time=' + new Date().getTime();
            if (keyid !== undefined) params += '&keyid=' + keyid;
            og_http.post (url, params, userdata)
            .done (function (data) {
                def.resolve(data);
            })
            .fail(function () {
                def.reject();
            });
            return def;
            
        },
        
        createKeys : createKeys,
        validateEmail : validateEmail,
        handleFailEmail : handleFailEmail,
        getPassword : getpassword,
        createOxGuardPasswordPrompt : createOxGuardPasswordPrompt
    };
});
    

    
