define('oxguard/mail/register_oldcompose', ['io.ox/core/extensions', 'oxguard/mail/prep_reply', 'settings!io.ox/mail',
                                            'gettext!oxguard/mail/register_mail',
                           'css!oxguard/style.css'],
                           function (ext, prep, settings, gt) {
    'use strict';
    
    ////////  Reply or Reply all actions from top command bar
    
        
    ext.point('io.ox/mail/actions/forward').replace({
        id: 'forward',
        requires: function (e) {
            try {
                var data = e.baton.isThread ? e.baton.first() : e.baton.data;
                if (data === undefined) return e.collection.has('toplevel', 'some');
                if (data.PGPDecoded && !window.oxguarddata.settings.oxguard) return(false);  // if decoded, and doesn't have guard, then no forwarding
                if (data.headers !== undefined) { // Email selected
                    if (data.headers['X-OxGuard'] !== undefined) { // Will not be defined if sent from other client
                        if (data.headers['X-OxGuard'].toLowerCase() === 'true')  // Proprietary guard not forwardable
                            return false;
                    }
                }
            } catch (e) {
                console.log('catch in forward require');
                console.log(e);
            }
            return e.collection.has('toplevel', 'some');
        },
        action: function (baton) {
            var data = baton.isThread ? baton.first() : baton.data;
            getCurrent(baton);
            if (window.oxguarddata.current !== undefined) {
                // If we are forwarding a PGP email, format it and set flags
                if (window.oxguarddata.current.og || window.oxguarddata.current.PGP) {
                    window.oxguarddata.action='secureReply';
                    window.oxguarddata.replyInline = isInline(data);
                    require(['io.ox/mail/write/main', 'oxguard/mail/oxguard_mail_write_core', 'oxguard/mail/register_mail'], function (m, core, reg) {
                        m.getApp().launch().done(function () {
                            data = JSON.parse(JSON.stringify(window.oxguarddata.current));
                            data = prepContent (reg.prepareDraft(data).data, 'forward');  //  Add information to forward body
                            data.to = []; // Clear recipients
                            data.cc = [];
                            data.bcc = [];
                            data.subject =  gt ('FW: %1$s', data.subject);
                            //this.compose({ folder_id: baton.app.folder.get() });
                            this.compose({});
                            var view = this.getView().form;
                            this.setMail({ data: data, format : getFormatType(data) })
                            .done(function () {
                                core.saveToHeader(view);
                            });
                        });
                    });
                }
            } else {
                if (ox.registry === undefined) {
                    require(['io.ox/mail/write/main'], function (m) {
                        if (m.reuse('forward', data)) return;
                        m.getApp().launch().done(function () {
                            this.forward(data);
                        });
                    });
                } else {
                    ox.registry.call('mail-compose', 'forward', data);
                }
            }
            
            
        }
    });
    
    // When hitting reply, see if was a secured email.  If so, set temp vars for updating reply email
    ext.point('io.ox/mail/actions/reply').replace({
        id: 'reply',
        action: function (baton) {
            getCurrent(baton);
            if (window.oxguarddata.current === undefined) {
                ox.registry.call('mail-compose', 'reply', baton.first());
                return;
            }
            try {
                if (window.oxguarddata.current.og || window.oxguarddata.current.PGP) {
                    doReply(false);
                } else {
                    ox.registry.call('mail-compose', 'reply', baton.first());
                }
            } catch (e) {
                console.log(e);
            }

        }
    });
    
    // Check if secured email.  
    ext.point('io.ox/mail/actions/reply-all').replace({
        id: 'reply-all',
        action: function (baton) {
            getCurrent(baton);
            if (window.oxguarddata.current === undefined) {
                ox.registry.call('mail-compose', 'replyall', baton.first());
                return;
            }
            try {
                if (window.oxguarddata.current.og || window.oxguarddata.current.PGP) {
                    doReply(true);
                } else {
                    ox.registry.call('mail-compose', 'replyall', baton.first());
                }
            } catch (e) {
                console.log(e);
            }
        }
    });
    
    // Update guard current with the active email, be it selected or top of thread
    function getCurrent (baton) {
        if (baton.data instanceof Array) {
            // if just decoded, current will be udated, otherwise, load from baton
            if ((window.oxguarddata.current !== null) && (window.oxguarddata.current !== undefined)) return;
            window.oxguarddata.current = baton.data[0].Guard;
            return;
        }
        window.oxguarddata.current = baton.data.Guard;
    }
    // Do the setup and actions of reply
    function doReply (all) {
        var data = JSON.parse(JSON.stringify(window.oxguarddata.current));
        data.attachments = stripAttach(data);
        data = prepContent (data, 'reply');  //  Add information to forward body
        if (all) {
            var recips = addTo();
            data.to = recips.to;
            data.cc = recips.cc;
        } else {
            data.to = [];
            data.cc = [];
        }
        try {
            var replyto = window.oxguarddata.current.headers['Reply-To'];
            if (replyto !== undefined && replyto.indexOf('<') > -1) {
                var email = replyto.substring(replyto.indexOf('<') + 1);
                email = email.replace('>', '');
                var sender = [replyto.substring(0, replyto.indexOf('<')), email];
                data.to.push(sender);
            } else {
                data.to.push(window.oxguarddata.current.from[0]);
            }
        } catch (e) {
            console.log(e);
            data.to.push(window.oxguarddata.current.from[0]);
        }
        window.oxguarddata.action='secureReply';
        window.oxguarddata.replyInline = isInline(data);
        data.headers['In-Reply-To'] = data.headers['Message-ID'];
        data.msgref = data.folder_id + '/' + data.id;
        data.subject = gt ('Re: %1$s', data.subject);
        if (data.headers.References === undefined) {
            data.headers.References = data.headers['Message-ID'];
        } else {
            data.headers.References = data.headers.References + data.headers['Message-ID'];
        }
        ox.registry.call('mail-compose', 'compose', {})
        .done(function(c) {
            c.app.setMail({data : data, format : getFormatType(data) });
        });
    }
    
    // Get format of compose.  If reply is text, then open as text.  Also text if mandates inline
    function getFormatType (data) {
        if ((data.replytype === 'text/plain') || window.oxguarddata.replyInline) {
            return ('text');
        } 
        return ('html');
    }
    
    // Strip all attachments that are not text and inline for replies
    function stripAttach (data) {
        var newattach = [];
        for (var i = 0; i < data.attachments.length; i++) {
            var att = data.attachments[i];
            if (att.content_type.indexOf('text') > -1) {
                if (att.disp === 'inline') newattach.push(att);
            }
        }
        return (newattach);
    }
    
    // Add decoded data with prepared text to body and set content_type
    function prepContent (data, type) {
        if (data.replytype === 'text/plain') {
            data.attachments[0].content = prep.prepareTextReply($.extend({}, data), type);
            data.attachments[0].content_type = 'text/plain'; 
        } else {
            data.attachments[0].content = prep.prepareReply($.extend({}, data) , type);
            data.attachments[0].content_type = 'text/html'; 
        }
        return (data);
    }
    
    function isInline (data) {
        if ((data.attachments === undefined) || (data.attachments.length === 0)) return(false);
        return (data.attachments[0].pgpFormat === 'pgpinline');
    }
    
    // For replyAll, we need to add back all the recipients from decrypted email
    function addTo () {
        var to = window.oxguarddata.current.to;
        var newto = [];
     //   var user = baton.app.getView().form.find('.sender-dropdown').val();// Get current users email
        var user = settings.get('defaultSendAddress', '');
        for (var i = 0; i < to.length; i++) {
            if (user.indexOf(to[i][1]) < 0) { // dont add the user to recip list
                newto.push(to[i]);
            }
        }
        var cc = window.oxguarddata.current.cc;
        var newcc = [];
        for (var i = 0; i < cc.length; i++) {
            if (user.indexOf(cc[i][1]) < 0) { // dont add the user to recip list
                newcc.push(cc[i]);
            }
        }
        return {
            to : newto,
            cc : newcc
        };
    }
    
    var newpoint = ext.point('io.ox/mail/write/toolbar');
    newpoint.extend({
        id: 'locksend',
        index: 100,
        draw: function (baton) {
            // Create Security Link
            try {
                if ($('.btn-primary:visible').length === 0) return;// if page not yet created
                if ($('.btn-primary:visible').prev().is('[name="Page"]')) {//We've already updated this
                    return;
                }
                var view = baton.app.getView().form;
                if (view === undefined) return;//View not yet loaded
                if (view.find('#OxGuardOn').length > 0) return;//Already created
                require (['oxguard/mail/options'], function (options) {
                    options.createOptions(view, baton);
                });
                addBlur('#writer_field_to', view);
                addBlur('#writer_field_cc', view);
                addBlur('#writer_field_bcc', view);
                
            } catch (e) {
                console.log(e.toString());
            }
            
        }
        
    });
    
    function addBlur(id, view) {
        $(id).blur(function () {
            if (view.find('#PGPGuardOn').is(':checked')) {
                window.setTimeout(function () {
                    require (['oxguard/mail/oxguard_mail_write_core'], function (core) {
                        core.checkRecip(view);
                    });
                }, 200);
            }
        }).keypress(function(e) {
            if (e.which === 13) {
                if (view.find('#PGPGuardOn').is(':checked')) {
                    window.setTimeout(function () {
                        require (['oxguard/mail/oxguard_mail_write_core'], function (core) {
                            core.checkRecip(view);
                        });
                    }, 200);
                }
            }
        });
    }
    
 
    
   ///////////////  Write / Send
    
    
    function promptDraft (baton) {
        var view = baton.app.getView().form;
        if (view.find('#OxGuardOn').is(':checked') || view.find('#PGPGuardOn').is(':checked')) {
            require(['io.ox/core/tk/dialogs'], function (dialogs) {
                new dialogs.ModalDialog()
                    .text(gt('Do you really want to discard your message?'))
                    //#. "Discard message" appears in combination with "Cancel" (this action)
                    //#. Translation should be distinguishable for the user
                    .addPrimaryButton('delete', gt.pgettext('dialog', 'Discard message'), 'delete', {tabIndex: '1'})
                    .addAlternativeButton('savedraft', gt('Save as draft'), 'savedraft', {tabIndex: '1'})
                    .addButton('cancel', gt('Cancel'), 'cancel', {tabIndex: '1'})
                    .show()
                    .done(function (action) {
                        if (action === 'delete') {
                            baton.app.dirty(false).quit();
                        } else if (action === 'savedraft') {
                            saveDraft(baton, true);
                        } else {
                            return;
                        }
                    });
            });
        } else {
            baton.app.quit();
        }
    }
    
    // Set the action for send.
    var sendpoint = ext.point('io.ox/mail/write/actions/send');
    sendpoint.replace({
        id: 'default',
      //  index: 'default',
        action: function (baton) {
            var view = baton.app.getView().form;
            if (view.find('#OxGuardOn').is(':checked') || view.find('#PGPGuardOn').is(':checked')) {
                if (window.oxguarddata.passcode === 'No Key') {
                    require (['oxguard/mail/oxguard_mail_write_core'], function (core) {
                        core.createKeys('', view);
                    });
                    return;// Do not send until the master key is created
                }
                require (['oxguard/mail/sender'], function (sender) {
                   sender.sendMail(baton, window.oxguarddata.passcode);
                });
                
            } else {
                var view = baton.app.getView().form;
                if (view.find('#PGPSign').is(':checked')) {  // Plaintext signed
                    var emailheader = view.find('[name="headers"]');
                    var headerstring = emailheader.val();
                    var header = {};
                    if (headerstring !== '') header = JSON.parse(headerstring);
                    if (header['X-OX-Guard-Auth'] === undefined) {// If not already authrized
                        require(['oxguard/oxguard_core', 'oxguard/crypto/encr', 'io.ox/core/notifications'], function (core, encr, notify) {
                            core.getPassword(gt('Please enter your Guard password to sign this email'))  //Get password
                            .done(function (pass) {
                                core.auth(ox.user_id, pass)  // Verify against backend
                                .done(function (data) {
                                    if (data.auth.length > 20) {  // If OK, add header and send
                                        header['X-OX-Guard-Auth'] = encr.cryptPass(pass);
                                        header['X-OX-Guard-Marker'] = true;
                                        baton.app.setHeaders(header);
                                        baton.app.send();
                                    } else {
                                        console.log(data.auth);  // Otherwise report error
                                        if (data.auth=='Bad Password') {
                                            notify.yell('error', gt('Bad Password'));
                                        } else {
                                            notify.yell('error', gt('Error') + ' ' + data.auth);
                                        }
                                    }
                                })
                                .fail(function () {
                                    notify.yell('error', gt('Unable to authorize against backend'));
                                });
                            });
                        });
                    } else {
                        header['X-OX-Guard-Marker'] = true;
                        baton.app.setHeaders(header);
                        baton.app.send();
                    }                
                } else
                    baton.app.send();
            }
            
        }
    });
    
    
    var sendpoint = ext.point('io.ox/mail/write/actions/draft');
    sendpoint.replace({
        id: 'default',
      //  index: 'default',
        action: function (baton) {
            saveDraft(baton);
        }
    });

    function saveDraft (baton, close) {
        if (baton.app.isSaving === true) return;
        baton.app.isSaving = true;
        var view = baton.app.getView().form;
        if (view.find('#PGPGuardOn').is(':checked')) {
            if (window.oxguarddata.passcode === 'No Key') {
                require (['oxguard/mail/oxguard_mail_write_core'], function (core) {
                    core.createKeys('', view);
                });
                baton.app.isSaving = false;
                return;// Do not send until the master key is created
            }
            require (['oxguard/mail/sender'], function (sender) {
                sender.draftMail(baton, window.oxguarddata.passcode)
                .done(function () {
                   if (close) {
                       baton.app.dirty(false).quit();
                   }  
                });
            });
            
        } else {
            baton.app.saveDraft()
                .done(function (data) {
                    baton.app.refId = data.msgref;
                    baton.app.isSaving = false;
                }).fail(function () {
                    baton.app.isSaving = false;
                });
        }
    }

    // Email writing
    
    // Add the oxguard button to write toolbar
    
    
    ext.point('io.ox/mail/write/filelist/filePicker/customizer').extend({
        id: 'oxguard',
        customize: function (file) {
            if (file.filename.indexOf('.grd') > 0) {
              //  var newfilename = file.filename.replace('.grd2', '').replace('.grd', '');
                var icon = '<i class = "fa fa-lock oxguard_lock_p"/>';
                $(this).find('.name').text(file.filename).prepend(icon);
            }
        }
    });

    
 
    
    ext.point('io.ox/mail/write/filelist/file/customizer').extend({
        id: 'oxguardfilelist',
        customize: function (e) {
            var icon = '<i class = "fa fa-lock oxguard_lock_p"/>';
            if (e.file.epass !== undefined) {
                $(this).find('.attachment-preview').hide();
            }
            $(this).find('.row-1').each(function (e, v) {
                var te = $(v);
                if (te.text().indexOf('.grd') > 0) {
                    te.html(icon + te.text());
                    $('#statuslock.icon-unlock:visible').click();// Enable encryption if not set
                }
            });
        }
    });
    
    return {
        promptDraft : promptDraft
    };
    
});
