/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/mail/register_mail', ['io.ox/core/extensions',
                           'gettext!oxguard/mail/register_mail',
                           'io.ox/core/extPatterns/links',
                           'io.ox/core/api/account',
                           'css!oxguard/style.css'],
                           function (ext, gt, links, account) {
    'use strict';
    
    var popupBlockCount = 0;
    var unified_sent = null;
    
    if (window.oxguarddata.oldcompose) {
        require(['oxguard/mail/register_oldcompose']);
    } else 
        require(['oxguard/mail/mail_extensions_compose']);
    
    ///////////////////  Email points
    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGSave',
        index: 202,
        label: gt('Save Encrypted'),
        ref: 'io.ox/mail/actions/save-OGattachment'
    }));
    


    
    /////////  Extension points reader / inbox
    
    function isOGLink(e) {
        try {
            if (e.context instanceof Array) {
                for (var i = 0; i < e.context.length; i++) {
                    if (e.context[i].decoded === true) return(true);
                }
            }
            return (e.context.decoded === true);
        } catch (d) {
            console.log(d);
            return(false);
        }
    }
    
    // Action to open OxGuard attachment
    new links.Action('io.ox/mail/actions/open-OGattachment', {
        id: 'openOG',
        requires: function (e) {
            return(isOGLink(e));
        },
        multiple: function (list) {
            _(list).each(function (data) {
                if (data.decoded !== true) {
                    console.debug(data.filename + ' not an encrypted attachment');
                } else {
                    var params = '&emailid=' + data.mail.id +
                    '&attach=' + data.id +
                    '&session=' + ox.session +
                    '&auth=' + encodeURIComponent(window.oxguarddata.passcode) +
                    '&userid=' + ox.user_id +
                    '&cid=' + ox.context_id +
                    '&epassword=' + encodeURIComponent(data.epass) +
                    '&folder=' + data.mail.folder_id +
                    '&encrextrapass=' + encodeURIComponent(data.extrapass) +
                    '&cc=' + data.cc +
                    '&attname=' + encodeURIComponent(data.filename);
                    var link = ox.apiRoot + '/oxguard/mail/' + encodeURIComponent(data.filename) + '?action=getattach' + params;
                    var popup = window.open(link);
                    if (popup === null || popup === undefined) {
                        // If popup blocked, give one try to see if user notices, otherwise alert message regarding blocking
                        if (popupBlockCount === 1) {
                            require (['io.ox/core/notifications'], function (notifications) {
    						//#. Error message when trying to open a file with popup blocker on browser blocking
        						notifications.yell('error', gt('Your pop-up blocker may have prevented a Guard window that provides application functionality.'));
                            });
    						//  window.location.href = link;
                        }
                        popupBlockCount++;
                    }
                }
            });
        }
    });
    
    // Download encrypted attachment
    new links.Action('io.ox/mail/actions/download-OGattachment', {
        id: 'DownloadOG',
        requires: function(e) {
            return (isOGLink(e));
        },
        multiple: function (list) {
            _(list).each(function (data) {
                if (data.decoded !== true) {
                    console.debug(data.filename + ' not an encrypted attachment');
                } else {
                var params = '&emailid=' + data.mail.id +
                '&attach=' + data.id +
                '&session=' + ox.session +
                '&auth=' + encodeURIComponent(window.oxguarddata.passcode) +
                '&userid=' + ox.user_id +
                '&cid=' + ox.context_id +
                '&epassword=' + encodeURIComponent(data.epass) +
                '&folder=' + data.mail.folder_id +
                '&encrextrapass=' + encodeURIComponent(data.extrapass) +
                '&cc=' + data.cc +
                '&download=true' +
                '&attname=' + encodeURIComponent(data.filename);
                var link = ox.apiRoot + '/oxguard/mail?action=getattach' + params;
                $('#tmp').append(
                        $('<iframe>', { src: link, 'class': 'hidden download-frame', id: 'download' + data.id })
                    );
                }
            });
        }
    });
    
    
    // Replace preview requires.  Only going to be used for nested messages, not decoded attachments
    ext.point('io.ox/mail/actions/preview-attachment').replace({
        id: 'preview',
        requires: function (e) {
            try {
                if (e.context instanceof Array) {
                    for (var i = 0; i < e.context.length; i++) {
                        if (e.context[i].decoded === true) return(false);
                    }
                } else {
                    if (e.context.decoded === true) return(false);
                }
            } catch (d) {
                console.log(d);
            }
            return require(['io.ox/preview/main']).pipe(function (p) {
                var list = _.getArray(e.context);
                // is at least one attachment supported?
                return e.collection.has('some') && _.device('!smartphone') && _(list).reduce(function (memo, obj) {
                    return memo || new p.Preview({
                        filename: obj.filename,
                        mimetype: String(obj.content_type || '').split(';')[0], // fixes 'audio/mp3; name="Metallica - 01 - Enter Sandman.mp3"''
                        attachment: true
                    })
                    .supportsPreview();
                }, false);
            });
        }
    });
    
    // Save encrypted attachment.  Need to add the .oxg suffix
    new links.Action('io.ox/mail/actions/save-OGattachment', {
        id: 'SaveOG',
        requires: function(e) {
            return (isOGLink(e));
        },
        multiple: function (list) {
            for (var n = 0; n < list.length; n++) {
                var filename = list[n].filename;
                list[n].save_as = filename + '.grd';                
            }
            require(['io.ox/mail/actions/attachmentSave'], function (action) {
                action.multiple(list);
            });
        }
    });
    

    
    // Save decrypted attachment.  Need to add the .oxg suffix
    new links.Action('io.ox/mail/actions/save-OGdecoded', {
        id: 'SaveOG',
        requires: function(e) {
            return (isOGLink(e));
        },
        multiple: function (list) {
            require(['oxguard/mail/saveattach'], function (action) {
                action.multiple(list);
            });
        }
    });
    
    // Attachment links for encrypted emails
    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGopen',
        index: 200,
        label: gt('Open in browser'),
        ref: 'io.ox/mail/actions/open-OGattachment',
        mobile: 'lo'
    }));
    
    
    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGdownload',
        index: 201,
        label: gt('Download'),
        ref: 'io.ox/mail/actions/download-OGattachment'
    }));
    
    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGsaveDecoded',
        index: 203,
        label: gt('Save Decrypted'),
        ref: 'io.ox/mail/actions/save-OGdecoded',
        mobile: 'lo'
    }));
    

    

    
    
    
    // For attachments, need to change links to decoding through oxguard if encrypted.
    ext.point('io.ox/mail/detail/header').extend({
        index: 1,
        id: 'ogattachlinks',
        draw: function (baton) {
            setAttachments(baton);
        }
    });
    
    function setAttachments(baton) {
        regAttach(baton);    // Default is to just display the regular links
        if (baton.data.headers === undefined) return;   // Usually not defined unless decrypted email
        if (baton.data.attachments === undefined) return;
        if (baton.data.headers['X-OxGuard'] === undefined) return;
        if ((baton.data.headers['X-OxGuard'].toLowerCase() === 'true') || baton.data.og) {
            if (ox.serverConfig.version.indexOf('7.6.0') !== 0) {
                ext.point('io.ox/mail/detail/attachments').disable('attachment-list');
                ext.point('io.ox/mail/mobile/detail/attachments').disable('attachment-list');
            }
            // We are going to search the attachments, and not display the main email attachment if present
            try {
                if (baton.data.attachment) {
                    ogAttach(baton);
                } else {// If no attachments to show, hide the attachment div
                    baton.view.$el.find('.attachments').remove();
                }
                
            } catch (e) {
                
            }
        } else {
            ext.point('io.ox/mail/detail/attachments').enable('attachment-list');
            ext.point('io.ox/mail/mobile/detail/attachments').enable('attachment-list');
        }
    }
    
    function ogAttach(baton) {
        // Set the right links in the attachment dropdown
   //     ext.point('io.ox/mail/attachment/links').disable('preview');
        baton.data.og = true;
        ext.point('io.ox/mail/attachment/links').disable('download');
        ext.point('io.ox/mail/attachment/links').disable('save');
        ext.point('io.ox/mail/attachment/links').disable('open');
        ext.point('io.ox/mail/attachment/links').disable('vcard');
        ext.point('io.ox/mail/attachment/links').disable('ical');
        ext.point('io.ox/mail/attachment/links').disable('slideshow');
        ext.point('io.ox/mail/attachment/links').enable('OGopen');
        ext.point('io.ox/mail/attachment/links').enable('OGdownload');
        ext.point('io.ox/mail/attachment/links').enable('OGSave');
        ext.point('io.ox/mail/attachment/links').enable('OGsaveDecoded');
        ext.point('io.ox/mail/attachment/links').disable('text_edit');
        ext.point('io.ox/mail/attachment/links').disable('spreadsheet_edit');
        ext.point('io.ox/mail/attachment/links').disable('office_view');
    }
    
    function regAttach(baton) {
        ext.point('io.ox/mail/attachment/links').disable('OGopen');
        ext.point('io.ox/mail/attachment/links').disable('OGdownload');
        ext.point('io.ox/mail/attachment/links').disable('OGSave');
        ext.point('io.ox/mail/attachment/links').disable('OGsaveDecoded');
        if (!baton.data.PGP) {  // If not PGP email, then re-enable links
            ext.point('io.ox/mail/detail/attachments').enable('attachment-list');
            ext.point('io.ox/mail/attachment/links').enable('preview');
            ext.point('io.ox/mail/attachment/links').enable('download');
            ext.point('io.ox/mail/attachment/links').enable('save');
            ext.point('io.ox/mail/attachment/links').enable('open');
            ext.point('io.ox/mail/attachment/links').enable('vcard');
            ext.point('io.ox/mail/attachment/links').enable('ical');
            ext.point('io.ox/mail/attachment/links').enable('slideshow');
            ext.point('io.ox/mail/attachment/links').enable('text_edit');
            ext.point('io.ox/mail/attachment/links').enable('spreadsheet_edit');
            ext.point('io.ox/mail/attachment/links').enable('office_view');
        }

    }
    
    // Add lock to header
    ext.point('io.ox/mail/detail/header').extend({
        index: 230,
        id: 'ogMailLock',
        draw: function (baton) {
            ogMailLockExt.call(this, baton);
        }
    });
    

    ext.point('io.ox/mail/mobile/detail/header').extend({
        index: 230,
        id: 'ogMailLock',
        draw: function (baton) {
            ogMailLockExt.call(this, baton);
            setAttachments(baton);
        }
    });

    
    function ogMailLockExt(baton) {
        var headers = baton.view.model.get('headers');
        if (headers === undefined) {
            baton.view.listenTo(baton.view.model, 'change:headers', function () {
                headers = baton.view.model.get('headers');
                if (headers['X-OxGuard-ID'] !== undefined) {
                    window.setTimeout(function () {
                        baton.view.redraw();
                    }, 5);

                }
            });
            return;
        }
        if (headers['X-OxGuard-ID'] !== undefined) {
            // Add lock symbol to header
            var lockdiv = $('<div style="float:left; padding-right:5px;" id="lockdiv" title="' + gt('This Email was sent encrypted. It has been decrypted with your private key') + '"></div>');
            lockdiv.append($('<i class="icon-lock icon-large fa fa-lock oxguard_lock">'));
            if (_.contains(account.getFoldersByType('sent'), baton.data.folder_id) || (baton.data.folder_id === unified_sent)) {
                lockdiv.click(function () {
                    if (window.oxguarddata.settings.status !== false)
                        status(baton, false);       
                });
            }
            var exp = baton.model.get('exp');
            if (exp !== undefined) {
                if (exp > 0) {
                    var expdate = new Date(exp).toLocaleString();
                    //#. Expires: date/time.  This is on header of email labeling when an email will expire
                    var expd = $('<span class="og_exp">' + gt('Expires: ') + expdate + '</span><br/>');
                    $(this).prepend(expd);
                }
            }
            $(this).prepend(lockdiv);
        }
        baton.view.$el.find('.subject').html(baton.data.subject);
    }
    
    // Handle viewing the emails
    var point = ext.point('io.ox/mail/detail');

    point.extend({
        id: 'OGHider',
        index: 1,
        draw: function (baton) {
            if (baton.data.og) {
                baton.view.$el.hide();
                $('.thread-view-list').append('<div style="text-align:center; background-color:white;" id="loading"><i class="fa fa-spinner fa-spin" id="busygif"></i></div>');
            }
        }
    });
    point.extend({
        id: 'OGdecoder',
        index: 2000,
        draw: function (baton) {
            detailExt(baton);
        }
    });
    

    ext.point('io.ox/mail/mobile/detail').extend({
        id: 'OGdecoder',
        index: 2000,
        draw: function (baton) {
            detailExt(baton);

        }
    });

    // Extension for watching for changes, then checking if OG data or not.
    function detailExt(baton) {
        require (['oxguard/mail/checker'], function (checker) {
            checker.checkOG.call(this, baton);
        });
    }
    
    
 
    
 

    ////////////////  Status in sent folder
    
    account.getUnifiedMailboxName().done(function (id) {
        require (['settings!io.ox/mail'], function (settings) {
           unified_sent = id + settings.get('defaultseparator', '/') + 'Sent'; 
        });
    });
    
    
    // Get the status of email action
    new links.Action('io.ox/mail/actions/status', {
        id: 'statusaction',
        requires: function (e) {
            if (!(_.contains(account.getFoldersByType('sent'), e.context.folder_id)) && (e.context.folder_id !== unified_sent)) return(false);
            try {
                if (e.baton.data.headers === undefined) return(false);
                if (e.baton.data.headers['X-OxGuard'] === undefined) return(false);
               // return((e.baton.data.headers['X-OxGuard'].toLowerCase() === 'true') && e.baton.data.decoded);
                return((e.baton.data.headers['X-OxGuard'].toLowerCase() === 'true') && (window.oxguarddata.current!==null));
            } catch (ex) {
                console.log(ex);
                return (false);
            }
        },
        action: function (baton) {
            status(baton, true);
        }
    });
    
    new links.Action('io.ox/mail/actions/pin', {
        id: 'statusaction',
        requires: function (e) {
            if (!(_.contains(account.getFoldersByType('sent'), e.context.folder_id)) && (e.context.folder_id !== unified_sent)) return(false);
            try {
                if (e.baton.data.headers === undefined) return(false);
                return(e.baton.data.headers['X-OxGuard-PIN'] !== undefined);
            } catch (ex) {
                console.log(ex);
                return (false);
            }
        },
        action: function (baton) {
            pin(baton);
        }
    });
    
    ext.point('io.ox/mail/links/inline').extend(new links.Link({
        index: 100,
        prio: 'lo',
        id: 'statuslink',
        label: gt('Retract'),
        ref: 'io.ox/mail/actions/status',
        mobile: 'hi'
    }));
    
    ext.point('io.ox/mail/links/inline').extend(new links.Link({
        index: 101,
        prio: 'lo',
        id: 'pinlink',
        label: gt('Check assigned PIN'),
        ref: 'io.ox/mail/actions/pin',
        mobile: 'lo'
    }));
    
    function pin (baton) {
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.ModalDialog({ width: 300, center: true, enter : 'ok'});
            dialog.header($('<h4>').text(gt('PIN')));
            var pin = baton.data.headers['X-OxGuard-PIN'];
            var pintext = $('<h2>').append(pin);
            dialog.getBody().append(pintext);
            dialog.addPrimaryButton('ok', gt('OK'), 'ok').show();
        });
    }
    
    //  Edit a guard draft email
    var editpoint = ext.point('io.ox/mail/actions/edit');
    editpoint.replace ({
        id: 'edit',
        requires: function (e) {
            // must be top-level
            if (!e.collection.has('toplevel')) return;
            // multiple and not a thread?
            if (!e.collection.has('one') && !e.baton.isThread) return;
            // get first mail
            var data = e.baton.first();
            // If PGP email and not decoded, then hide edit button
            if (e.baton.data.pgp_found === true && e.baton.data.PGPDecoded !== true) return;
            // must be draft folder
            return data && isDraftMail(data);
        },
        action: function (baton) {
            var data = baton.first(),
                check = false;
            _.each(ox.ui.apps.models, function (app) {
                if (app.refId === data.id) {
                    check = true;
                    app.launch();
                }
            });
            if (check === true) return;
            try {
                    if (window.oxguarddata.current !== null) {
                        window.oxguarddata.current.ogId = undefined;  // Not replying to an email, null out
                        if (window.oxguarddata.oldcompose) {
                            require(['io.ox/mail/write/main', 'oxguard/mail/oxguard_mail_write_core'], function (m, core) {
                                m.getApp().launch().done(function () {
                                    this.compose({ folder_id: baton.app.folder.get() });
                                    var view = this.getView().form;
                                    this.setMail(prepareDraft(window.oxguarddata.current))
                                    .done(function () {
                                        core.saveToHeader(view);
                                    });
                                });
                            });
                        } else {
                            ox.registry.call('mail-compose', 'forward', prepareDraft(window.oxguarddata.current).data);
                        }

                        return;
                    }
            } catch (e) {
                console.log(e);
            }
            if (window.oxguarddata.oldcompose) {
                require(['io.ox/mail/write/main'], function (m) {
                    if (m.reuse('edit', data)) return;
                    m.getApp().launch().done(function () {
                        this.edit(data);
                    });
                });
            } else {
                require(['io.ox/mail/compose/main'], function (m) {
                    if (m.reuse('edit', data)) return;
                    m.getApp().launch().done(function () {
                        this.edit(data);
                    });
                });
            }
            
        }
    });
    
    function prepareDraft (dat) {
        var ordered = $.parseJSON(JSON.stringify(dat));
        ordered.attachments = [];
        ordered.msgref = ordered.folder_id + '/' + ordered.id;
        var attachments = dat.attachments;
        var added = -1;
        // Attachments must be re-ordered, so the inline is first.
        for (var i = 0; i < attachments.length; i++) {
            if (attachments[i].disp === 'inline') {
               ordered.attachments.push(attachments[i]); 
               added = i;
            }
        }
        for (i = 0; i < attachments.length; i++) {
            if (i !== added) {
                var att = attachments[i];
                att.group = 'attachment';
                att.raw = true;
                ordered.attachments.push(att);
            }
        }
        var newdata = {
                data : ordered,
                format : 'html'
        };
        return (newdata);
    }
 
    var isDraftFolder = function (folder_id) {
        return _.contains(account.getFoldersByType('drafts'), folder_id);
    },
    isDraftMail = function (mail) {
        return isDraftFolder(mail.folder_id) || ((mail.flags & 4) > 0);
    };
    
    
    // Get the status of emails
    function status(baton, retr) {
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.ModalDialog({ width: 400, center: true, enter : 'ok'});
            //#. Header for dialog for Retract Email or Email Status
            dialog.header($('<h4>').text((retr ? gt('Retract Email') : gt('Email status'))));
            var busy = $('<i id="busystatus" class="fa fa-spinner fa-spin"></i>');
            dialog.getBody().append(busy);
            var item = baton.data.headers['X-OxGuard-ID'];
            dialog
            .addPrimaryButton('ok', (retr ? gt('Cancel') : gt('OK')), 'ok', {classes : 'status_table_button'});
            if (retr) {
                dialog.addButton('retract', gt('Retract all access'), 'retract', {classes : 'status_table_button'});
            }
            //#. Retract all access, retracts an email from being read by all recipients
            dialog.on('retract', function () {
                setTimeout(function () {
                    retract(item);
                }, 500);
            })
            .show();
    
            require (['oxguard/core/og_http'], function (og_http) {
                var params = '&item=' + item + '&userid=' + ox.user_id + '&cid=' + ox.context_id;
                og_http.get(ox.apiRoot + '/oxguard/mail?action=count', '&session=' + ox.session + params)
                .done(function (data) {
                    $('#busystatus').remove();
                    var readstatus = $.parseJSON(data);
                    var html = '<table class="status_table" style="width:100%">';
                    for (var i in readstatus) {
                        //var img = '<img src="apps/oxguard/images/mail-unread.png" />';
                        var img = '<i class="icon-envelope-alt fa-envelope-o icon-2x fa fa-2x og_status" title="' + gt('Email has not been opened.') + '"/>';
                        if (readstatus[i].count > 0) {
                            //img = '<img src="apps/oxguard/images/mail-read.png" />';
                            img = '<i class="icon-folder-open-alt fa-folder-open-o icon-2x fa fa-2x og_status" title="' + gt('Email has been opened.') + '"/>';
                        }
                        if (readstatus[i].count < 0) {
                            if (readstatus[i].count = -9999) { // -9999 is not available response
                             //   img = '<i class="fa fa-question fa-2x" title="' + gt('Email status not available.') + '"/>';
                                img = '';
                            } else {
                                img = '<i class="icon-ban-circle fa-ban icon-2x fa fa-2x og_status" title="' + gt('Email has been retracted.') + '"/>';
                            }
                            
                        }
                        html += '<tr><td>' + readstatus[i].email + '</td><td>' + img + '</td></tr>';
                    }
                    html += '</table>';
                    var datatable = $(html);
                    dialog.getBody().append(datatable);
                })
                .fail(function () {
                    require (['io.ox/core/notifications'], function (notifications) {
                        notifications.yell ('error', gt('Unable to get email status, please try again later'));
                    });
                });
            });
            
        });
    }
    
    // Retract selected email
    function retract(item) {
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.ModalDialog({ width: 450, center: true, enter : 'ok'});
            dialog.header($('<h4>').text(gt('Retract Email')));
            var verify = $('<p>' + gt('This will retract the email for all recipients. Click OK to confirm.') + '</p>');
            dialog.getBody().append(verify);
            dialog
            .addPrimaryButton('ok', gt('OK'), 'ok')
            .addButton('cancel', gt('Cancel'), 'cancel')
            .on('ok', function () {
                var params = '&item=' + item + '&userid=' + ox.user_id + '&cid=' + ox.context_id;
                require (['io.ox/core/notifications', 'oxguard/core/og_http'], function (notifications, og_http) {
                    og_http.get(ox.apiRoot + '/oxguard/mail?action=retract', '&session=' + ox.session + params)
                    .done(function (data) {
                        if (data.trim() === 'OK') {
                            notifications.yell('success', gt('Item was retracted'));
                        } else notifications.yell('error', gt('Not all items retracted'));
                    })
                    .fail(function () {
                        notifications.yell('error', gt('Failed to retract'));
                    });
                });
            })
            .show(function () {
                
            });
        });
    }

    return {
        status : status,
        prepareDraft : prepareDraft 
    };
    
});
