define('oxguard/mail/register_compose', ['io.ox/core/extensions',
                           'gettext!oxguard/mail/register_compose', 'io.ox/backbone/mini-views/dropdown', 'oxguard/mail/oxguard_mail_compose_core',
                           'css!oxguard/style.css'],
                           function (ext, gt, Dropdown, core) {
    'use strict';
   
    var guesticon = '<i id="newguest" class="fa fa-male oxguard_token" style="color:#5DCD55;" title="' + gt('Will create new guest account for Guard') + '"/>';
    //#. Have encryption key - Shown on icon hover when a key symbol is displayed for recipient.  We/Guard have an encryption key for the recipient.
    var keyicon = '<i class="fa fa-key oxguard_token oxguard_lock" aria-hidden="true"' + gt('Have encryption key') +'/>';
    var failicon = '<i id="newguest" class="fa fa-ban oxguard_token" style="color:red;" title="' + gt('Will create new guest account for Guard') + '"/>';
    
   
    
    
    var newpoint = ext.point('io.ox/mail/compose/fields');
    newpoint.extend({
        id: 'locksend',
        index: 'last',
        draw: function (baton) {
            // Create Security Link
            try {
                var view = baton.view.$el;
                if (view === undefined) return;//View not yet loaded
                if (view.find('#OxGuardOn').length > 0) return;//Already created
                require (['oxguard/mail/options_new'], function (options) {
                    options.createOptions(baton);
                });
                addBlur(baton);
            } catch (e) {
                console.log(e.toString());
            }
            
        }
        
    });
    
    
    function addBlur(baton) {
        baton.view.listenTo(baton.model, 'change:to', function (e) {
            var keys = (baton.model.get('gkeys') === undefined ? [] : baton.model.get('gkeys'));
            if (baton.model.get('PGPGuard')) {
                core.checkRecips(e, 'to', keys);
            }
        });
        baton.view.listenTo(baton.model, 'change:cc', function (e) {
            var keys = (baton.model.get('gkeys') === undefined ? [] : baton.model.get('gkeys'));
            if (baton.model.get('PGPGuard')) {
                core.checkRecips(e, 'cc', keys);
            }
        });
        baton.view.listenTo(baton.model, 'change:bcc', function (e) {
            var keys = (baton.model.get('gkeys') === undefined ? [] : baton.model.get('gkeys'));
            if (baton.model.get('PGPGuard')) {
                core.checkRecips(e, 'bcc', keys);
            }
        });
    }
    
    ext.point('io.ox/mail/compose/token').extend({
        id: 'keyicons',
        index: 100,
        draw: function (m, baton) {
            var email = m.get('token').value;
            var result = core.checkKeys (email, baton.model.get('gkeys'));
            switch (result) {
            case 'pgp' :
                $(this).find('.close').before(keyicon);
                break;
            case 'guest' :
                $(this).find('.close').before(guesticon);
                break;
            case 'fail' :
                $(this).find('.close').before(failicon);
                break;
            }
            
        }
    });
    
    ext.point('io.ox/mail/compose/composetoolbar').extend({
        id: 'security',
        index: 150,
        draw: function (baton) {
            if (window.oxguarddata.settings) {
                if (window.oxguarddata.settings.oxguard) {
                    var dropdown = new Dropdown({ model: baton.model, label: gt('Security'), caret: true });
                    dropdown
                    .header(gt('PGP'))
                    .option('PGPGuard', true, gt('Encrypt'))
                    .option('PGPSignature', true, gt('Sign'))
                    //#. Format of the email, HTML or Plaintext
                    .header(gt('Format'))
                    .option('PGPFormat', 'mime', gt('PGP Mime'))
                    .option('PGPFormat', 'inline', gt('PGP Inline'));
                    var div = this.find('.col-xs-4');
                    div.append(dropdown.render().$el.addClass('text-left').css('padding-left', '20px'));
                    this.append(div);
                }
            }
            
            
        }
    });
    
    
    
    var sendpoint = ext.point('io.ox/mail/compose/buttons');
    sendpoint.extend({
        id: 'send',
        index: 100,
        draw: function (baton) {
            this.append($('<button type="button" class="btn btn-primary" data-action="send">')
                    .on('click', function () {
                        if (baton.model.get('PGPGuard')) {
                            require (['oxguard/mail/sender_compose'], function (sender) {
                                sender.sendMail(baton, window.oxguarddata.passcode);
                            });
                        } else {
                            if (baton.model.get('PGPSignature')) { // If for PGP Signature
                                if (baton.model.get('headers')['X-OX-Guard-Auth'] === undefined) {// If not already authrized
                                    require(['oxguard/oxguard_core', 'oxguard/crypto/encr', 'io.ox/core/notifications'], function (core, encr, notify) {
                                        core.getPassword(gt('Please enter your Guard password to sign this email'))  //Get password
                                        .done(function (pass) {
                                            core.auth(ox.user_id, pass)  // Verify against backend
                                            .done(function (data) {
                                                if (data.auth.length > 20) {  // If OK, add header and send
                                                    baton.model.get('headers')['X-OX-Guard-Auth'] = encr.cryptPass(pass);
                                                    baton.model.get('headers')['X-OX-Guard-Marker'] = true;
                                                    baton.view.send();
                                                } else {
                                                     // Otherwise report error
                                                    if (data.auth=='Bad Password') {
                                                        notify.yell('error', gt('Bad Password'));
                                                    } else {
                                                        notify.yell('error', gt('Error') + ' ' + data.auth);
                                                    }
                                                }
                                            })
                                            .fail(function () {
                                                notify.yell('error', gt('Unable to authorize against backend'));
                                            });
                                        });
                                    });
                                } else {
                                    baton.model.get('headers')['X-OX-Guard-Marker'] = true;
                                    baton.view.send();
                                }
                                
                            } else {
                                baton.view.send();
                            }
                        }
                    })
                    .text(gt('Send')));
            this.append($('<button type="button" class="btn" data-action="test">')
                    .on('click', function () {

                    })
                    .text('debug'));
        }
    });
    
    ext.point('io.ox/mail/compose/buttons').replace({
        id: 'save',
        index: 200,
        draw: function (baton) {
            this.append($('<button type="button" class="btn btn-default" data-action="save">')
                    .on('click', function () {
                        if (baton.view.isSaving === true) return false;
                        baton.view.isSaving = true;
                        if (baton.view.model.get('PGPGuard')) {
                            if (window.oxguarddata.passcode === 'No Key') {
                                require (['oxguard/mail/oxguard_mail_write_core', 'oxguard/mail/sender_compose'], function (core, sender) {
                                    core.createKeys('', baton.view.$el)
                                    .done(function () {
                                        sender.draftMail(baton, window.oxguarddata.passcode);
                                    });
                                });
                                baton.app.isSaving = false;
                                return;// Do not send until the master key is created
                            }
                            require (['oxguard/mail/sender_compose'], function (sender) {
                                sender.draftMail(baton, window.oxguarddata.passcode);
                            });
                            return;
                        }
                        baton.view.saveDraft().done(function () {
                            baton.view.isSaving = false;
                        }).fail(function () {
                            baton.view.isSaving = false;
                        });
                    })
                    .text(gt('Save')));
            
        }
    });
    
});