/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/mail/oxguard_mail_write_core', ['io.ox/core/extensions', 'oxguard/core/og_http',
                                'io.ox/core/notifications',
                                'io.ox/core/tk/dialogs', 'gettext!oxguard/oxguard_core'],
                                function (ext, og_http, notify, dialogs, gt) {
    'use strict';
    
    // 7.62 compose code
    
    // Add lock to the message detail view and menu options
    var lockclass = 'selectable icon-lock icon-2x fa fa-lock fa-2x oxguard_lock';
    var unlockclass = 'selectable icon-unlock icon-2x fa fa-unlock fa-2x oxguard_lock';
    var pgpclass = 'fa fa-key pgp_superscript';
    
    // Save encryption settings to header
    function saveToHeader(view) {
        try {
            var emailheader = view.find('[name="headers"]');
            var headerstring = emailheader.val();
            var header = {};
            if (headerstring !== '') header = JSON.parse(headerstring);
            var isInline = false;
            if (view.find('#PGPinline').is(':checked')) {
                header['X-Oxguard-PGPInline'] = 'True';
                isInline = true;
            } else {
                delete header['X-Oxguard-PGPInline'];
            }
            if (view.find('#PGPSign').is(':checked')) {
                var value = 'False';
                if (isInline && !isPGP(view)) {  // If inline and not encrypted, make sure in text mode
                    if (view.find('input[name="format"]:checked').val() === 'text') {
                        value = 'True';
                    } else {
                        value = 'False';
                        view.find('#PGPSign').prop('checked', false);
                    }
                } else { // If not inline, then we can sign regardless
                    value = 'True';
                }
                header['X-Oxguard-PGPSign'] = value;
            } else  { // if not checked, then false
                header['X-Oxguard-PGPSign'] = 'False';
            }

            if (isPGP(view)) {
                header['X-Oxguard-PGP'] = 'True';
            } else {
                delete header['X-Oxguard-PGP'];
            }
            emailheader.val(JSON.stringify(header));
        } catch (e) {
            console.log(e);
        }

        return;
    }
    

    
    // Create the options div for oxguard
 

    
    function isPGP(view)
    {
        if (view.find('#PGPGuardOn').is(':checked')) {
            return(true);
        }
        return (false);
    }
    
    
    // Check if email has a public key that we can use
    function checkrecip(email, from, view) {
        if (email.val().indexOf('<') < 0) return;// make sure has email address
        var id = hash(email.val());
        if (view.find('#recip_' + id).length === 1) {
            return;// If we have already processed, return
        }
        var tag = $('<span class="oxguard_key icon-stack fa-stack" id="recip_' + id + '"></span>');
        email.before(tag);// Tag this recipient
        var params = '&email=' + email.val() + '&cid=' + ox.context_id + '&from=' + encodeURIComponent(from) + '&userid=' + ox.user_id;
        og_http.get(ox.apiRoot + '/oxguard/mail?action=getkey', params)
        .done(function (data) {//Get the key
            try {
        
                    if (data.pgp === true) {
                        var pgp = $('<div class="oxguard_icon_fa" title="' + gt('PGP key exists for this person')+ '"/>');
                        pgp.append('P<span style="font-size:0.5em;">gp</span>');
                        var lockicon = $('<i class="' + pgpclass + '" aria-hidden="true"/>');
                        pgp.append(lockicon);
                        tag.append(pgp);
                        var em = email.val().replace(/"/g, '');
                        tag.append('<input type="hidden" name="newguest" class="og_new" value="' + em + '"/>');
                        if (data.expired === true) {
                            notify.yell('error', gt('The key for %1$s is expired and should not be used', email.val()));
                        }
                        if (data.inline === true) {// If inline is requested, change to inline
                            var inlinebox = view.find('#PGPinline');
                            if (!inlinebox.is(':checked')) {
                                notify.yell('info', gt('One of your recipients requires emails to be sent as PGP Inline.  Changing now.'));
                                inlinebox.click();
                            }
                        }
                        return;
                    }
                    if (data.guest === true) {
                        tag.append('<i id="newguest" class="icon-male icon-stack-base fa fa-male fa-stack-2x" style="color:#A5FF9E;"/><i class="icon-key fa fa-key fa-stack-1x oxguard_lock" title="' + gt('Will create new guest account for Guard') + '"/>');
                        var em = email.val().replace(/"/g, '');
                        tag.append('<input type="hidden" name="newguest" class="og_new" value="' + em + '"/>');
                        return;
                    } 

                    tag.append('<i class="icon-ban-circle icon-stack-base fa fa-ban fa-stack-2x" style="color:red;"/><i class="icon-key fa fa-key fa-stack-1x" title="' + gt('Unable to create Guard account, please try again later') + '"/>');
                    view.find('.recipient-name').addClass('oxguard_keyspace'); // add spacing to name for the key
            } catch (e) {
                console.log(e);
            }
        });
        
    }
    
    // Return a has of string
    function hash(str) {
        var hashed = 0;
        if (str.length === 0) return hashed;
        for (var i = 0; i < str.length; i++) {
            hashed = (31 * hashed + str.charCodeAt(i)) << 0;
        }
        return hashed;
    }
    
    
    function checkrecipient(view) {
        if (window.oxguarddata.passcode === 'No Key') {
            require(['oxguard/oxguard_core'], function(core) {
                core.createKeys('', view)
                .done(function (e) {
                    console.log(e);
                    checkrecipient(view);
                })
                .fail(function () {
                    unlock(view);
                });
            });
            return;// Do not check recipients until the master key is created (in case mailing to self)
        }
        var from = view.find('.sender-dropdown').val();
        view.find('input[name="to"]').each(function () {
            checkrecip($(this), from, view);
        });
        view.find('input[name="cc"]').each(function () {
            checkrecip($(this), from, view);
        });
        view.find('input[name="bcc"]').each(function () {
            checkrecip($(this), from, view);
        });

    }
    
    // depreciated proprietary unlock
    function unlock(view) {
        pgpunlock(view);
    }
    
    // depreciated proprietary lock
    function lock(view, baton) {
        pgplock(view, baton);
    }
    
    function pgplock (view, baton) {
        if (baton.app) {
            if (baton.app.autosave) {
                window.clearTimeout(baton.app.autosave.timer);
            } 
        }
        var lock = view.find('#statuslock');
        lock.attr('class', lockclass);
        lock.attr('title', gt('Click to disable PGP encryption'));
        if (_.device('smartphone')) {
            $('.btn-primary:visible').html(gt('Send Secure'));
        } else {
            view.find('.btn-primary:visible').html(gt('Send Secure'));
        }
        view.find('#OxGuardOn').prop('checked', false);
        view.find('#PGPGuardOn').prop('checked', true);
        view.find('.pgpsign').show();
        if (window.oxguarddata.settings.pgpsign === true) {  // If default to sign, then check
            view.find('#PGPSign').prop('checked', true);
        } 
        checkrecipient(view);
        view.find('.oxguard_key').show();
        view.find('.recipient-name').addClass('oxguard_keyspace');
        saveToHeader(view);
        lockquit(baton);
    }
    
    function pgpunlock (view) {
        var lock = view.find('#statuslock');
        lock.attr('class', unlockclass);
        lock.attr('title', gt('Click to enable encryption'));
        if (_.device('smartphone')) {
            $('.btn-primary:visible').html(gt('Send'));
        } else {
            view.find('.btn-primary:visible').html(gt('Send'));
        }
        view.find('#OxGuardOn').prop('checked', false);
        view.find('#PGPGuardOn').prop('checked', false);
        view.find('.oxguard_key').hide();
        view.find('.recipient-name').removeClass('oxguard_keyspace');
        saveToHeader(view);
    }
   
    function lockquit(baton) {
        if (baton.app.quitUpdate === undefined) {
            baton.app.quit = _.wrap(baton.app.quit, function(func, b) {
                // if dirty and guard checked, then fire our prompt
                if (this.dirty() && this.getView().form.find('#PGPGuardOn').is(':checked')) {
                    require (['oxguard/mail/register_oldcompose'], function (grd) {
                        grd.promptDraft(baton);
                    });
                } else {
                    func.call(this, b);
                }
            });
            baton.app.quitUpdate = true;
        }
        
        
    }
    


    return {
        
        checkRecip : function (view) {
            
            checkrecipient(view);
            
        },

        updateheader : function updateHeader(view) {
            saveToHeader(view);
        },
        
        lock : lock,
        unlock : unlock,
        pgplock : pgplock,
        pgpunlock : pgpunlock,
        saveToHeader : saveToHeader
        
    
    };
});
    

    