/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/mail/oxguard_mail_compose_core', ['io.ox/core/extensions', 'oxguard/core/og_http',
                                'io.ox/core/notifications',
                                'io.ox/core/tk/dialogs', 'gettext!oxguard/oxguard_mail_compose_core'],
                                function (ext, og_http, notify, dialogs, gt) {
    'use strict';
    
    // Add lock to the message detail view and menu options
    var lockclass = 'icon-lock icon-2x fa fa-lock fa-2x oxguard_lock';
    var unlockclass = 'icon-unlock icon-2x fa fa-unlock fa-2x oxguard_lock';
     

    // 7.8 compose code

    // Check the recipient to see if we have guard keys.  If not local data, then lookup
    function checkRecips (m, field, guardkeys) {
        var recips = m.get(field);
        if (recips.length > 0) {
            for (var i = 0; i < recips.length; i++) {
                var r = recips[i];
                var status = checkKeys (r[1], guardkeys);  // check our cache
                if (status === null) {
                    var keymap = {
                            email : r[1],
                            pending : true,
                            result : null
                    };
                    guardkeys.push(keymap); // add placeholder
                    getKeyResult (r[1], m.get('from')[0][1], m, field);  // get results from backend
                }
            }
            m.set('gkeys', guardkeys);
        }
        window.setTimeout (function () {
            remOldKeys (m, guardkeys);  // Check for old deleted keys, but add delay so that moving tokens doesn't erase
        }, 200);
    }
    
    
    //  remove non-referenced keys
    function remOldKeys (m, guardkeys) {
        var recips = m.get('to').concat(m.get('cc')).concat(m.get('bcc'));
        for (var i = 0; i < guardkeys.length; i++) {
            var found = false;
            var key = guardkeys[i];
            for (var j = 0; j < recips.length; j++) {
                if (key.email === recips[j][1]) found = true;
            }
            if (!found) {
                guardkeys.splice(i, 1);
            }
        }
        m.set('gkeys', guardkeys);
    }
    
    // Loop through key lookup record and return result, null if not yet checked
    function checkKeys (u, keys) {
        if (keys === undefined) return(null);
        for (var i = 0; i < keys.length; i++) {
            var k = keys[i];
            if (k.email === u) {
                if (k.pending === true) return ('pending');
                return (k.result);
            }
        }
        return (null);
    }
    
    // Query guard server for key result
    function getKeyResult (email, from, m, field) {
        var params = '&email=' + email + '&cid=' + ox.context_id + '&from=' + encodeURIComponent(from) + '&userid=' + ox.user_id;
        og_http.get(ox.apiRoot + '/oxguard/mail?action=getkey', params)
        .done(function (data) {//Get the key
            try {
        
                    if (data.pgp === true) {
                        updateKeys (email, 'pgp', m, field);
                    }
                    if (data.guest === true) {
                        updateKeys (email, 'guest', m, field);
                    }
            } catch (e) {
                console.log(e);
            }
        })
        .fail (function () {
            updateKeys (email, 'fail', m, field);
        });
    }
    
    // update Keys lookup with new result for the email
    function updateKeys (email, result, m, field) {
        var guardkeys = m.get('gkeys');
        for (var i = 0; i < guardkeys.length; i++) {
            var k = guardkeys[i];
            if (k.email === email) {
                k.result = result;
                k.pending = false;
                m.set('gkeys', guardkeys);
                m.trigger('change:' + field, m, m.get(field));
                return;
            }
        }
    }
    
    
    // Return a has of string
    function hash(str) {
        var hashed = 0;
        if (str.length === 0) return hashed;
        for (var i = 0; i < str.length; i++) {
            hashed = (31 * hashed + str.charCodeAt(i)) << 0;
        }
        return hashed;
    }
    
    function checkrecipient(baton) {
        if (window.oxguarddata.passcode === 'No Key') {
            require(['oxguard/oxguard_core'], function(core) {
                core.createKeys('', baton)
                .done(function (e) {
                    console.log(e);
                    checkrecipient(baton);
                })
                .fail(function () {
                    unlock(baton);
                });
            });
            return;// Do not check recipients until the master key is created (in case mailing to self)
        }
        var keys = (baton.model.get('gkeys') === undefined ? [] : baton.model.get('gkeys'));
        checkRecips (baton.model, 'to', keys);
        checkRecips (baton.model, 'cc', keys);
        checkRecips (baton.model, 'bcc', keys);

    }
    
    function unlock(baton) {   
        var lock = baton.view.$el.find('#statuslock');
        lock.attr('class', unlockclass);
        lock.attr('title', gt('Click to enable encryption'));
        if (_.device('smartphone')) {
            $('.btn-primary:visible').html(gt('Send'));
        } else {
            var headerview = baton.view.app.get('window').nodes.header;
            headerview.find('.btn-primary:visible').html(gt('Send'));
        }
        baton.view.$el.find('.oxguard_key').hide();
        baton.view.$el.find('.oxguard_token').hide();
    }
    
    function lock(baton) {

        if (baton.app) {
            if (baton.app.autosave) {
                window.clearTimeout(baton.app.autosave.timer);
            } 
        }
        var lock = baton.view.$el.find('#statuslock');
        lock.attr('class', lockclass);
        lock.attr('title', gt('Click to disable encryption'));
        if (_.device('smartphone')) {
            $('.btn-primary:visible').html(gt('Send Secure'));
        } else {
            var headerview = baton.view.app.get('window').nodes.header;
            headerview.find('.btn-primary:visible').html(gt('Send Secure'));
        }
        checkrecipient(baton);
        baton.view.$el.find('.oxguard_key').show();
        baton.view.$el.find('.oxguard_token').show();
    }
    
   


    return {
        
        checkRecip : function (baton) {
            
            checkrecipient(baton);
            
        },
        checkRecips : checkRecips,
        checkKeys : checkKeys,
        
        lock : lock,
        hash : hash,
        unlock : unlock
        
    
    };
});
    

    