/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */

define('oxguard/mail/options_new', ['oxguard/mail/oxguard_mail_compose_core', 'gettext!oxguard/mail/options_new'],
                              function (core, gt) {
    'use strict';
    
    var lockclass = 'icon-lock icon-2x fa fa-lock fa-2x oxguard_lock';
    var unlockclass = 'icon-unlock icon-2x fa fa-unlock fa-2x oxguard_lock';
    
    
    function createlock(baton) {
        
        var lockstatus = $('<div id="lockdiv" class="oxguard_lock_compose"><i id="statuslock" class="' + unlockclass + '" title="' + gt('Click to enable encryption') + '"></div>');
        var fromline = baton.view.$el.find('.row.sender');
        if (window.oxguarddata.settings.oxguard)  // Only people with oxguard permissions can change
            lockstatus.click(function () {
                baton.model.set('PGPGuard', !baton.model.get('PGPGuard'));
                setLock (baton);
            });
        fromline.append(lockstatus);
        baton.view.listenTo(baton.view.model, 'change:PGPGuard', function () {
            setLock(baton); 
        });
        setLock(baton);
    }
    
    function setLock (baton) {
        if (baton.model.get('PGPGuard')) {
            core.lock(baton);
            if (window.oxguarddata.settings.pgpsign) {
                baton.model.set('PGPSignature', true);
            }
        } else {
            core.unlock(baton);
            baton.model.set('PGPSignature', false);
        }
    }
    
    function warnHTML (view) {
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.CreateDialog({ width: 450, height: 300, center: true});
            dialog.header($('<h4>').text(gt('HTML Formatted Email')));
            var body = $('<p>');
            body.append(gt('HTML formatted emails may cause issues with PGP inline.  Click OK to change to Plain Text formatted Emails'));
            dialog.getBody().append(body);
            dialog
            .addPrimaryButton('ok', gt('OK'), 'okx')
            .addButton('cancel', gt('Cancel'), 'cancel')
            .on('ok', function () {
                view.find('input[name="format"][value="text"]').click();
            })
            .show();
        });
    }
    
    /// Disable the recipient inputs and color the background
    function lockReply (baton) {
        var view = baton.view.$el;
        view.find('.token-input').attr('disabled', 'disabled');
        view.find('.token-input').addClass('og_disabled').click(notice);
        view.find('.tokenfield').addClass('og_disabled').click(notice);
    }
    
    function notice () {
        require (['io.ox/core/notifications'], function (notifications) {
            notifications.yell('error', gt('Recipients cannot be added to this encrypted reply'));
        });
    }
    
    function createOptions(baton) {
        // Lets see if we should allow user to see OxGuard compose
        if ((window.oxguarddata.settings.oxguard === false) || (window.oxguarddata.settings.oxguard === undefined)) {
            if (window.oxguarddata.action !== 'secureReply') {// OK if secure reply, otherwise
                return;
            }
        }
        if (window.oxguarddata.action === 'sendfile') {// If it is going to be sending already encrypted file, then don't add encryption options
            window.oxguarddata.action = null;
            return;
        }
        if (window.oxguarddata.sentfolder === undefined) {// Get sent folder data for sending
            require(['settings!io.ox/mail']).done(function (settings) {
                window.oxguarddata.sentfolder = settings.get('folder/sent');
                window.oxguarddata.draftfolder = settings.get('folder/drafts');
            });
        }
        window.setTimeout (function () {
            createlock(baton);
        }, 200);

        // If this is a secure reply, then disable all of the options to make it plain text
        if ((window.oxguarddata.action === 'secureReply') || (window.oxguarddata.action === 'fileAttach')) {
            baton.model.set('PGPGuard', true);
            baton.view.$el.find('#statuslock')
             //   .attr("src", "apps/oxguard/images/lock32.png")
                .attr('class', lockclass)
                .click(false)
                .attr('title', gt('Reply must be encrypted'));
            if ((window.oxguarddata.action === 'secureReply') && (window.oxguarddata.settings.oxguard === false)) {
                // If secure reply, and does not have OG, only allow reply to orig 
                window.setTimeout (function () {
                    lockReply (baton);
                }, 500);
            }

        }
        window.oxguarddata.action = null;
        if (baton.model.get('newmail') === true) {  // New email doesn't have recips yet.  Check to see if there are defaults
            // If default is to use guard, go ahead and lock
            if (window.oxguarddata.settings.pgpdefault) {
                baton.model.set('PGPGuard', true);
                if (window.oxguarddata.settings.pgpsign) {
                    baton.model.set('PGPSignature', true);
                }
                core.lock(baton);
            } else baton.model.set('PGPGuard', false);
            if (window.oxguarddata.settings.inline === true) {
                baton.model.set('PGPFormat', 'inline');
            } else baton.model.set('PGPFormat', 'mime');
            baton.model.unset('newmail');
        }
        return;
    } 
    
    
    return {
        createOptions : createOptions,
        warnHTML : warnHTML
    };
});