/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */

define('oxguard/mail/options', ['oxguard/mail/oxguard_mail_write_core', 'gettext!oxguard/mail/options'],
                              function (core, gt) {
    
    var lockclass = 'selectable icon-lock icon-2x fa fa-lock fa-2x oxguard_lock';
    var unlockclass = 'selectable icon-unlock icon-2x fa fa-unlock fa-2x oxguard_lock';
    
    // Retrieve oxguard settings from header and repopulate
    function retrieveOxGuard(view, baton)
    {
        var headerstring = view.find('[name="headers"]').val();
        // Make sure header string exists and populated
        if (typeof headerstring !== 'undefined') {
            if (headerstring.length > 1) {
                var header = JSON.parse(headerstring);
                // Set oxguard on
                window.setTimeout(function () {
                    if (typeof header['X-OxGuard-Draft'] !== 'undefined') {
                        if (baton) baton.app.refId = header['X-OxGuard-Draft'];
                    }
                    
                    if (typeof header['X-Oxguard-PGP'] !== 'undefined') {
                        if (header['X-Oxguard-PGP'] === 'True') {
                            core.pgplock(view, baton);
                            core.checkRecip(view);
                        }
                    }
                    if (typeof header['X-Oxguard-PGPInline'] !== 'undefined') {
                        if (header['X-Oxguard-PGPInline'] === 'True') {
                            view.find('#PGPinline').prop('checked', true);
                            view.find('.pgpsign').show();
                        }
                    }
                    if (typeof header['X-Oxguard-PGPSign'] !== 'undefined') {
                        if (header['X-Oxguard-PGPSign'] === 'True') {
                            view.find('#PGPSign').prop('checked', true);
                            view.find('.pgpsign').show();
                        }
                    }
                    core.saveToHeader(view);
                }, 500);
            }
            
        }

    }
    
    function createlock(view, baton) {
        
        view.find('.subject-wrapper').css('right', '40px').css('position', 'absolute'); // Shift subject line over
        view.find('.priority-overlay').css('right', '53px');
        var lockstatus = $('<div id="lockdiv" style="float:right; height:30px;"><i id="statuslock" class="' + unlockclass + '" title="' + gt('Click to enable encryption') + '"></div>');
        var subjectline = view.find('.subject-wrapper');
        subjectline.after(lockstatus);
        lockstatus.click(function () {
            var pgp = view.find('#PGPGuardOn').is(':checked');
            if (pgp === true) {
                core.pgpunlock(view);
            } else 
                core.pgplock(view, baton);
        });
    }
    
    
    function warnHTML (view, signing) {
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.CreateDialog({ width: 450, height: 300, center: true});
            dialog.header($('<h4>').text(gt('HTML Formatted Email')));
            var body = $('<p>');
            body.append(gt('HTML formatted emails may cause issues with PGP inline.  Click OK to change to Plain Text formatted Emails'));
            dialog.getBody().append(body);
            dialog
            .addPrimaryButton('ok', gt('OK'), 'okx')
            .addButton('cancel', gt('Cancel'), 'cancel')
            .on('ok', function () {
                view.find('input[name="format"][value="text"]').click();
                if (signing === true) view.find('#PGPSign').prop('checked', true);
                core.updateheader(view);
            })
            .show();
        });
    }

    // Create the options on the mail compose window
    function createOptions(view, baton, count) {
        if (window.oxguarddata.settings.oxguard === undefined) {  // If we don't yet have response from the Guard backend, check every second then handle
            if (count === undefined) count = 0;
            if (count > 10) return;  // limit our loop to 10 seconds
            window.setTimeout(function () {
                count++;
                createOptions(view, baton, count);
            }, 1000);
        }
    // Lets see if we should allow user to see OxGuard compose
        if ((window.oxguarddata.settings.oxguard === false) || (window.oxguarddata.settings.oxguard === undefined)) {
            if (window.oxguarddata.action !== 'secureReply') {// OK if secure reply, otherwise
                var headerstring = view.find('[name="headers"]').val();// Check for OG header
                // Make sure header string exists and populated
                if (typeof headerstring !== 'undefined') {
                    if (headerstring.length > 1) {
                        var header = JSON.parse(headerstring);
                        // If oxguard didn't update header, then return
                        if (typeof header['X-OxGuard'] === 'undefined') {
                            return;
                        }
                    } else return;
                } else return;
            }
        }
        if (window.oxguarddata.action === 'sendfile') {// If it is going to be sending already encrypted file, then don't add encryption options
            window.oxguarddata.action = null;
            return;
        }
        if (window.oxguarddata.sentfolder === undefined) {// Get sent folder data for sending
            require(['settings!io.ox/mail']).done(function (settings) {
                window.oxguarddata.sentfolder = settings.get('folder/sent');
                window.oxguarddata.draftfolder = settings.get('folder/drafts');
            });
        }
        
        if (view.find('.oxguard_lock').length > 0) return;  // If already drawn, return
        createlock(view, baton);
        // div seperator for each item
        var sectiondiv = '<div class="section-item oxguard_options" style="padding-top: 0.1em; padding-bottom: 0.2em; line-height: 2em;">';
        // Enabled and disabled buttons

        var pgpdiv = '';
        var signdiv = '';
        var inlinediv = '';
        
        // If PGP enabled, then draw
        if (window.oxguarddata.settings.oxguard || (window.oxguarddata.action === 'secureReply')) {
            var pgp = $('<input type="checkbox" id="PGPGuardOn" name="pgpguard" value="pgpgaurd" style="margin-top: 5px; margin-right:5px;" class="pgpopt">');
            var pgptitle = $('<span style="padding-right:5px;padding-bottom:15px;" class="selectable">' + gt('Send encrypted (PGP)') + '</span>');
            pgpdiv = $(sectiondiv).append(pgp).append(pgptitle);
            pgp.click(function () {
                core.saveToHeader(view);
                if (view.find('#islocked').length === 0) {
                    if (pgp.is(':checked')) {
                        core.pgplock(view, baton);
                    } else {
                        core.pgpunlock(view);
                    }

                }
            });
            pgptitle.click(function () {
                pgp.click();
            });
            var pgpsign = $('<input type="checkbox" id="PGPSign" name="pgpsign" value="pgpsign" style="margin-top: 5px; margin-right:5px;" class="pgpopt">');
            var pgpsigntitle = $('<span style="padding-right:5px;padding-bottom:15px;" class="selectable">' + gt('Sign email') + '</span>');
            var inline = $('<input type="checkbox" id="PGPinline" name="pgpinline" value="pgpinline" style="margin-top: 5px; margin-right:5px;" class="pgpopt">');
            var inlinetitle = $('<span style="padding-right:5px;padding-bottom:15px;" class="selectable">' + gt('Use PGP inline (compatibility)') + '</span>');
            signdiv = $(sectiondiv).addClass('pgpsign').append(pgpsign).append(pgpsigntitle);
            inlinediv =  $(sectiondiv).addClass('pgpsign').append(inline).append(inlinetitle);
            pgpsigntitle.click(function () {
                pgpsign.click();
            });
            inlinetitle.click(function () {
                inline.click();
            });
            // Set up defaults
            if ((window.oxguarddata.settings.inline === true) || window.oxguarddata.replyInline) {  // If default for inline, then click
                inline.prop('checked', true);
                window.setTimeout (function () {
                    if (view.find('input[name="format"]:checked').val() === 'html') {
                        if (!window.oxguarddata.replyInline) warnHTML (view);  // Warn of change if this wasn't triggered by reply
                    }
                });
                
            }
            if (window.oxguarddata.settings.pgpsign === true) {
                pgpsign.prop('checked', true);
            }
            
            //Function
            inline.click(function () {
                if (view.find('#PGPinline').is(':checked')) {
                    if (view.find('input[name="format"]:checked').val() === 'html') {
                        warnHTML (view);
                    }
                }
            });
            pgpsign.click(function (e) {  // For now, only inline plaintext will be signed
                if ($(e.target).is(':checked')){
                    if (!view.find('#PGPGuardOn').is(':checked')) {
                        if (view.find('#PGPinline').is(':checked')) {
                            if (view.find('input[name="format"]:checked').val() === 'html') {
                                warnHTML (view, true);
                            }
                        }
                    }
                }
            });
        } 
        // Main options DIV
        
        var optionsdiv = $('<div class="section-item oxguard_options" id="oxguarddiv" style="display:none; margin-top:5px;"></div>');
        // Put it together
        optionsdiv.append(pgpdiv).append('<hr style="margin: 5px;" class="pgpsign">').append(signdiv).append(inlinediv);
             

        var securelink = $('<div class="section-link"></div>');
        var secureoptions = $('<a href="#" id="oxguardlink" data-section-link="security">' + gt('Security Options') + '</a>');
        var caret = $('<i class="fa fa-caret-right" aria-hidden="true"></i>');
        securelink.append(secureoptions.prepend(caret));
        securelink.append(optionsdiv);
        view.find('[data-section-link="options"]').parent().before(securelink);
        secureoptions.click(function (ev) {
            if (optionsdiv.is(':visible')) {
                optionsdiv.slideUp();
                caret.removeClass('fa-caret-down').addClass('fa-caret-right');
                ev.preventDefault();
                return;
            }
            // If already created, just slide down
            if (optionsdiv.length > 0) {
                optionsdiv.slideDown();
                caret.removeClass('fa-caret-right').addClass('fa-caret-down');
                ev.preventDefault();
                return;
            }
        });

        // If this is a secure reply, then disable all of the options to make it plain text
        if ((window.oxguarddata.action === 'secureReply') || (window.oxguarddata.action === 'fileAttach')) {
            view.find('#statuslock')
             //   .attr("src", "apps/oxguard/images/lock32.png")
                .attr('class', lockclass)
                .click(false)
                .attr('title', gt('Reply must be encrypted'));
            view.find('.btn-primary:visible').html(gt('Send Secure'));
            view.find('#PGPGuardOn').prop('checked', true).prop('enabled', false).prop('disabled', true);
            if ((window.oxguarddata.action === 'secureReply') && (window.oxguarddata.settings.oxguard === false)) {
                // If secure reply, and does not have OG, only allow reply to orig 
                $('#writer_field_to').remove();
                $('#writer_field_cc').remove();
                $('#writer_field_bcc').remove();
            }
            delayCheck(view);
        }
        
        // If default is to use guard, go ahead and lock
        if (window.oxguarddata.settings.pgpdefault) {
            core.pgplock(view, baton);
            delayCheck(view);
        }

        // Handlers for updating header for storage
        $(document).ready(function () {
            view.find('.pgpopt').click(function () {
                core.saveToHeader(view);
            });
            view.find('input[name="format"]').on('click', function () {
                core.saveToHeader(view);
            });
            window.setTimeout(function () {
                retrieveOxGuard(view, baton);
                core.saveToHeader(view);
            }, 500);
        });

        return;
    } 
    
    function delayCheck(view) {
        window.setTimeout(function () {
            window.oxguarddata.action = null;
            window.oxguarddata.replyInline = null;
            core.saveToHeader(view);
            core.checkRecip(view);
        }, 2000);
    }
    
    
    return {
        createOptions : createOptions,
        retrieveOxGuard : retrieveOxGuard
    };
});
