/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/mail/mail_extensions_compose', ['io.ox/core/extensions',
                           'gettext!oxguard/mail/mail_extensions_compose',],
                           function (ext, gt) {
    'use strict';
   
    ext.point('io.ox/mail/actions/reply').replace({
        id: 'reply',
        action: function (baton) {
            if (window.oxguarddata.current !== null) {
                var data = window.oxguarddata.current;
                if (data.PGPDecoded) {  // If we have PGP decode data, then use it to compose new email
                    window.oxguarddata.action = 'secureReply';
                    doReply (data, false);
                    return;
                }
            }
            ox.registry.call('mail-compose', 'reply', baton.first());
        }
    });
    
    ext.point('io.ox/mail/actions/reply-all').replace({
        id: 'reply',
        action: function (baton) {
            if (window.oxguarddata.current !== null) {
                var data = window.oxguarddata.current;
                if (data.PGPDecoded) {  // If we have PGP decode data, then use it to compose new email
                    window.oxguarddata.action = 'secureReply';
                    doReply (data, true);
                    return;
                }
            }
            ox.registry.call('mail-compose', 'reply', baton.first());
        }
    });
    
    ext.point('io.ox/mail/actions/forward').replace({
        id: 'forward',
        action: function (baton) {
            if (window.oxguarddata.current !== null) {
                var data = window.oxguarddata.current;
                if (data.PGPDecoded) {  // If we have PGP decode data, then use it to compose new email
                    window.oxguarddata.action = 'secureReply';
                    doForward (data);
                    return;
                }
            }
            ox.registry.call('mail-compose', 'forward', baton.isThread ? baton.first() : baton.data);
        }
    });
    
    ext.point('io.ox/mail/actions/compose').replace({
        id: 'compose',
        action: function (baton) {
            ox.registry.call('mail-compose', 'compose', { folder_id: baton.app.folder.get(), newmail : true });
        }
    });
    
    function doReply (data, all) {
        require (['oxguard/mail/prep_reply', 'settings!io.ox/mail'], function (prep, settings) {
            var to = data.from;
            var cc = [];
            if (all) {
                var userEmail = settings.get('defaultSendAddress', '');
                to = prep.getTo (to, userEmail);
                cc = prep.getTo (cc, userEmail);
            }
            var text = (settings.get('messageFormat', 'html') === 'text');
            var attachment = {
                    content : text ? 
                            prep.prepareTextReply($.extend({}, data) , 'reply') : 
                                prep.prepareReply($.extend({}, data) , 'reply'),
                    content_type : text ? 'text/plain' : 'text/html',
                    disp: 'inline'
            };
            var subject = gt ('Re: %1$s', data.subject);
            ox.registry.call('mail-compose', 'edit', { to: to, cc: cc, subject : subject, attachments: [attachment]});
        });
    }
    
    function doForward (data) {
        require (['oxguard/mail/prep_reply', 'settings!io.ox/mail'], function (prep, settings) {
            var text = (settings.get('messageFormat', 'html') === 'text');
            var attachment = {  // Prepare main body
                    content : text ? 
                            prep.prepareTextReply($.extend({}, data) , 'forward') : 
                                prep.prepareReply($.extend({}, data) , 'forward'),
                    content_type : text ? 'text/plain' : 'text/html',
                    disp: 'inline'
            };
            var attachments = [attachment];
            var msgref = data.folder_id + '/' + data.id;
            for (var i = 0; i < data.attachments.length; i++) {  // Add all the attachments
                if (data.attachments[i].disp !== 'inline') {
                    data.attachments[i].ogAttach = msgref;
                    attachments.push(data.attachments[i]);
                }  
            }   
            var subject = gt ('Fwd: %1$s', data.subject);
            ox.registry.call('mail-compose', 'edit', { subject : subject, attachments: attachments, msgref : msgref});
        });
    }
    
});