/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */

// Functions to load decoded email from Guard
define('oxguard/mail/getmail', ['io.ox/core/extensions', 'oxguard/core/og_http', 'gettext!oxguard/mail/getmail'],
                              function (ext, og_http, gt) {
    

    // Retrieve decrypted email and replace template
    function getMail(baton, auth, password, extrapass, location, cc) {
        var deferred = $.Deferred();
        var attachid = 0;// Find the attachment that contains the data, an get number
        if (baton.data.attachments === undefined) return;
        for (var j = 0; j < baton.data.attachments.length; j++) {// Find the attachment ID
            if (baton.data.attachments[j].filename === baton.data.headers['X-OxGuard-ID'] + '.grd') {
                attachid = baton.data.attachments[j].id;
                baton.model.set('attachid', attachid);
            }
        }
        if (attachid === 0) {// Already resolved, or no attachment
            if (baton.data.og) {
                if (baton.data.attachid !== undefined) {
                    attachid = baton.data.attachid;
                    if (attachid === 0) {
                        baton.view.$el.find('.content').replaceWith('<div class="content" id="content" style="padding-top:20px;width:100px;margin-left:auto;margin-right:auto;">' + 
                                gt('Error.  Please reload message') +
                                '</div>');
                    }
                } else return (deferred);
            } else {
                baton.view.$el.find('.content').replaceWith('<div class="content" id="content" style="padding-top:20px;width:100px;margin-left:auto;margin-right:auto;">' + 
                        gt('Error.  Please reload message') +
                        '</div>');
                return;
            }
        }
        if (baton.data.headers['X-OxGuard-ExtraPass'] === 'true') {
            if (extrapass.length < 2) {
                promptExtraPass(baton, auth, password);
                return;
            }
        }
        var eid = getId(baton);
        baton.view.$el.find('.error').replaceWith('');  // Clear out error messages
        window.setTimeout(function () {// Diplay wait symbol
            //#. Decoding an email, shown in wait dialog
            baton.view.$el.find('.content').replaceWith('<div class="content" id="content' + eid + '" style="padding-top:20px;width:100px;margin-left:auto;margin-right:auto;">' + gt('Decoding') + '<i class="fa fa-spinner fa-spin" style="margin-left:10px;"></i></div><div class="error" id="error' + eid + '"/>');
            baton.view.$el.show();
            baton.view.$el.find('.attachments').hide();
           // $('.attachments').hide();
        }, 20);
        var id = baton.data.headers['X-OxGuard-ID'];
        var params = '&auth=' + encodeURIComponent(auth) + '&time=' + new Date().getTime() + '&session=' + ox.session;
        var json = {
                itemid : id,
                folder : getFolder(baton),
                userid : ox.user_id,
                cid : ox.context_id,
                password : password,
                session : ox.session,
                attach : attachid,
                emailid : eid,
                extrapass : extrapass,
                cc : cc ? cc : ''
        };
        // Send the request to the oxguard server
        var url = ox.apiRoot + '/oxguard/mail?action=getmail';
        og_http.post(url, params, json)
        .done(function (data) {
            try {

                var data2 = JSON.parse(data);
                if (data2.Exceeded !== undefined) {
                    require (['io.ox/core/notifications'], function (notifications) {
                        notifications.yell ('error', gt('You have exceeded bad password attempts.  Please wait %s minutes', data2.Exceeded));
                    });
                    baton.view.$el.find('.content').replaceWith(gt('You have exceeded bad password attempts.  Please wait %s minutes', data2.Exceeded));
                    deferred.reject('Exceeded');
                    return (deferred);
                }
                var newattachments = [];
                baton.data.attachment = false;
                
                // Search for the inline attachments and add
                for (j = 0; j < data2.attachments.length; j++) {
                    if (data2.attachments[j].disp === 'inline') {
                        var type = data2.attachments[j].content_type;
                        if ((type.indexOf('text') > -1) || (type.indexOf('alternative') > -1)) {// add text attachments
                            if (type === 'alternative') {
                                type = 'text/html';
                                data2.attachments[j].content_type = type;
                            }
                            if (type === 'text/plain') {
                                data2.attachments[j].content = data2.attachments[j].content.replace(/\n/g, '<br>');
                            }
                            newattachments.push(data2.attachments[j]);
                            baton.data.replytext = data2.attachments[j].content;
                            baton.data.replytype = type;
                        }
                        
                    }
                }
                
                // Now, search for attachments and add data
                
                for (var i = 0; i < baton.data.attachments.length; i++) {
                    // Search for attchments, and add necessary link data, copy decrypted
                    baton.data.attachments[i].decoded = true;
                    if (baton.data.attachments[i].disp === 'attachment') {
                        if (baton.data.attachments[i].filename.indexOf('.grd') > 0) {
                            baton.data.attachments[i].epass = data2.epass;
                            baton.data.attachments[i].extrapass = data2.extrapass;
                            baton.data.attachments[i].cc = cc;// Store content key for the attachment if any
                            baton.data.attachments[i].title = baton.data.attachments[i].title.replace('.grd2', '').replace('.grd', '');
                            baton.data.attachments[i].filename = baton.data.attachments[i].filename.replace('.grd2', '').replace('.grd', '');
                            if (baton.data.attachments[i].id !== attachid) {// If not the encrypted body
                                newattachments.push(baton.data.attachments[i]);
                                baton.data.attachment = true;
                                baton.data.attachments[i].ogAttach = true;
                            }
                        }
                        else { // After 1 or 2 calls, the ui copies the view data over to baton, so already decrypted.  Just add it
                            if (baton.data.attachments[i].ogAttach) {
                                newattachments.push(baton.data.attachments[i]);
                                baton.data.attachment = true;
                            }
                        }

                    }
                }

                // Update baton
                baton.data.attachments = newattachments;
                baton.data.headers = $.extend(baton.data.headers, data2.headers);
                baton.data.ogId = id;
                baton.model.set('exp', data2.exp);
                baton.decoded = true;
                baton.data.to = data2.to;
                baton.data.cc = data2.cc;
                baton.data.replyfrom = data2.from;
                baton.model.set('subject', data2.subject);  // Perm set subject
                
                
                // copy the model to a new temporary for display
                var mdata = _.copy(baton.view.model.toJSON(), true);
                mdata.to = data2.to;
                mdata.cc = data2.cc;
                mdata.from = data2.from;
                mdata.attachments = newattachments;
                mdata.attachment = baton.data.attachment;
                mdata.nested_msgs = data2.nested_msgs;
                mdata.subject = data2.subject;
                mdata.headers = $.extend(baton.data.headers, data2.headers);
                mdata.headers['X-OxGuard-ID'] = id;
                mdata.headers['X-Oxguard-Done'] = 'True';
                mdata.decoded = true;
                
                // Set to the model
                baton.decodedData = mdata;
                baton.view.stopListening(baton.view.model, 'change:flags', baton.view.onChangeFlags);
                var backbone = require('io.ox/core/api/backbone');
                baton.view.model = new backbone.Model(mdata);
                var pool = require('io.ox/mail/api').pool;
                pool.get('guard').add(baton.view.model);
                baton.view.listenTo(baton.view.model, 'change:flags', baton.view.onChangeFlags);
                baton.view.loaded = true;
                baton.view.$el.empty();// Clear out the old template email data
                baton.view.redraw();
                baton.view.expand();                
                baton.view.$el.find('.attachment-preview').hide();
                baton.view.$el.addClass('guard-mail');

                // Store in temp for reply
                window.oxguarddata.current = JSON.parse(JSON.stringify(baton.data));
                
                // 7.6.0 attachments displayed differently
                if (ox.serverConfig.version.indexOf('7.6.0') === 0) {
                    if (!baton.data.attachments) baton.view.$el.find('.attachments').remove();
                } else {
                    if (baton.data.attachment) {
                        window.setTimeout(function () {
                            var baton2 = ext.Baton({ data: data, attachments: newattachments });
                            var node = baton.view.$el.find('section.attachments').empty();
                            ext.point('io.ox/mail/detail/attachments').enable('attachment-list');
                            ext.point('io.ox/mail/detail/attachments').invoke('draw', node, baton2);
                        }, 0);
                    } else {
                        baton.view.$el.find('.attachments').remove();
                    }
                }
                baton.view.$el.find('.alert.external-images').hide();
                deferred.resolve('OK');
            } catch (e) {
                var cont = '#content' + eid;
                if (data.indexOf('expired') >= 0) {
                    baton.view.$el.find(cont).replaceWith('<br>' + gt('This email has expired and can no longer be accessed.  Contact the sender for more information.') + '</hr>');
                    deferred.reject('expired');
                    return;
                }
                if (data.indexOf('retracted') >= 0) {
                    baton.view.$el.find(cont).replaceWith('<br>' + gt('This Email has been retracted by the sender and can no longer be accessed.  Contact the sender for more information.') + '</hr>');
                    deferred.reject('retracted');
                    return;
                }
                if (baton.view.$el !== null) baton.view.$el.find(cont).replaceWith(gt('Unable to decrypt Email.'));
                console.log(e);
                deferred.reject('error');
            }
            
        })
        .fail(function (data) {
            require (['oxguard/oxguard_core'], function (core) {
                core.handleFailEmail (data, baton, deferred);
            });
            
        });
        return (deferred);
    
    }
    
    // Unified inbox combines folder and email ID, returns email id
    function getId(baton) {
        var id = decodeURIComponent(baton.data.id);
        try {
            id = id.substring(id.lastIndexOf('/') + 1);
        } catch (e)
            {
            }
        return (id);
    }
    
    // Returns actual folder in unifided inbox for email retrieval
    function getFolder(baton) {
        var id = decodeURIComponent(baton.data.id);
        if (id.indexOf('/') < 0) return (baton.data.folder_id);
        var folder = id.substring(0, id.lastIndexOf('/'));
        return(folder);
    }
    
    // Get the extra password if not previously provided
    function promptExtraPass(baton, auth, password) {
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.CreateDialog({ width: 450, center: true, enter : 'ok'});
            dialog.header($('<h4>').text(gt('Extra Password')));
            var passdiv = $('<div>').addClass('row-fluid');
            passdiv.append('<p>' + gt('The sender added an extra password encryption.') + '</p><p>' + gt('Please enter it below') + '</p>');
            passdiv.append('<input name="extrapassword" type="password"/>');
            dialog.getBody().append(passdiv);
            dialog
            .addPrimaryButton('ok', gt('OK'), 'ok')
            .addButton('cancel', gt('Cancel'), 'cancel')
            .on('ok', function () {
                getMail(baton, auth, password, $('input[name="extrapassword"]').val());
                
            })
            .show(function () { $('input[name="extrapassword"]').focus(); });
        });
    }
    
    
    
    return {
        getMail : getMail
        };
});