/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */

define('oxguard/mail/checker', [],
                              function () {
    
    // Check if OxGuard email, and if so, send to decrypt or prompt password
    function checkOG(baton) {
        if (baton.view.model === null) {
            return;
        }
        // Check if alreay done...
        if ((baton.decoded === true) || (baton.data.decoded === true)) {
            // Check to see if they are members, and if not, display upsell
            try {
                $('#loading').remove();
                baton.view.$el.show();
                baton.view.$el.find('.attachment-preview').hide();
                if (window.oxguarddata.settings.oxguard === false) {
                    var location = baton.view.$el.find('.detail-view-header');
                    upsell(location);
                }
            } catch (e) {
                
            }
            return;// if this is an already decrypted email, then return
        }
        if (!baton.data.PGPDecoded) window.oxguarddata.current = null;
        var headers = baton.view.model.get('headers');
        if (headers === undefined) {// not yet loaded
            return;
        }
        // Init
        if (baton.data.headers === undefined) { // If email wasn't fully loaded into baton, do so now.
            baton.data = baton.view.model.toJSON();
        }
        
        if (window.oxguarddata.settings === undefined) {// If OG settings not yet loaded, store baton for finish load
            window.oxguarddata.baton = baton;
        }
        
        if (headers['X-OxGuard-Guest'] !== undefined) { // Although it's an OG email, guest from other system, so stop and show.
            if (headers['X-OxGuard-Domain'] !== undefined) {
                // If domain in email is same as in URL, probably upgraded account, should show password prompt
                if (getURL().indexOf(headers['X-OxGuard-Domain']) < 0) {
                    $('#loading').remove();
                    baton.view.$el.show();
                    return;
                }
            } else {
                $('#loading').remove();
                baton.view.$el.show();
                return;
            }
        }
        
      //If header states an oxguard email, then start
        if (headers['X-OxGuard-ID'] !== undefined) {
            require (['oxguard/mail/oxguard_mail', 'oxguard/mail/getmail', 'oxguard/oxguard_core'] , function (oxmail, reader, core) {
                baton.view.$el.find('.alert.external-images').hide();
                
                baton.model.trigger('change', baton.model, this); //trigger   redraw inbox list icon
                baton.data.og = true;
                var location = this;
                baton.view.expand();
                $('#loading').remove();
                // Check to see if we should be requesting passwords
                if ((window.oxguarddata.passcode === null) || ((headers['X-OxGuard-ExtraPass'] !== undefined) && (headers['X-OxGuard-ExtraPass'] !== ''))) {
                    baton.view.listenTo(baton.view.model, 'change:attachments', function () {
                        checkOG(baton);
                        if (baton.view.$el === null) return;
                        baton.view.$el.find('#oxgrpass').focus();
                    });
                    window.setTimeout(function () {// Diplay password prompt
                        if (baton.view.$el === null) return;
                        baton.view.$el.find('.content').replaceWith(oxmail.passwordPrompt(baton, false, location));
                        baton.view.$el.find('#oxgrpass').focus();
                        baton.view.$el.show();
                        baton.view.$el.find('.attachments').remove();
                        baton.view.$el.find('.subject').html(baton.data.subject.replace('OXGrd::', '').replace('OXGrd:', ''));
                        baton.view.expand();
                    }, 10);
                } else {
                    var goFunction = function (baton, data) {
                        reader.getMail(baton, data.auth, '', '');
                    };
                    if (window.oxguarddata.passcode.indexOf('Password Needed') > -1) {// If no password for user has been defined, open dialog
                        core.createOxGuardPasswordPrompt(baton, '', '', goFunction);
                        return;
                    }
                    if (window.oxguarddata.passcode.indexOf('No Key') > -1) {// If received a first encrypted email while already logged in, will still have 'no key' in passcode
                        core.createOxGuardPasswordPrompt(baton, '', '', goFunction);
                        return;
                    }
                    if ((window.oxguarddata.passcode === 'NoPrivate') || (window.oxguarddata.passcode === 'No Key')) {// No key would really only occur in a demo reset
                        window.setTimeout(function () {// Diplay password prompt
                            baton.view.$el.show();
                            baton.view.$el.find('.content').replaceWith(oxmail.passwordPrompt(baton, false, location));
                            $('#oxgrpass').focus();
                            baton.view.$el.find('.attachments').remove();
                        }, 100);
                        return;
                    }
                    $('#loading').remove();
                    reader.getMail(baton, window.oxguarddata.passcode, '', '', location)
                    .done(function () {
                        baton.view.$el.show();
                        baton.view.$el.find('section').show();
                        baton.view.$el.find('.attachment-preview').hide();
                        baton.model.on('change:attachments', function () {// Attachments occasionally reloaded after decoded
                            if (baton.decodedData !== undefined) {// If already decoded, redraw decoded data
                                if (baton.view.model !== null) {
                                    if (baton.view.model.get('attachments').length !== baton.decodedData.attachments.length) {
                                        baton.view.model = new Backbone.Model(baton.decodedData);
                                        baton.view.redraw();
                                        baton.view.expand();
                                    }
                                }
                            }
                            
                        });
                    })
                    .fail(function () {
                        console.log('fail og load');
                        baton.model.on('change:attachments', function () {
                            window.oxguarddata.passcode = null;
                            checkOG(baton);
                        });
                    });
                
                }
            });
          //  baton.view.loaded = true;
        } else {
            $('#loading').remove();
            baton.view.$el.show();  // Not OG email, show contents
        }
    }
    
    function upsell(location) {
        var params = '&cid=' + ox.context_id + '&id=' + ox.user_id + '&lang=' + ox.language;
        require(['oxguard/core/og_http'], function (og_http) {
            og_http.get(ox.apiRoot + '/oxguard/mail?action=upsell', params)
            .done(function (data) {
                location.after(data);
            });
        });
    }
    
    function getURL() {
        var matches = document.URL.match(/^https?\:\/\/([^\/?#]+)(?:[\/?#]|$)/i);
        var domain = matches && matches[1];
        if (domain === null) domain = '';
        return (domain);
    }
   

    return {
        checkOG : checkOG
    };
    
});