/* All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/file/extrapass', ['io.ox/core/extensions', 'oxguard/core/og_http',
                                  'io.ox/core/tk/dialogs', 'gettext!oxguard/file/share'],
        function (ext, og_http, dialogs, gt) {
    'use strict';
    
    function createExtraPasswordPrompt(baton) {
        var dialog = new dialogs.CreateDialog({ width: 450, height: 300, center: true, enter : 'ok'});
        dialog.header($('<h4>').text(gt('Extra Password')));
        var passdiv = $('<div>').addClass('row-fluid');

        passdiv.append('<p>' + gt('This allows you to set an extra password that will be required for reading this item.') + '</p><p>' + gt('Please enter it below') + '</p>');
        var table = $('<table>');
        var row1 = $('<tr>');
        row1.append('<td><span>' + gt('Password') + ':</span></td>');
        var password1 = $('<input id="extrapassword1" type="password" class="oxguard_extrapass"/>');
        row1.append($('<td>').append(password1));
        var row2 = $('<tr>');
        row2.append('<td><span>' + gt('Confirm') + ': </span></td>');
        var password2 = $('<input id="extrapassword2" type="password" class="oxguard_extrapass"/>');
        row2.append($('<td>').append(password2));
        passdiv.append(table.append(row1).append(row2));
        if ((window.oxguarddata.passcode === null) || (window.oxguarddata.passcode.length < 10)) {
            var encrpassdiv = $('<div class="og_encr_pass_div">');
            encrpassdiv.append('<p>' + gt('Please enter your Guard Security password') + '</p>');
            encrpassdiv.append('<input id="password" type="password" class="oxguard_extrapass"/>');
            passdiv.append(encrpassdiv);
        }
        password1.keyup(function () {
            if (password1.val() !== password2.val()) {
                $('button[data-action="okx"]').prop('disabled', true);// disable the ok button if not same
            } else {
                $('button[data-action="okx"]').prop('disabled', false);
            }
        });
        password2.keyup(function () {
            if (password1.val() !== password2.val()) {
                password2.css('background-color', 'salmon');
                $('button[data-action="okx"]').prop('disabled', true);
            } else {
                password2.css('background-color', 'white');
                $('button[data-action="okx"]').prop('disabled', false);
            }
        });
        dialog.getBody().append(passdiv);
        dialog
        .addPrimaryButton('ok', gt('OK'), 'okx')
        .addButton('cancel', gt('Cancel'), 'cancel')
        .on('ok', function () {
            if ($('#extrapassword1').val() !== $('#extrapassword2').val()) {
                $('#reqpassword').attr('checked', false);
            } else {
                //  Add password
                if (password1.val() === '') {
                    $('#reqpassword').attr('checked', false);
                } else {
                    var json = {
                            id : baton.data.id,
                            folder : baton.data.folder_id,
                            password : $('#password').val(),
                            userid : ox.user_id,
                            cid : ox.context_id,
                            version : baton.data.version,
                            extrapass : $('#extrapassword1').val()
                    };
                    var params = '&session=' + ox.session +
                    '&auth=' + encodeURIComponent(window.oxguarddata.passcode) +
                    '&filename=' + encodeURIComponent(baton.data.filename);
                    
                    og_http.post(ox.apiRoot + '/oxguard/file?action=addextra', params, json)
                    .done(function () {//Get the key
                        $('.btn-sidepopup').click();
                        ext.point('io.ox/core/refresh').invoke('action');
                    }).fail(function () {
                        require(['io.ox/core/notifications'], function (notify) {
                            notify.yell('error', gt('Failed to add extra password'));
                        });
                    });
                }
            }
        })
        .on('cancel', function () {
            $('#reqpassword').attr('checked', false);
            
        })
        .show(function () {
            $('#extrapassword1').focus();
        });
    }
    
    return {
        createExtraPasswordPrompt : createExtraPasswordPrompt
    };
    
});