/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */

define('oxguard/file/encryptor', ['oxguard/core/og_http', 'gettext!oxguard/file/encryptor'],
                              function (og_http, gt) {
    
    var abort = false;
    
    function encrFiles(list, baton)
    {
        var win = baton.app.getWindow().nodes.main;
        function go() {
            var statusdiv = $('<div class="file_status"><div class="modal-header"><h4 style="text-align:left;">' + gt('Status') + '</h4></div><div class="modal-body" style="padding-bottom:30px;"><span id="filestat" class="file_status_text"></span></div></div>');
            var stopbutton = $('<div class="modal-footer"><button id="stopbutton" class="btn btn-primary file_stop_button">' + gt('Stop') + '</button></div>');
            statusdiv.append(stopbutton);
            $(win).append(statusdiv);
            stopbutton.click(function () {
                abort = true;
                setTimeout(function () {
                    $('.file_status').remove();
                    abort = false;
                    require (['io.ox/files/api'], function (api) {
                        api.trigger('refresh.all');
                    });
                }, 3000);
            });
            if (list.length > 0) {
                upload(list, 0);
            }
        }
        

        // Check if there are multiple versions
        var versions = false;
        for (var i = 0; i < list.length; i++) {
            if (list[i].number_of_versions > 1) versions = true;
        }
        if (!versions) {
            go();
            return;
        }
        // If so, display warning that only latest version saved
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.CreateDialog({ width: 450, center: true,  enter : 'ok'});
            dialog.header($('<h4>').text(gt('Encrypt Files')));
            var warning = $('<p>' + gt('Only the latest version of the files will be encrypted.') + '<br/>' + gt('All previous versions will be deleted.') + '</p>');
            var warning2 = $('<p style="margin-top:10px;">' + gt('Click OK to confirm') + '</p>');
            warning.append(warning2);
            dialog.getBody().append(warning);
            dialog
            .addPrimaryButton('ok', gt('OK'), 'ok')
            .addButton('cancel', gt('Cancel'), 'cancel')
            .on('ok', function () {
                go();
            })
            .show(function () { $('input[name="ogpassword"]').focus(); });
        });
              
    }
    
    function isOGFile(filename) {
        try {
            if (filename === null) return(false);
            if ((filename.indexOf('.grd') > 0) || (filename.indexOf('.grd2') > 0)) return (true);
        } catch (e) {
            return(false);
        }
        return (false);
    }
    
    function upload(list, index) {
        require (['io.ox/files/api'], function (api) {
            var file = list[index];
            var params = '&id=' + file.id +
            '&folder=' + file.folder_id +
            '&session=' + ox.session +
            '&userid=' + ox.user_id +
            '&cid=' + ox.context_id +
            '&version=' + (file.version ? file.version : '-1') +
            '&language=' + ox.language +
            '&filename=' + encodeURIComponent(file.filename);
            if (file.filename === undefined) {
                //#. Shown when encrypting file
                $('#filestat').text(gt('Encrypting '));
            } else {
                //#. Encryption filename, shown in progress bar
                $('#filestat').text(gt('Encrypting %s', file.filename));
            }
            // Check that the file isn't already encrypted
            if (isOGFile(file.filename)) {
                index++;
                //#. Filename is already encrypted
                $('#filestat').text(gt('%s already encrypted', file.filename));
                if ((index >= list.length) || abort) {
                    $('.file_status').remove();
                    abort = false;
                    api.trigger('refresh.all');
                    return;
                }
                upload(list, index);
            }
            // Send for encryption
            og_http.post(ox.apiRoot + '/oxguard/file?action=encrypt', params)
            .done(function () {
                index++;
                if ((index >= list.length) || abort) {
                    $('.file_status').remove();
                    abort = false;
                    api.trigger('refresh.all');
                    return;
                }
                $('#filestat').text(gt('Done'));
                upload(list, index);
            })
            .fail(function (data) {
                $('#filestat').text(gt('Failed to encrypt file') + file.filename + ' - ' + data.responseText);
                $('#stopbutton').text(gt('OK'));
                $('#stopbutton').click(function () {
                    $('.file_status').remove();
                    abort = false;
                    api.trigger('refresh.all');
                    return;
                });
                
            });
        });
    }
    
    return {
        encrFiles : encrFiles
    };
    
});