/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/core/passwords', ['gettext!oxguard/core/passwords'],
                           function (gt) {
    'use strict';
    
    function passwordCompare (el1, el2) {
        $(el1).on('input', function () {
            $(el1).removeClass('oxguard_badpass');
            if ($(el1).length >= 1) {
                if ($(el1).val() !== $(el2).val()) {
                    $(el1).addClass('oxguard_badpass');
                }
            }
        });
    }
    
    function passwordCheck(element, hint) {
        $(element).on('input', function () {
            check.call(this, hint);
        });
    }
    
    function check(hint) {
        var min = window.oxguarddata.settings.min_password_length;
        var len = window.oxguarddata.settings.password_length;
        if (min === undefined || len === undefined) {
            min = 6;
            len = 10;
        }
        if (len <= min) len = min + 1;
        var el = $(this);
        var val = el.val();
        el.removeClass('oxguard_warnpass').removeClass('oxguard_badpass').removeClass('oxguard_goodpass');
        if (hint !== undefined) {
            hint.removeClass('oxguard_hint_bad').removeClass('oxguard_hint_good').removeClass('oxguard_hint_warn');
        }
        if (val.length === 0) {
            return;
        }
        if (val.length < min) {
            el.addClass('oxguard_badpass');
            if (hint !== undefined) {
                hint.addClass('oxguard_hint_bad').text(gt('Too short'));
            }
            return;
        }
        var regex = /(?=^.{8,}$)(?=.*\d)(?=.*[!@#$%^&*]+)(?![.\n])(?=.*[A-Z])(?=.*[a-z]).*$/;
        if (val.match(regex)) {
            el.addClass('oxguard_goodpass');
            if (hint !== undefined) {
                hint.addClass('oxguard_hint_good').text(gt('Strong'));
            }
            return;
        }
        el.addClass('oxguard_warnpass');
        if (hint !== undefined) {
            hint.addClass('oxguard_hint_warn').text(gt('Weak'));
        }
        
    }
    
    return {
        passwordCheck : passwordCheck,
        passwordCompare : passwordCompare
    };
    
});