/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/contacts/register_contacts', ['io.ox/core/extensions', 'oxguard/pgp/publickeys', 
                           'css!oxguard/style.css'],
                           function (ext, pubkeys) {
    
    ext.point('io.ox/contacts/detail').extend({
        id: 'pgppublic',
        index: 'last',
        draw: function (baton) {
            var list = (baton.data.email1 ? baton.data.email1 : '') + ',' + (baton.data.email2 ? baton.data.email2 : '') + ',' + (baton.data.email3 ? baton.data.email3 : '');
            var newfield = $('<fieldset class="block" data-block="pgp">');
            $(this).find('.clearfix').append(newfield.append(pubkeys.listPublic(baton.app.id, list)));
        }
        
    });
    
});