/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.tester;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

import com.google.gson.JsonObject;
import com.openexchange.guard.cacheitems.Cache;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.database.Access;
import com.openexchange.guard.database.CacheManager;
import com.openexchange.guard.database.DbCommand;
import com.openexchange.guard.database.DbQuery;
import com.openexchange.guard.database.EmailInfo;
import com.openexchange.guard.database.OGInit;
import com.openexchange.guard.database.Sharding;
import com.openexchange.guard.database.Utilities;
import com.openexchange.guard.encr.Crypto;
import com.openexchange.guard.encr.GuardKeys;
import com.openexchange.guard.encr.OffsiteKeys;
import com.openexchange.guard.encr.PGPFilesProcessor;
import com.openexchange.guard.encr.PopulateRSA;
import com.openexchange.guard.file.Fileshare;
import com.openexchange.guard.ox.Api;
import com.openexchange.guard.ox.Languages;
import com.openexchange.guard.server.CheckBad;
import com.openexchange.guard.server.OxDbConn;
import com.openexchange.guard.setup.MasterPasswordCreator;
import com.openexchange.guard.setup.Repair;
import com.openexchange.guard.translate.GetText;

public class Test {

    public static void main(String[] args) throws Exception {
        // TODO Auto-generated method stub

        OxDbConn.init();
        OGInit.initGuardDatabase();
        Config.loadConfig();
    	Api ap = new Api("greg", "ghill1");
    	System.out.println(ap.getContextId());

        EmailInfo info = new EmailInfo("49e33089-6118-4af3-a61c-1f8ea7fdec2a", 1, -1);
        System.out.println(info.senderEmail);
        CacheManager.updateCache("8e8a89d0-19f7-45c3-97b8-14ca837e03b0");
        Languages lang = new Languages(); // Initialize translation engine
        System.out.println(GetText.gettext("Secure Email", "de_DE"));
        try {
            Sharding sh = new Sharding();
            Sharding.getNextShard();
            Utilities util = new Utilities();
            String email = "greg2@encr.us";
            JsonObject user = util.getUser(email);
            System.out.println(user.get(email).getAsJsonObject().get("cid").getAsInt());
            OGInit.initGuardDatabase();
        } catch (Exception e1) {
            // TODO Auto-generated catch block
            e1.printStackTrace();
        }

        DbCommand com = new DbCommand("SELECT * FROM KeyTable ORDER by cid LIMIT 3;");

        DbQuery ox = new DbQuery();
        ox.readOG(com);
        if (ox.next()) {
            System.out.println(ox.rs.getString("email"));
        }

        OxDbConn.close();
        Languages d = new Languages();
        GetText gettext = new GetText();
        Cache cache = new Cache();
        com.openexchange.guard.dbpool.Manager mgr = new com.openexchange.guard.dbpool.Manager();
        // fs.addShare("4544dda5-b727-47e4-8b27-71b6e8b46522", 1, "testshare2@email.com", 6, 7, false);
        // CheckBad.addBad("test");
        System.out.print(CheckBad.isBad("test", 5));
        Crypto crypt = new Crypto();
        try {
            Access acc = new Access();
            GuardKeys keys = acc.getKeys(5, 1);
            OffsiteKeys ok = new OffsiteKeys();
            ok.changeKeys(keys.getDecodedPrivate("ghill1"), keys.getPublic(), 5, 1);
            String key = crypt.exportPrivateKey2(5, 1, "ghill1");
            System.out.println(key);
        } catch (Exception ex) {
            System.out.println(ex);
        }

    }

    public static void testencr(GuardKeys oxkeys) {
        com.openexchange.guard.encr.PGPFilesProcessor encrfiles = new PGPFilesProcessor();
        encrfiles.setInputFileName("C:\\testplain.txt");
        encrfiles.setOutputFileName("c:\\testout.txt");
        encrfiles.setPassphrase("ghill1");
        encrfiles.setAsciiArmored(true);
        try {
            encrfiles.encrypt(oxkeys.getPGPPublicKey());
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public static void testdecr(GuardKeys oxkeys) {
        com.openexchange.guard.encr.PGPFilesProcessor encrfiles = new PGPFilesProcessor();
        encrfiles.setInputFileName("c:\\testout.txt");
        encrfiles.setOutputFileName("c:\\testdec.txt");
        encrfiles.setPassphrase("ghill1");
        try {
            encrfiles.decrypt(oxkeys.getPGPSecretKeyRing());
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public static String readTestFile() {
        try {
            BufferedReader br = new BufferedReader(new FileReader("c:\\testkey2.asc"));
            StringBuilder sb = new StringBuilder();
            String line = "";
            while ((line = br.readLine()) != null) {
                sb.append(line + "\r\n");
            }
            return (sb.toString());
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return ("");

    }

}
