/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.setup;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.openexchange.guard.config.Config;
import com.openexchange.guard.server.HandleArgs;

public class Check {
	
	private static Logger logger = LoggerFactory.getLogger(Check.class);

    // Set version of database here. For upgrades
    private static final int version = Config.version;

    /**
     * Class to check configuration and database connections. Run main program with argument 'config' if want initial setup to run
     * 
     * @param args
     * @return
     */
    public static boolean confirm(String[] args) {

        try {
            File f = new File(Config.getRoot() + Config.fileName);
            if (!f.exists()) {
                System.out.println("Missing config file: " + Config.getRoot() + Config.fileName);
                Runtime.getRuntime().halt(1);
            }
            Config.loadConfig();
            String mysqlIP = com.openexchange.guard.config.Config.getMysqlIP();// IP address of configdb
            String mysqlUsername = com.openexchange.guard.config.Config.getMysqlUsername();
            String mysqlPassword = com.openexchange.guard.config.Config.getMysqlPassword();
            String OGmysqlIP = com.openexchange.guard.config.Config.getMysqlIPOxGuard();
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            String ConfigmysqlConnectionString = Config.getConfigDbConnectionString();
            String OGmysqlConnectionString = "jdbc:mysql://" + OGmysqlIP + "/oxguard?user=" + mysqlUsername + "&password=" + mysqlPassword;

            Connection conn = null;
            int i = 1;
            while (conn == null) {
            	try {
                	conn = DriverManager.getConnection(ConfigmysqlConnectionString);
                } catch (com.mysql.jdbc.exceptions.jdbc4.CommunicationsException e) {
                	logger.error("Unable to connect to mysql.  Waiting 15 seconds for startup and trying again (attempt " + i++ + ")");
                	Thread.sleep(15000);
                }
            }
            Statement stmt = conn.createStatement();
            ResultSet rs;
            rs = stmt.executeQuery("SELECT * FROM db_pool");
            if (rs.next()) {
                logger.debug("OK Connection to configdb");
            } else {
                logger.error("Unable to connect to configdb");
                System.out.println("Unable to connect to configdb");
                rs.close();
                stmt.close();
                conn.close();
                return (false);
            }
            rs.close();
            stmt.close();
            conn.close();
            try {
                Connection ogcon = DriverManager.getConnection(OGmysqlConnectionString);
                Statement ogst = ogcon.createStatement();
                ResultSet ogrs = ogst.executeQuery("SELECT * FROM global_settings WHERE global_settings.key = 'version'");
                if (ogrs.next()) {
                    int installedversion = ogrs.getInt("value");
                    if (installedversion < version) {
                        logger.info("Upgrade required");
                        // Call later
                        /* Upgrader upgrade = new Upgrader();
                        if (!upgrade.doUpgrade(installedversion, version)) {
                            logger.error("Unable to do database upgrade");
                            ogrs.close();
                            ogst.close();
                            ogcon.close();
                            return (false);
                        } else {
                            logger.info("OK Update database");
                        }
                        */
                    }
                    rs.close();
                    ogst.close();
                    conn.close();
                    logger.debug("OK Connection to oxguard database");
                    if (args.length == 0) {
                        logger.debug("Configuration seems good");
                    	if (Config.mpass.equals("")) {
                    		logger.error("Password file required");
                    		System.out.println("Failed to start, missing password file");
                    		Runtime.getRuntime().halt(1);
                    		return(false);
                    	}
                    }
                    return (true);
                }
                rs.close();
                conn.close();
            } catch (Exception ex) {
                System.out.println("Unable to connect OxGuard");
                if (HandleArgs.handle(args)) Runtime.getRuntime().halt(0);
                logger.error("Unable to connect to OxGuard", ex);
            }
            logger.error("Unable to connect to oxguard database.  If first run, then use argument init?");
            System.out.println("Unable to connect to oxguard database.  If first run, then use argument init?");
            return (false);
        } catch (Exception e) {
            logger.error("Unable to start", e);
            System.out.println("Unable to start.  Check mysql and Guard log files");
            return (false);
        }

    }
}
