package com.openexchange.guard.server;

import java.io.IOException;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.openexchange.guard.database.DbCommand;
import com.openexchange.guard.database.DbQuery;
import com.openexchange.guard.ox.Api;
import com.openexchange.guard.util.Core;

public class GuardSettings {
	private static Logger logger = LoggerFactory.getLogger(Settings.class);
	
	 public void setSettings(HttpServletRequest request, HttpServletResponse response, OxCookie cookie) throws Exception {
		 JsonObject data = Core.getJSON(request);
		 Api ap = new Api(cookie, request);
		 if (!ap.verifyLogin()) {
			 Core.sendFail(response, "Must be logged in");
			 return;
		 }
		 int id = 0;
		 int cid = 0;
		 try {
			 id = data.get("id").getAsInt();
			 cid = data.get("cid").getAsInt();
			 
		 } catch (Exception ex) {
			 logger.error("Bad arguments ", ex);
			 return;
		 }
		 boolean defaultGuard = (data.get("defaultGuard") == null ? false : data.get("defaultGuard").getAsBoolean());
		 JsonObject current = getCurrentSettings (id, cid);
		 JsonObject settingsData = data.get("data").getAsJsonObject();
		 for (Map.Entry<String, JsonElement> entry : settingsData.entrySet()) {
			 if (current.has(entry.getKey())) {
				 current.remove(entry.getKey());
				 current.add(entry.getKey(), entry.getValue());
			 } else {
				 current.add(entry.getKey(), entry.getValue());
			 }
		 }
		 if (saveCurrentSettings (id, cid, current.toString())) {
			 Core.sendOK(response, "done");
		 } else {
			 Core.sendFail(response, "Fail");
		 }
	 }
	 
	 private JsonObject getCurrentSettings (int id, int cid) throws Exception {
		 JsonObject result = new JsonObject();
		 String command = "SELECT settings FROM og_KeyTable WHERE id = ? and cid = ?";
		 DbCommand com = new DbCommand(command);
		 com.addVariables(id);
		 com.addVariables(cid);
		 DbQuery db = new DbQuery();
		 db.read(com, id, cid);
		 if (db.next()) {
			 if (db.rs.getString("settings") == null) {
				 db.close();
				 return(result);
			 }
			 JsonParser parser = new JsonParser();
			 result = (JsonObject) parser.parse(db.rs.getString("settings"));
		 }
		 db.close();
		 return(result);
	 }
	 
	 private boolean saveCurrentSettings (int id, int cid, String settings)  {
		 String command = "UPDATE og_KeyTable SET og_KeyTable.settings = ? WHERE og_KeyTable.id = ? and cid = ?";
		 DbCommand com = new DbCommand(command);
		 com.addVariables(settings);
		 com.addVariables(id);
		 com.addVariables(cid);
		 DbQuery db = new DbQuery();
		 try {
		 	db.write(com, id, cid);
		 } catch (Exception e) {
			 logger.error("Error updating settings ", e);
			 return(false);
		 }
		 return (true);
		 
	 }
}
