package com.openexchange.guard.mail;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.openexchange.guard.encr.Crypto;
import com.openexchange.guard.encr.EncrLib;
import com.openexchange.guard.encr.EncryptedObj;
import com.openexchange.guard.mailcreator.Attachment;
import com.openexchange.guard.server.OxCookie;
import com.openexchange.guard.server.UserData;
import com.openexchange.guard.storage.Storage;
import com.openexchange.guard.util.Core;

public class UploadGuest {

	private static Logger logger = LoggerFactory.getLogger(UploadGuest.class);
	
	public void incomingEmailForm(HttpServletRequest request, HttpServletResponse response, OxCookie cookie) throws Exception {
		String auth = Core.getStringParameter(request, "auth", true);
		cookie.JSESSIONID = cookie.OxReaderID;
		UserData user = new UserData(auth, cookie);
		if (user.userid < 0) {
			Core.sendFail(response, "Bad auth");
			return;
		}
		ArrayList<EncryptedObj> attachments = new ArrayList<EncryptedObj>();// Get list of all attachments
        FileItemFactory fif = new DiskFileItemFactory();
        ServletFileUpload sfu = new ServletFileUpload(fif);
        List files = sfu.parseRequest(request);
        Iterator iterator = files.iterator(); // Iterate through attachments
        while (iterator.hasNext()) {
            FileItem fi = (FileItem) iterator.next();
            String name = fi.getName(); // Otherwise, assume it is an attachment
            if (name != null) {// Make sure the name of the file exists, may just be blank field
                if (name.trim() != "") {
                    if (name.lastIndexOf("\\") > -1) {
                        name = name.substring(name.lastIndexOf("\\"));
                    }
                    if (name.lastIndexOf("/") > -1) {
                        name = name.substring(name.lastIndexOf("/"));
                    }
                    InputStream input = fi.getInputStream();
                    EncryptedObj item = new EncryptedObj(input);
                    item.name = name;
                    item.type = fi.getContentType();
                    attachments.add(item);
                    input.close();
                }
            }
        }
        if (attachments.size() == 0) {
        	Core.sendFail(response, "No data");
        	return;
        }
        // Check legit files
        String itemId = null;
        boolean fail = false;
        // Check all itemIds match
        for (int i = 0; i < attachments.size(); i++) {
        	String id = attachments.get(i).ItemID;
        	if (id == null) fail = true;  // No itemId found 
        	if (itemId == null) {
        		itemId = id;
        	} else {
        		if (!itemId.equals(id)) fail = true;  // all itemIds should match
        	}
        }
        if (fail) {
        	Core.sendFail(response, "Not valid Guard files");
        	return;
        }
        // Check decodable guard files
        Crypto crypto = new Crypto();
        for (int i = 0; i < attachments.size(); i++) {
        	String decoded = crypto.decodeEncrObj(user.userid, user.cid, attachments.get(i), user.encr_password, null);
        	if (decoded == null) {
        		Core.sendFail(response, "not decodable");
        		return;
        	}
        }
        for (int i = 0; i < attachments.size(); i++) {
        	EncryptedObj item = attachments.get(i);
        	String id = item.ItemID;
        	if (!item.name.toLowerCase().startsWith(id.toLowerCase())) {  // If not the email file, att the filename suffix
        		id = id + "-" + item.name.replace(".grd2", "").replace(".grd", "");
        	}
        	if (!Storage.saveEncrObj(user.userid, user.cid, id, Crypto.addHeader(new String(item.content), item.ItemID, item.length))) {
        		Core.sendFail(response, "Storage failure");
        		return;
        	}
        }
        Core.sendOK(response, "OK");
	}
}
