package com.openexchange.guard.mail;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;

import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

import org.apache.commons.io.IOUtils;

import com.openexchange.guard.mailcreator.Attachment;

public class MimeParser {

	ArrayList<Attachment> attachments = new ArrayList<Attachment> ();
	MimeMessage message;
	
	MimeParser (byte[] email) throws MessagingException {
		Session s = Session.getDefaultInstance(new Properties());
    	InputStream is = new ByteArrayInputStream(email);
    	message = new MimeMessage(s, is);
	}
	
	public void ParseAttachments () throws MessagingException, IOException {
		Object content = message.getContent();  
	    if (content instanceof Multipart || content instanceof MimeMultipart)  {
	    	Multipart mp = (Multipart)content;
	    	parseMultipart (mp);
	    }
	}
	
	public void parseMultipart(Multipart mp) throws IOException, MessagingException  
	{  
	    int count = mp.getCount();  
	    for (int i = 0; i < count; i++)  
	    {  
	        BodyPart bp = mp.getBodyPart(i);  
	        Object content = bp.getContent();  
	        if (content instanceof String)  
	        {  // Check if this string is a text attachment, or just the message body
	        	if (bp.getDisposition() != null) {
	        		if (bp.getDisposition().contains("attachment")) {
	        			Attachment att = new Attachment();
	    	        	att.content = ((String) content).getBytes();
	    	        	att.filename = bp.getFileName();
	    	        	att.type = bp.getContentType();
	    	        	if (att.type.contains(";")) {
	    	        		att.type = att.type.substring(0, att.type.indexOf(";"));
	    	        	}
	    	        	attachments.add(att);
	        		}
	        	}

	        }  
	        else if (content instanceof InputStream)  
	        {  

	        	Attachment att = new Attachment();
	        	att.content = IOUtils.toByteArray((InputStream) content);
	        	att.filename = bp.getFileName();
	        	att.type = bp.getContentType();
	        	if (att.type.contains(";")) {
	        		att.type = att.type.substring(0, att.type.indexOf(";"));
	        	}
	        	attachments.add(att);
	            // handle input stream  
	        }  
	        else if (content instanceof Message)  
	        {  
	            Message message = (Message)content;  
	            // Nested message
	        }  
	        else if (content instanceof Multipart || content instanceof MimeMultipart)  
	        {  
	            Multipart mp2 = (Multipart)content;  
	            parseMultipart(mp2);  
	        }  
	    }  
	} 
	
	public void mergeAttachments (ArrayList<Attachment> prevattachments) {
		for (int i = 0; i < attachments.size(); i++) {
			prevattachments.add(attachments.get(i));
		}
	}
}
