package com.openexchange.guard.mail;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.config.OxConfiguration;
import com.openexchange.guard.database.DbCommand;
import com.openexchange.guard.database.DbQuery;
import com.openexchange.guard.database.EmailInfo;
import com.openexchange.guard.database.RecipKey;
import com.openexchange.guard.encr.Crypto;
import com.openexchange.guard.encr.EncrLib;
import com.openexchange.guard.encr.EncryptedObj;
import com.openexchange.guard.exceptions.GuardMissingParameter;
import com.openexchange.guard.mailcreator.Attachment;
import com.openexchange.guard.mailcreator.Mail;
import com.openexchange.guard.ox.Api;
import com.openexchange.guard.server.Auth;
import com.openexchange.guard.server.OxCookie;
import com.openexchange.guard.server.UserData;
import com.openexchange.guard.server.Settings.permissions;
import com.openexchange.guard.util.Core;

public class Draft {

	private static Logger logger = LoggerFactory.getLogger(Draft.class);

	   OxCookie cookie;
	    HttpServletRequest req;
	    String sessionId;

	    public Draft(OxCookie ck, HttpServletRequest rq) {
	        cookie = ck;
	        req = rq;
	        sessionId = rq.getParameter("session");
	    }
		
	/**
	 * Incoming email form for draft email only.  Does not save to recipients, only the owner
	 * @param request
	 * @param response
	 * @throws IOException
	 * @throws GuardMissingParameter 
	 */
	public void incomingEmailForm(HttpServletRequest request, HttpServletResponse response) throws IOException, GuardMissingParameter {
        FileItemFactory fif = new DiskFileItemFactory();
        ServletFileUpload sfu = new ServletFileUpload(fif);
        String itemID = EncrLib.getUUID(); // One itemID for email and it's attachments
        String salt = EncrLib.getsalt();// Create salt
        int userid = Core.getIntParameter(request, "userid", true);
        int cid = Core.getIntParameter(request, "cid", true);
        String language = Core.getStringParameter(request, "lang");
        int templId = request.getParameter("templid") == null ? 0 : Integer.parseInt(request.getParameter("templid"));
        String msgref = null;
        boolean extraPass = false;
        
    	Api ap = new Api(cookie, request);
    	if (!ap.verifyLogin()) {
    		logger.error("not logged into ui");
            Core.sendFail(response, "not authorized");
            return;
    	}
        	   // Load custom template Id for this user
       
        
        Crypto crypt = new Crypto();
        String contentKey = crypt.createContentKey();
        try {
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();// Get list of all attachments
            String emaildata = "";
            List files = sfu.parseRequest(request);
            sessionId = request.getParameter("session");
            Iterator iterator = files.iterator(); // Iterate through attachments
            while (iterator.hasNext()) {
                FileItem fi = (FileItem) iterator.next();
                String name = fi.getFieldName();
                if (name.startsWith("guest_message")) {
                    continue;
                }
                if (name.startsWith("json")) { // Field name json is the email data (or should be). So get email data
                    emaildata = fi.getString("UTF-8");
                } else {
                    name = fi.getName(); // Otherwise, assume it is an attachment
                    if (name != null) {// Make sure the name of the file exists, may just be blank field
                        if (name.trim() != "") {
                            if (name.lastIndexOf("\\") > -1) {
                                name = name.substring(name.lastIndexOf("\\"));
                            }
                            if (name.lastIndexOf("/") > -1) {
                                name = name.substring(name.lastIndexOf("/"));
                            }
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            InputStream input = fi.getInputStream();
                            IOUtils.copy(input, out); // Copy stream to byte array
                            Attachment attach = new Attachment();
                            attach.content = out.toByteArray(); // Populate attachment data
                            attach.filename = fi.getName();

                            attach.type = fi.getContentType();
                            attachments.add(attach); // Add to our array of attachments
                            out.close();
                            input.close();
                        }
                    }
                }
            }
            if (emaildata != "") { // We must have the basic email data
                JsonParser jsonParser = new JsonParser(); // Put it into json
                JsonObject json = (JsonObject) jsonParser.parse(emaildata);
                JsonObject data = json.getAsJsonObject("data");
                
                // Encrypt email
                JsonObject header = data.getAsJsonObject("headers");
                String extrapass = "";
                try {
                    if (header.has("X-OxGuard-ExtraPass")) extrapass = header.get("X-OxGuard-ExtraPass").getAsString();
                } catch (Exception e) {
                    logger.error("Problem getting extra pass " + e.toString());
                }

                // Get infostore attachments
                try {
                    if (!data.get("infostore_ids").isJsonNull()) {
                        JsonArray infostores = data.get("infostore_ids").getAsJsonArray();
                        if (infostores != null) {
                            for (int i = 0; i < infostores.size(); i++) {
                                Attachment attach = Incoming.getInfoAttach(infostores.get(i).getAsJsonObject(), request, cookie);
                                if (attach != null) 
                                	attachments.add(attach);
                            }
                        }
                    }
                } catch (Exception ex2) {
                    logger.error("Problem extracting infostore items.", ex2);

                }
                // Search for inline images, convert to attachments
                Incoming.getInlineImages (data, attachments, request, cookie);
                
                // Search for attachments that reference a draft email, and aren't actually supplied.
                Incoming.getDraftAttachments (data, attachments, request, cookie, userid, cid);
                
                if (data.has("sendtype")) {
                	if (data.get("sendtype").getAsInt() == 3) {
                		try {
                			msgref = data.get("msgref").getAsString();
                		} catch (Exception ex) {
                			logger.error("Unable to get msgref from mail data", ex);
                		}
                	}
                }
                
                String mailId = "<OxGuard-" + EncrLib.getUUID() + ">";
                ArrayList<RecipKey> recipients = new ArrayList<RecipKey>();  // No recipient keys in draft
                
                try {
                	
                    // Let's encrypt the email
                    long exp = Incoming.getExpDate(data);
                    String oxemail = Mail.PrepareOXEmail(data, attachments, exp, mailId);
                    if (!extrapass.equals("")) {// if extra password specified, then encrypt first with aes
                        logger.debug("encrypting with extra password");
                        extraPass = true;
                        oxemail = crypt.addExtraPass(oxemail, extrapass, itemID);
                    }
                    String encrypted = crypt.EncryptEmail(userid, cid, recipients, oxemail, exp, 1, "", itemID, contentKey, salt);
                    if (encrypted == null) {
                        com.openexchange.guard.util.Core.sendFail(response, "Failed to send");
                        return;
                    }
                    Attachment main = new Attachment();
                    main.encrContent = Crypto.addHeader(encrypted, itemID, -1); // Add the header
                    main.filename = itemID + ".grd"; // Our email filename is the itemID + .loc
                    main.type = "text/plain";
                    attachments.add(main); // Add it to our list of attachments for the email

                } catch (SQLException e) {
                    logger.error("Error while trying to encrypt email for item " + itemID, e);
                    com.openexchange.guard.util.Core.sendFail(response, "Failed to send");
                    return;

                }

                // Encrypt the attachments, using the same content key as for the email.

                
                for (int i = 0; i < attachments.size(); i++) {
                    Attachment attach = attachments.get(i);
                    if (attach.encrContent == null) {// Make sure this isn't the email
                        // Check if attachments are encrytped objects

                        if (com.openexchange.guard.util.Core.isEncrItem(attach.content)) {
                            try {
                                logger.debug("already encrypted");
                               
                            } catch (Exception ex) {
                                logger.debug("Failed to decode attachments");
                                com.openexchange.guard.util.Core.sendFail(response, "FailDecodeAttach");
                                return;
                            }

                        }

                        attach.filename += ".grd";

                        if (!extrapass.equals("")) {
                            attach.encrContent = crypt.encrItem(
                                userid,
                                cid,
                                recipients,
                                crypt.addExtraPass(Base64.toBase64String(attach.content), extrapass, itemID),
                                Incoming.getExpDate(data),
                                2,
                                "",
                                itemID,
                                contentKey,
                                true,
                                attach.filename);
                           
                            attach.filename = attach.filename.replace(".grd", ".grd2"); // mark the attachment as extra password
                        } else {
                            attach.encrContent = crypt.encrItem(
                                userid,
                                cid,
                                recipients,
                                Base64.toBase64String(attach.content),
                                Incoming.getExpDate(data),
                                2,
                                "",
                                itemID,
                                contentKey,
                                true,
                                attach.filename);
                        }

                        attachments.set(i, attach);
                    }
                }
                // Save
                Mail mf = new Mail();
                JsonObject email = mf.createBlankOutMail(language, templId);
                for (int i = 0; i < recipients.size(); i++) {
                    email = mf.addTo(email, recipients.get(i).name, recipients.get(i).email, recipients.get(i).type);
                }
                JsonObject emailData = email.get("data").getAsJsonObject();
                emailData.addProperty("sendtype", 4);
                emailData.addProperty("flags", 4);
                JsonObject headers = data.get("headers").getAsJsonObject();
                headers.addProperty("X-OxGuard-ID", itemID);
                if (extraPass) headers.addProperty("X-OxGuard-ExtraPass", true);
                emailData.add("to", data.get("to"));
                emailData.add("cc", data.get("cc"));
                emailData.add("bcc", data.get("bcc"));
                emailData.add("subject", data.get("subject"));
                emailData.add("from", data.get("from"));
                emailData.add("headers", data.get("headers"));

                email = mf.addURL(email, "https://" + Config.OXUrl);

                JsonObject result = ap.saveDraftMail(email, attachments);
                if (!Core.checkFail(result)) {
                	if (msgref != null) {
                		int br = msgref.lastIndexOf("/");
                		int id = Integer.parseInt(msgref.substring(br + 1));
        	    		String folder = msgref.substring(0, br);
        	    		deleteEmailRecord (ap.getMail(id, folder), userid, cid);
        	    		ap.deleteDraft(msgref);
                	}
                	Core.sendOK(response, result.toString());
                } else Core.sendFail(response, "Fail");
                
                

            } else {// Our reply that the email was blank
                com.openexchange.guard.util.Core.sendOK(response, "No Email Data");
            }

        } catch (Exception ex) {// General failure response
            com.openexchange.guard.util.Core.sendFail(response, "Fail");
            logger.error("Unspecified error", ex);
        }
    }
	
	/**
	 * Removes Guard content Key and encrypted item record for the draft email
	 * @param emailString
	 * @param userid
	 * @param cid
	 */
	private void deleteEmailRecord (String emailString, int userid, int cid) {
		try {
			JsonObject email = Core.getJSON(emailString);
			JsonObject headers = email.get("data").getAsJsonObject().get("headers").getAsJsonObject();
			JsonArray attachments = email.get("data").getAsJsonObject().get("attachments").getAsJsonArray();
			if (headers.has("X-OxGuard-ID")) {
				String id = headers.get("X-OxGuard-ID").getAsString();
				boolean confirm = false;
				// Quick sanity check.  Make sure has Guard attachment
				for (int i = 0; i < attachments.size() && !confirm; i++) {
					JsonElement name = attachments.get(i).getAsJsonObject().get("filename");
					if (name != null) {
						if (name.getAsString().contains(id)) {
							confirm = true;
						}
					}
				}
				if (confirm) {  // If confirmed, go ahead and delete records of the email
					String command = "DELETE FROM og_encrypted_items WHERE Id = ? AND Owner = ? AND Owner_cid = ?";
					DbCommand com = new DbCommand(command);
					com.addVariables(id);
					com.addVariables(userid);
					com.addVariables(cid);
					DbQuery db = new DbQuery();
					db.writeToDB(com, cid);
					command = "DELETE FROM og_content_keys WHERE ItemId = ? AND UserId = ? AND CID = ?";
					com = new DbCommand(command);
					com.addVariables(id);
					com.addVariables(userid);
					com.addVariables(cid);
					db.writeToDB(com, cid);
				}
			}
		} catch (Exception ex) {
			logger.error("Unable to delete Guard data for deleted draft email", ex);
		}
	}
	
}
