/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.database;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.server.OxDbConn;
import com.openexchange.guard.validator.Normalizer;

public class Utilities {

	private static Logger logger = LoggerFactory.getLogger(Utilities.class);
    
	private JsonObject getOgRequest(String unit, String action, String parameters) throws Exception {
		String url = "http" + (Config.backend_ssl ? "s" : "") + "://" + Config.getOxBackend() + ":" + Config.ox_backend_port + "/preliminary/utilities/" + unit + "/v1/" + action + "/" + parameters;
		return(getOgRequest(url));
	}
	
    private JsonObject getOgRequest(String url) throws Exception {

        JsonObject result = null;
        CloseableHttpClient httpClient = OxDbConn.httpClient;
        HttpContext context = HttpClientContext.create();
        HttpGet getRequest = new HttpGet(url);
        getRequest.addHeader("accept", "application/json");
        getRequest.addHeader("Authorization", "Basic " + Config.getBasicAuthenticationEncoding());
        CloseableHttpResponse response = httpClient.execute(getRequest, context);
        if (response.getStatusLine().getStatusCode() != 200) {
        	try {
        		EntityUtils.consume(response.getEntity());
        		getRequest.releaseConnection();
        		response.close();
        	} catch (Exception e2) {
        		logger.error("unable to close http stream after error", e2);
        	}
        	String resp = response.getStatusLine().getReasonPhrase();
        	if (resp != null) {
        		if (resp.contains("Cannot find user")) {
        			result = new JsonObject();
        			result.addProperty("user", "not found");
        			return(result);
        		}
        	}
        	logger.error("Error getting user data from backend " + response.getStatusLine().getReasonPhrase());
        	
            throw new Exception("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
        }
        result = getJson(response);
        EntityUtils.consume(response.getEntity());
        response.close();
        getRequest.releaseConnection();
        return (result);

    }
    

    /**
     * Format response into a JSON object
     * 
     * @param response
     * @return
     * @throws UnsupportedEncodingException
     * @throws IllegalStateException
     * @throws IOException
     */
    private JsonObject getJson(HttpResponse response) throws UnsupportedEncodingException, IllegalStateException, IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
        JsonParser parser = new JsonParser();
        JsonObject result = (JsonObject) parser.parse(reader);
        reader.close();
        return (result);
    }

    public JsonObject getUser(String email) throws Exception {
    	email = URLEncoder.encode(email, "UTF-8");
    	// If mailReolverUrl is not defined in the configuration file, use default utilities
    	if (Config.mailResolverUrl == null) {
    		return (getOgRequest("mailResolver", "resolve", email));
    	} // Otherwise, use the assigned URL, adding the email address to the end
    	else return (getOgRequest(Config.mailResolverUrl + email));
    }

}
