/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.database;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class OxResultSet {

	private static Logger logger = LoggerFactory.getLogger(OxResultSet.class);

    public JsonObject row;

    public OxResultSet(JsonElement rs) {
        this.row = (JsonObject) rs;
    }

    public String getString(String name) {
        if (row.get(name).isJsonNull())
            return (null);
        return (row.get(name).getAsString());
    }

    public int getInt(String name) {
        return (row.get(name).getAsInt());
    }

    public long getLong(String name) {
        return (row.get(name).getAsLong());
    }
    
    public boolean isNull (String name) {
    	return (row.get(name).isJsonNull());
    }

    public java.sql.Date getDate(String name) {
        if (row.get(name).isJsonNull())
            return (null);
        String date = row.get(name).getAsString();
        java.sql.Date dt = null;
        try {
            java.util.Date udate = new SimpleDateFormat("yyyy-M-dd", Locale.ENGLISH).parse(date);
            dt = new java.sql.Date(udate.getTime());
        } catch (ParseException e) {
            logger.error("Error getting date from " + name, e);
            return (null);
        }
        return (dt);
    }

    public java.sql.Timestamp getTimestamp(String name) {
        String datetime = row.get(name).getAsString();
        java.sql.Timestamp ts = null;
        try {
            Date dt = new SimpleDateFormat("yyyy-M-dd HH:mm:ss", Locale.ENGLISH).parse(datetime);
            ts = new java.sql.Timestamp(dt.getTime());
        } catch (Exception ex) {
            return (null);
        }
        return (ts);
    }
}
